package cn.bsystem.ptuserrole.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.MD5Util;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.bsystem.ptuserrole.service.PtyhService;
import cn.yw.ywuserrolerelation.service.YwuserrolerelationService;

@SuppressWarnings({"all"})
@Component("ptyhAction")
public class PtyhAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtyhAction.class);
	
	@Autowired
	private PtyhService service;
	@Autowired
	private YwuserrolerelationService ywuserrolerelationService;
	 
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhByPage")
	public void listPtyhByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyhByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - listPtyhByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptyh")
	public void count_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - count_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptyh
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptyh")
	public void query_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - query_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void query_ptyh_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.query_ptyh_ext(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - query_ptyh_ext() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һPtyh
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptyh")
	public void get_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - query_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyh")
	public void delete_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){				
	// ===========   3 Ȩ   ޸        start =============================================
				String yhbh = (String) map.get("yhbh");
				Map ywMap = new HashMap();
				ywMap.put("usernum",yhbh);
				int ywnum = ywuserrolerelationService.delete_Ywuserrolerelation(ywMap);
	// ===========   3 Ȩ   ޸        start =============================================			
				int result = service.delete_Ptyh(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - delete_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyh")
	public void insert_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			/*if(StringUtil.checkEmpty(map.get("yhbh"))){
				map.put("yhbh",StringUtil.getUUID());
			}*/
			if(!StringUtil.checkEmpty(map.get("yhmm"))){
				map.put("yhmm", MD5Util.md5(map.get("yhmm").toString()));
			}
			
	 //  3 Ȩ   ޸		ȡû            start ==========================================
			String uuid = (String) map.get("yhbh");
			if(StringUtil.checkEmpty(uuid)) {
				uuid = StringUtil.getUUID();
				map.put("yhbh",uuid);
			}
			Map ywMap = new HashMap();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			String isadministrator = (String) map.get("sfgly");		//ǷԱ
			String useraccount = (String) map.get("yhzh");			//û˺
			String seealarmauthory = (String) map.get("ckgjqx");	//鿴澯Ȩ
			String receivealarmsms = (String) map.get("jsdxqx");	//ո澯
			String isapprovalauthory = (String) map.get("gdspqx");	//Ȩ
			String extend1 = (String) map.get("extend1");	//ѡƻȨ
			ywMap.put("relationid", StringUtil.getUUID());
			ywMap.put("usernum", uuid);
			ywMap.put("isadministrator", isadministrator);
			ywMap.put("useraccount", useraccount);
			ywMap.put("seealarmauthory", seealarmauthory);
			ywMap.put("receivealarmsms", receivealarmsms);
			ywMap.put("isapprovalauthory", isapprovalauthory);
			ywMap.put("extend1", extend1);
			ywMap.put("createaccount", username);		
			ywMap.put("createtime", DateUtil.currentDateTime());
			ywMap.put("modifyaccount", username);		
			ywMap.put("modifytime", DateUtil.currentDateTime());
			ywuserrolerelationService.insert_Ywuserrolerelation(ywMap);
	//  3 Ȩ   ޸                   end ==============================================
			service.insert_Ptyh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - listPtyhByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyh")
	public void update_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
	// ===========   3 Ȩ   ޸        start =============================================
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String yhbh = (String) map.get("XGTJyhbh");
			String seealarmauthory = (String) map.get("ckgjqx");	//鿴澯Ȩ
			String receivealarmsms = (String) map.get("jsdxqx");	//ո澯
			String isapprovalauthory = (String) map.get("gdspqx");	//Ȩ
			String extend1 = (String) map.get("extend1");	//ѲƻȨ
			Map ywMap = new HashMap();
			String username = ptyh.getYhzh();
			ywMap.put("XGTJusernum", yhbh);
			ywMap.put("seealarmauthory", seealarmauthory);
			ywMap.put("receivealarmsms", receivealarmsms);
			ywMap.put("isapprovalauthory", isapprovalauthory);
			ywMap.put("extend1", extend1);
			ywMap.put("modifyaccount", username);		
			ywMap.put("modifytime", DateUtil.currentDateTime());
			int ywnum = ywuserrolerelationService.update_Ywuserrolerelation(ywMap);
			if(ywnum == 0) {								// δµ һ					
				String isadministrator = (String) map.get("sfgly");
				String useraccount = (String) map.get("yhzh");
				ywMap.put("relationid", StringUtil.getUUID());
				ywMap.put("usernum", yhbh);
				ywMap.put("isadministrator", isadministrator);
				ywMap.put("useraccount", useraccount);
				ywMap.put("createaccount", username);		
				ywMap.put("createtime", DateUtil.currentDateTime());
				ywMap.put("modifytime", DateUtil.currentDateTime());
				ywuserrolerelationService.insert_Ywuserrolerelation(ywMap);				
			}
	// ===========   3 Ȩ   ޸         end =============================================		
			int result = service.update_Ptyh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - update_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyh_pwd")
	public void update_Ptyh_pwd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("yhmm"))){
				map.put("yhmm", MD5Util.md5(map.get("yhmm").toString()));
			}
			int result = service.update_Ptyh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - update_Ptyh_pwd() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptyh")
	public void batch_delete_Ptyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptyh(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - batch_delete_Ptyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtyh(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtyhAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyh_sbqx_ByPage")
	public void listPtyh_sbqx_ByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyh_sbqx_ByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - listPtyh_sbqx_ByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ûȷȨ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyh_sbjqqx_ByPage")
	public void listPtyh_sbjqqx_ByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyh_sbjqqx_ByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - listPtyh_sbjqqx_ByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ûͨȨ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyh_sbtpqx_ByPage")
	public void listPtyh_sbtpqx_ByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyh_sbtpqx_ByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhAction - listPtyh_sbtpqx_ByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
