package cn.bsystem.ptmenu.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractAttribute;

import cn.bsystem.ptmenu.model.MenuNode;

public class MenuXml {
	private static final Logger iLog = Logger.getLogger(MenuXml.class);
	private static List<MenuNode> listFirst = new ArrayList<MenuNode>();
	private static List<MenuNode> listSecond = new ArrayList<MenuNode>();
	private static List<MenuNode> listThird = new ArrayList<MenuNode>();
	private static List<HashMap<String,String>> listRight = new ArrayList<HashMap<String,String>>();
	private static String menuType  = null;
	private static MenuXml menuxml  = new MenuXml();
	
	public static MenuXml getInstance() {
		return menuxml;
	}
	
	public List<MenuNode> getFirstMenuNode(){
		return listFirst;
	}
	
	public String getMenuType(){
		return menuType;
	}
	//return all roleright menu
	public List<HashMap<String,String>>  getRightMenuNode(){
		return listRight;
	}
	
	public List<MenuNode> geSecondMenuNodeByFirstId(String firstMenuId){
		if(listSecond.size()<=0){
			parseMenuXml();
			return null;
		};
		List<MenuNode> listItem = new ArrayList<MenuNode>();
		for (MenuNode menu  : listSecond) {
			if (menu.getParentId().equals(firstMenuId)) {
				listItem.add(menu);
			}
		}
		return listItem;
	}
	
	public List<MenuNode> geThirdMenuNodeBySecond(String secondMenuId){
		if(listThird.size()<=0){
			parseMenuXml();
			return null;
		};
		List<MenuNode> listItem = new ArrayList<MenuNode>();
		for (MenuNode menu  : listThird) {
			if (menu.getParentId().equals(secondMenuId)) {//ŲȨ޲˵item
				listItem.add(menu);
			}
		}
		return listItem;
	}
	public void parseMenuXml() {
		String m =this.getClass().getResource("/").getPath()+"menu.xml";
		File xmlFile = new File(m);
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(xmlFile);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.info("menu.xml˵·ȷ" + m);
		}

		try {
			SAXReader saxReader = new SAXReader();
			Document doc = saxReader.read(fis);
			Element root = doc.getRootElement();
			menuType = root.attribute("menuType").getValue();
			iLog.info("menuType:" + menuType );
			for (Iterator<?> iter = doc.selectNodes(
					"//menu/MenuNode/MenuNode/MenuNode").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				MenuNode menu = parseMenuNodeAttr(element);
				if(menu != null) listThird.add(menu);
			}
			for (Iterator<?> iter = doc.selectNodes("//menu/MenuNode/MenuNode")
					.iterator(); iter.hasNext();) {
				Element element = (Element) iter.next();
				MenuNode menu = parseMenuNodeAttr(element);
				if(menu != null) listSecond.add(menu);
			}
			for (Iterator<?> iter = doc.selectNodes("//menu/MenuNode").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				MenuNode menu = parseMenuNodeAttr(element);
				if(menu != null) listFirst.add(menu);
			}
			MenuNodeAddToParent(listThird, listSecond);
			MenuNodeAddToParent(listSecond, listFirst);
			
			System.out.println(listRight);
			System.out.println(listFirst);
			System.out.println(listSecond);
		} catch (DocumentException e) {
			e.printStackTrace();
			iLog.info("˵ļʽȷ." + e);
		}
	}

	public void MenuNodeAddToParent(List<MenuNode> listChild,
			List<MenuNode> listParent) {
		for (MenuNode menuparent : listParent) {
			for (MenuNode menuchild : listChild) {
				if (menuchild.getParentId().equals(menuparent.getMenuId())) {
					menuparent.addSubMenuNode(menuchild);
				}
			}
		}
	}

	public String getParentElementMenuId(Element element) {
		String menuId = null;
		for (Iterator<?> iter1 = element.getParent().attributes().iterator(); iter1
				.hasNext();) {
			AbstractAttribute abattr = (AbstractAttribute) iter1.next();
			if (abattr.getName().equals("menuId")) {
				menuId = abattr.getValue();
				break;
			}
		}
		return menuId;
	}

	public MenuNode parseMenuNodeAttr(Element element) {
		MenuNode menu = new MenuNode();
		String parentId = getParentElementMenuId(element);
		if (StringUtils.isNotBlank(parentId)) {
			menu.setParentId(parentId);
		}
		boolean isRightMenu = false;
		for (Iterator<?> iter1 = element.attributes().iterator(); iter1.hasNext();) {
			AbstractAttribute abattr = (AbstractAttribute) iter1.next();
			if (abattr.getName().equals("rightName")) {
				menu.setRightName(abattr.getValue());
				isRightMenu = true;
				continue;
			}
			if (abattr.getName().equals("menuId")) {
				menu.setMenuId(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("menuName")) {
				menu.setMenuName(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("url")) {
				menu.setUrl(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("display")) {
				menu.setDisplay(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("iconCls")) {
				menu.setIconCls(abattr.getValue());
				continue;
			}
		}
		
		if(isRightMenu){
			HashMap<String,String> h = new HashMap<String,String>();
			h.put(menu.getRightName(), menu.getMenuId());
			listRight.add(h);
		}
		return menu;
	}
	
	public List<MenuNode>  menuNodeFilter(List<MenuNode> items){
		try {
			Iterator<MenuNode> it = items.iterator();
			while(it.hasNext())
			{
				MenuNode item = it.next();
				if(item.getRightName()!=null &&  !"".equals(item.getRightName())){
					it.remove();
					continue;
				}
				if(item.getSubMenuNodeList().size()>0){
					menuNodeFilter(item.getSubMenuNodeList());
				}
			}
			return items;
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuNodeFilter:"+e);
		}
		return null;
	}
}
