package cn.yw.video.recordalarm.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.video.recordalarm.service.YwrecordcurrentstateService;

@SuppressWarnings({"all"})
@Component("ywrecordcurrentstateAction")
public class YwrecordcurrentstateAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwrecordcurrentstateAction.class);
	
	@Autowired
	private YwrecordcurrentstateService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwrecordcurrentstateByPage")
	public void listYwrecordcurrentstateByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			// ȡûϢ
			PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			Integer sfgly = ptyh.getSfgly();
			if (sfgly != 1) {
				map.put("bmbh", ptyh.getBmbh()); // ȡű
			}

			//ת
			if (null != map.get("xzbh")) {
				String xzbh = map.get("xzbh").toString();
				map.put("xzbh", xzbh.split(","));
			}

			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwrecordcurrentstateByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateAction-listYwrecordcurrentstateByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ʷ¼
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwrecordhistorystateByPage")
	public void listYwrecordhistorystateByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			// ȡûϢ
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			Integer sfgly = ptyh.getSfgly();
			if(sfgly != 1) {
				map.put("bmbh", ptyh.getBmbh()); // ȡű
			}
			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwrecordhistorystateByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateAction-listYwrecordcurrentstateByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywrecordcurrentstate")
	public void count_Ywrecordcurrentstate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywrecordcurrentstate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateAction-count_Ywrecordcurrentstate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywrecordcurrentstate
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywrecordcurrentstate")
	public void query_Ywrecordcurrentstate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywrecordcurrentstate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateAction-query_Ywrecordcurrentstate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwrecordcurrentstate
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywrecordcurrentstate")
	public void get_Ywrecordcurrentstate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywrecordcurrentstate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateActionquery_Ywrecordcurrentstate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	// ѯʷ¼
	@OperateType(value = LogConstants.LOG_GET ,info ="getYwrecordHisState")
	public void getYwrecordHisState(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String rq = (String) map.get("rq");
			if("0".equals(rq)) {
				map.put("recordstate", 1);		//쳣
			}
			map.put("start",0 );
			map.put("limit",10 );
			Struts2Utils.renderJson(this.service.getYwrecordHisState(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrecordcurrentstateActionquery_getYwrecordHisState-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
