package cn.yw.operationcount.alarmcount.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.util.DateUtil;
import cn.yw.operationcount.alarmcount.dao.YworderinfocountDao;

@Service("yworderinfocountService")
public class YworderinfocountService {
	private static Log log = LogFactory.getLog(YworderinfocountService.class);
	
	@Autowired
	private YworderinfocountDao yworderinfocountDao;
	
	
	/**
	 * 豸澯ͳ
	 */	
	public List query_Yworderinfocount(Map map) throws SQLException{
		
		List<Map> list = yworderinfocountDao.query_Yworderinfocount(map);
		List<Map> jswcList = yworderinfocountDao.query_jswcgdOrders(map);
		if(list!=null && list.size()>0) {
			for(Map res: list) {
				int num=0;
				String xzbh = (String) res.get("xzbh");
				if(jswcList!=null&&jswcList.size()>0) {
					for(Map m : jswcList) {
						String xzml = (String) m.get("xzbh");
						if(xzbh.equals(xzml)) {
							String endTime = (String) m.get("endtime");
							String startTime = (String) m.get("starttime");
							int day = DateUtil.subtractDay(endTime,startTime);
							if(day <= 1) {
								num++;
							}
						}
					}
				} 
				res.put("jswcgd", String.valueOf(num));
			}
		}
				
		return list;
	}
	public Integer count_Yworderinfocount(Map map) throws SQLException{
		return yworderinfocountDao.count_Yworderinfocount(map);
	}
	
	/**
	 * Чͳ
	 */	
	public List query_orderefficient(Map map) throws SQLException{
		
		List<Map> list = yworderinfocountDao.query_orderefficient(map);
		List<Map> jswcList = yworderinfocountDao.query_effList(map);
		if(list!=null && list.size()>0) {
			for(Map res: list) {
				int ytyn=0;
				int ytys=0;
				int stys=0;
				String xzbh = (String) res.get("xzbh");
				if(jswcList!=null&&jswcList.size()>0) {
					for(Map m : jswcList) {
						String xzml = (String) m.get("xzbh");
						if(xzbh.equals(xzml)) {
							String endTime = (String) m.get("endtime");
							String startTime = (String) m.get("starttime");
							int day = DateUtil.subtractDay(endTime,startTime);
							if(day <= 1) {
								ytyn++;
							}else if(day <= 3) {
								ytys++;
							}else {
								stys++;
							}
						}
					}
				} 
				res.put("ytyn", String.valueOf(ytyn));
				res.put("ytys", String.valueOf(ytys));
				res.put("stys", String.valueOf(stys));
			}
		}
				
		return list;

	}
	public Integer count_orderefficient(Map map) throws SQLException{
		return yworderinfocountDao.count_orderefficient(map);
	}
	
	public List query_YworderinfocountList(Map map) throws SQLException{
		List<Map> list = yworderinfocountDao.query_YworderinfocountList(map);
		List<Map> jswcList = yworderinfocountDao.query_jswcgdOrders(map);
		if(list!=null && list.size()>0) {
			for(Map res: list) {
				int num=0;
				String xzbh = (String) res.get("xzbh");
				if(jswcList!=null&&jswcList.size()>0) {
					for(Map m : jswcList) {
						String xzml = (String) m.get("xzbh");
						if(xzbh.equals(xzml)) {
							String endTime = (String) m.get("endtime");
							String startTime = (String) m.get("starttime");
							int day = DateUtil.subtractDay(endTime,startTime);
							if(day <= 1) {
								num++;
							}
						}
					}
				} 
				res.put("jswcgd", String.valueOf(num));
			}
		}
				
		return list;
	}
	public List query_orderefficientList(Map map) throws SQLException{
		List<Map> list = yworderinfocountDao.query_orderefficientList(map);
		List<Map> jswcList = yworderinfocountDao.query_effList(map);
		if(list!=null && list.size()>0) {
			for(Map res: list) {
				int ytyn=0;
				int ytys=0;
				int stys=0;
				String xzbh = (String) res.get("xzbh");
				if(jswcList!=null&&jswcList.size()>0) {
					for(Map m : jswcList) {
						String xzml = (String) m.get("xzbh");
						if(xzbh.equals(xzml)) {
							String endTime = (String) m.get("endtime");
							String startTime = (String) m.get("starttime");
							int day = DateUtil.subtractDay(endTime,startTime);
							if(day <= 1) {
								ytyn++;
							}else if(day <= 3) {
								ytys++;
							}else {
								stys++;
							}
						}
					}
				} 
				res.put("ytyn", String.valueOf(ytyn));
				res.put("ytys", String.valueOf(ytys));
				res.put("stys", String.valueOf(stys));
			}
		}
				
		return list;
	}
	
	
}
