package cn.yw.machinemanage.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.machinemanage.service.YwmachineharddiskService;

@SuppressWarnings({"all"})
@Component("ywmachineharddiskAction")
public class YwmachineharddiskAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwmachineharddiskAction.class);
	
	@Autowired
	private YwmachineharddiskService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwmachineharddiskByPage")
	public void listYwmachineharddiskByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwmachineharddiskByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-listYwmachineharddiskByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywmachineharddisk")
	public void count_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywmachineharddisk(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-count_Ywmachineharddisk-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywmachineharddisk
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywmachineharddisk")
	public void query_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywmachineharddisk(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-query_Ywmachineharddisk-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwmachineharddisk
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywmachineharddisk")
	public void get_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywmachineharddisk(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskActionquery_Ywmachineharddisk-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwmachineharddisk")
	public void delete_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywmachineharddisk(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-delete_Ywmachineharddisk-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywmachineharddisk")
	public void insert_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(StringUtil.checkEmpty(map.get("harddiskid"))){
				map.put("harddiskid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywmachineharddisk(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywmachineharddisk(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywmachineharddisk(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-insert_Ywmachineharddisk()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywmachineharddisk")
	public void update_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywmachineharddisk(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywmachineharddisk(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywmachineharddisk(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-update_Ywmachineharddisk-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywmachineharddisk")
	public void batch_delete_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keywords = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keywords)) {
				String[] ids = keywords.split(",");
				map.clear();
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywmachineharddisk(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-batch_delete_Ywmachineharddisk-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_Ywmachineharddisk")
	public void edit_Ywmachineharddisk(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			String ids = (String) map.get("ids");
			if(RHUtil.isNotEmpty(ids)) {
				String[] keys = ids.split(",");
				map.put("keys", keys);
			}				
			int result = service.edit_Ywmachineharddisk(map);
			Struts2Utils.renderJson(Constants.SUCCESS);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-edit_Ywmachinecpu-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
		
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywmachineharddisk")
	public void exp_Ywmachineharddisk(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywmachineharddisk(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άӲϢ-"+dateTime);
			params.put("sheetName", "άӲϢ");
			params.put("header", "άӲϢ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineharddiskAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywmachineharddisk")
	public String imp_Ywmachineharddisk(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwmachineharddiskAction-imp_Ywmachineharddisk-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
