function CheTravelLayer(seq ,config ){
	LayerBase.call(this,seq,config);
}

CheTravelLayer.prototype = Object.create(LayerBase.prototype);

CheTravelLayer.prototype.getMark = function(result, withTitle){
	if(!result) return ;
	var pIcon = this.getIcon(MapConst.MARKER_ICON_CHETRAVEL, MapConst.LAYER_ICON_WIDTH ,MapConst.LAYER_ICON_HEIGHT);
	var point=new Point(result.longitude,result.latitude);	
	var resultMsg = PopUpBase.createCheTravelPopUp(result);
	var title = new Title(result.plateNo || '', 12, 7, '', null, null, "", "");
	result.id = result.vdId + '-' +  result.channelId;
	var markerObj = [ this.seq , result.id , result.longitude,result.latitude ];
	
	var marker = new Marker(point,pIcon) ;
	marker.addListener("click", function () {
		MapMain.setCurrPupUpObject(markerObj);
		marker.openInfoWindowHtml(resultMsg);
	});	
	marker.setZIndex(MapConst.MARKER_ZINDEX_CAR);
	return marker;
}

CheTravelLayer.prototype.OnMapChange = function(){
	
}

CheTravelLayer.prototype.createPopUp = function(data){
	return PopUpBase.createCheTravelPopUp(data);
}