package cn.yw.operationcount.videoappraisecount.action;


import java.io.File;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.cxf.common.util.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.excel.ExportExcel;
import cn.base.pdf.ExportPDF;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.operationcount.videoappraisecount.service.YwcountvideoappraiseService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywcountvideoappraiseAction")
public class YwcountvideoappraiseAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwcountvideoappraiseAction.class);
	static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Autowired
	private YwcountvideoappraiseService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwcountvideoappraiseByPage")
	public void listYwcountvideoappraiseByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			map.put("bmbh",bmbh);
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}
			Struts2Utils.renderJson(this.service.listYwcountvideoappraiseByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-listYwcountvideoappraiseByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * άͳ
	 */
	public void regionAssessmentCountList(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				map.put("bmbh",bmbh);
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}
			Struts2Utils.renderJson(this.service.regionAssessmentCountList(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-regionAssessmentCountList-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ҳ    άͳ 
	public void count_HomepateAreaExam(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			String nowTime = DateUtil.getDateTimeStr(new Date());
//			String zStartTime = sdf.format(DateUtil.day(new Date(),-7));    // һ
//			String yStartTime = sdf.format(DateUtil.month(-1));			 	// һ
//			String nStartTime = sdf.format(DateUtil.year(-1));				// һ
			
			String type = map.get("type")+"";
			String startTime = sdf.format(DateUtil.day(new Date(),-7));
			if("1".equals(type)){// һ
				startTime = sdf.format(DateUtil.month(-1));		
			}else if("2".equals(type)){// һ
				startTime = sdf.format(DateUtil.year(-1));
			}
			
			String tableParam=null;
			String jobtableparam = null;
			
			tableParam = " and countDate >= " + "\'" +startTime+ "\'" +" and countDate <= " + "\'" +nowTime+ "\'";
			jobtableparam = " and jobreporttime >= " + "\'" +startTime+ "\'" +" and jobreporttime <= " + "\'" +nowTime+ "\'";
			map.put("tableparam", tableParam);
			map.put("jobtableparam", jobtableparam);
			Map zMap = service.regionAssessmentCountList(map);
			
			/*tableParam = " and countDate >= " + "\'" +yStartTime+ "\'" +" and countDate <= " + "\'" +nowTime+ "\'";
			jobtableparam = " and jobreporttime >= " + "\'" +yStartTime+ "\'" +" and jobreporttime <= " + "\'" +nowTime+ "\'";
			map.put("tableparam", tableParam);
			map.put("jobtableparam", jobtableparam);
			Map yMap = service.regionAssessmentCountList(map);
			
			tableParam = " and countDate >= " + "\'" +nStartTime+ "\'" +" and countDate <= " + "\'" +nowTime+ "\'";
			jobtableparam = " and jobreporttime >= " + "\'" +nStartTime+ "\'" +" and jobreporttime <= " + "\'" +nowTime+ "\'";
			map.put("tableparam", tableParam);
			map.put("jobtableparam", jobtableparam);
			Map nMap = service.regionAssessmentCountList(map);
						
			Object[] zList = (Object[]) zMap.get("rows");
			Object[] yList = (Object[]) yMap.get("rows");
			Object[] nList = (Object[]) nMap.get("rows");*/
			
//			map.clear();
//			Object[] zList = (Object[]) zMap.get("rows");
//			map.put("zList", zMap.get("rows"));
//			map.put("yList", yList);
//			map.put("nList", nList);
			
			Struts2Utils.renderJson(zMap.get("rows"));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-count_HomepateAreaExam-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * άͳ-ȡĳ
	 */
	public void regionAssessmentCountListByRegion(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				map.put("bmbh",bmbh);
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.regionAssessmentCountListByRegion(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-regionAssessmentCountList-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywcountvideoappraise")
	public void count_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			map.put("bmbh",bmbh);
			Struts2Utils.renderJson(this.service.count_Ywcountvideoappraise(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-count_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywcountvideoappraise
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywcountvideoappraise")
	public void query_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}
			Struts2Utils.renderJson(this.service.query_Ywcountvideoappraise(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-query_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwcountvideoappraise
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywcountvideoappraise")
	public void get_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywcountvideoappraise(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction query_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ȡȨ
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getWeight")
	public void getWeight(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.getWeight(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getWeight-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * Ȩ
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="setWeight")
	public void setWeight(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			Map m = service.getWeight(map);
			if(m!=null && m.size()>0){
				map.put("modifyaccount", ptyh.getYhzh());
				map.put("modifytime", DateUtil.currentDateTime());
				Struts2Utils.renderJson(this.service.updateWeight(map));
			}else{
				map.put("weightId", StringUtil.getUUID());
				map.put("createaccount", ptyh.getYhzh());
				map.put("createtime", DateUtil.currentDateTime());
				map.put("modifyaccount", ptyh.getYhzh());
				map.put("modifytime", DateUtil.currentDateTime());
				this.service.insertWeight(map);
				Struts2Utils.renderJson("success");
				
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("setWeight-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwcountvideoappraise")
	public void delete_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywcountvideoappraise(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-delete_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywcountvideoappraise")
	public void insert_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("countId"))){
				map.put("countId",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountvideoappraise(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywcountvideoappraise(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywcountvideoappraise(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-insert_Ywcountvideoappraise()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywcountvideoappraise")
	public void update_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountvideoappraise(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywcountvideoappraise(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywcountvideoappraise(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-update_Ywcountvideoappraise-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywcountvideoappraise")
	public void batch_delete_Ywcountvideoappraise(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywcountvideoappraise(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-batch_delete_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel ά
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountvideoappraise")
	public void exp_Ywcountvideoappraise(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				queryMap.put("bmbh",bmbh);
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			JSONArray jsonArr = JSONArray.fromObject( service.regionAssessmentCountList(queryMap).get("rows"));	
//			List<Object> sList = Arrays.asList(objs);
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			Map weightMap = service.getWeight(new HashMap());
			if(weightMap!=null){
				headerList.add("");
				headerList.add("");
				headerList.add("ص");
				headerList.add("ʱ䣨Сʱ");
				headerList.add("ʣ"+weightMap.get("onlineweight")+"");
				headerList.add("Ƶʣ"+weightMap.get("videoweight")+"");
				headerList.add("¼ʣ"+weightMap.get("recordweight")+"");
				headerList.add("γȲɼʣ"+weightMap.get("lalweight")+"");
				headerList.add("޸ʣ"+weightMap.get("repairweight")+"");
				headerList.add("ܷ");
				headerList.add("");
			}else{
				
				headerList.add("");
				headerList.add("");
				headerList.add("ص");
				headerList.add("ʱ䣨Сʱ");
				headerList.add("ʣ");
				headerList.add("Ƶʣ");
				headerList.add("¼ʣ");
				headerList.add("γȲɼʣ");
				headerList.add("޸ʣ");
				headerList.add("ܷ");
				headerList.add("");
			}
			
			for(int i  =0;i<jsonArr.size()-1;i++ ){
				JSONObject json = JSONObject.fromObject(jsonArr.get(i));
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", json.get("areaname")==null?"":json.get("areaname"));
				exportMap.put("ص", json.get("jksum"));
				exportMap.put("ʱ䣨Сʱ", json.get("zxsc"));
				exportMap.put("ʣ"+weightMap.get("onlineweight")+"", json.get("zxRate"));
				exportMap.put("Ƶʣ"+weightMap.get("videoweight")+"", json.get("videoIntactRate"));
				exportMap.put("¼ʣ"+weightMap.get("recordweight")+"", json.get("recordIntactRate"));
				exportMap.put("γȲɼʣ"+weightMap.get("lalweight")+"", json.get("lalIntactRate"));
				exportMap.put("޸ʣ"+weightMap.get("repairweight")+"", json.get("jobIntactRate"));
				
				exportMap.put("ܷ", json.get("score"));
				exportMap.put("", i+1);
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			if(jsonArr.size()>0){
				
				JSONObject json = JSONObject.fromObject(jsonArr.get(jsonArr.size()-1));
				footerList.add( "ܼ");
				footerList.add("ܼ");
				footerList.add( json.get("jksum"));
				footerList.add( json.get("zxscSum"));
				footerList.add( json.get("zxscRate"));
				footerList.add( json.get("videoRate"));
				footerList.add( json.get("recordRate"));
				footerList.add( json.get("lalRate"));
				footerList.add( json.get("jobRate"));
				footerList.add( json.get("scoreSum"));
				footerList.add("");
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άͳ-"+dateTime);
			params.put("sheetName", "άͳ");
			params.put("header", "άͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");
			new ExportExcel().exportCommExcel(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-exoprtExcel-error:" +e);
			
		}
	}
	/**
	 * pdf ά
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Ywcountvideoappraise")
	public void expPDF_Ywcountvideoappraise(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				queryMap.put("bmbh",bmbh);
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			JSONArray jsonArr = JSONArray.fromObject( service.regionAssessmentCountList(queryMap).get("rows"));	
//			List<Object> sList = Arrays.asList(objs);
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			Map weightMap = service.getWeight(new HashMap());
			if(weightMap!=null){
				headerList.add("");
				headerList.add("");
				headerList.add("ص");
				headerList.add("ʱ䣨Сʱ");
				headerList.add("ʣ"+weightMap.get("onlineweight")+"");
				headerList.add("Ƶʣ"+weightMap.get("videoweight")+"");
				headerList.add("¼ʣ"+weightMap.get("recordweight")+"");
				headerList.add("γȲɼʣ"+weightMap.get("lalweight")+"");
				headerList.add("޸ʣ"+weightMap.get("repairweight")+"");
				headerList.add("ܷ");
				headerList.add("");
			}else{
				
				headerList.add("");
				headerList.add("");
				headerList.add("ص");
				headerList.add("ʱ䣨Сʱ");
				headerList.add("ʣ");
				headerList.add("Ƶʣ");
				headerList.add("¼ʣ");
				headerList.add("γȲɼʣ");
				headerList.add("޸ʣ");
				headerList.add("ܷ");
				headerList.add("");
			}
			
			for(int i  =0;i<jsonArr.size()-1;i++ ){
				JSONObject json = JSONObject.fromObject(jsonArr.get(i));
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", json.get("areaname")==null?"":json.get("areaname"));
				exportMap.put("ص", json.get("jksum"));
				exportMap.put("ʱ䣨Сʱ", json.get("zxsc"));
				exportMap.put("ʣ"+weightMap.get("onlineweight")+"", json.get("zxRate"));
				exportMap.put("Ƶʣ"+weightMap.get("videoweight")+"", json.get("videoIntactRate"));
				exportMap.put("¼ʣ"+weightMap.get("recordweight")+"", json.get("recordIntactRate"));
				exportMap.put("γȲɼʣ"+weightMap.get("lalweight")+"", json.get("lalIntactRate"));
				exportMap.put("޸ʣ"+weightMap.get("repairweight")+"", json.get("jobIntactRate"));
				
				exportMap.put("ܷ", json.get("score"));
				exportMap.put("", i+1);
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			if(jsonArr.size()>0){
				
				JSONObject json = JSONObject.fromObject(jsonArr.get(jsonArr.size()-1));
				footerList.add( "ܼ");
				footerList.add("ܼ");
				footerList.add( json.get("jksum"));
				footerList.add( json.get("zxscSum"));
				footerList.add( json.get("zxscRate"));
				footerList.add( json.get("videoRate"));
				footerList.add( json.get("recordRate"));
				footerList.add( json.get("lalRate"));
				footerList.add( json.get("jobRate"));
				footerList.add( json.get("scoreSum"));
				footerList.add("");
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άͳ-"+dateTime);
			params.put("sheetName", "άͳ");
			params.put("header", "άͳ");	
			new ExportPDF().exportCommPDF(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-expPDF_Ywcountvideoappraise-error:" +e);
			
		}
	}
	/**
	 * Excel ʱ
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountvideoappraise_online")
	public void exp_Ywcountvideoappraise_online(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				queryMap.put("bmbh",bmbh);
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			List<Map> jsonArr =  service.query_Ywcountvideoappraise(queryMap);	
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			headerList.add("");
			headerList.add("ص");
			headerList.add("");
			headerList.add("IPַ");
			headerList.add("ʱСʱ");
			headerList.add("߿ʼʱ");
			
			for(int i  =0;i<jsonArr.size();i++ ){
				Map json = jsonArr.get(i);
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("ص", json.get("videoname"));
				exportMap.put("", json.get("areaname")==null?"-":json.get("areaname"));
				exportMap.put("IPַ", json.get("ipaddress"));
				exportMap.put("ʱ䣨Сʱ", json.get("lxsc"));
				exportMap.put("߿ʼʱ", json.get("lxstarttime"));
				
				expList.add(exportMap);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ʱͳ-"+dateTime);
			params.put("sheetName", "ʱͳ");
			params.put("header", "ʱͳ");	
			new ExportExcel().exportCommExcel(params,headerList,new ArrayList(), expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-exp_Ywcountvideoappraise_online-error:" +e);
			
		}
	}
	/**
	 * pdf ʱ
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Ywcountvideoappraise_online")
	public void expPDF_Ywcountvideoappraise_online(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				queryMap.put("bmbh",bmbh);
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			List<Map> jsonArr =  service.query_Ywcountvideoappraise(queryMap);	
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			headerList.add("");
			headerList.add("ص");
			headerList.add("");
			headerList.add("IPַ");
			headerList.add("ʱСʱ");
			headerList.add("߿ʼʱ");
			
			for(int i  =0;i<jsonArr.size();i++ ){
				Map json = jsonArr.get(i);
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("ص", json.get("videoname"));
				exportMap.put("", json.get("areaname")==null?"-":json.get("areaname"));
				exportMap.put("IPַ", json.get("ipaddress"));
				exportMap.put("ʱ䣨Сʱ", json.get("lxsc"));
				exportMap.put("߿ʼʱ", json.get("lxstarttime"));
				
				expList.add(exportMap);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ʱͳ-"+dateTime);
			params.put("sheetName", "ʱͳ");
			params.put("header", "ʱͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
			new ExportPDF().exportCommPDF(params,headerList,new ArrayList(), expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-expPDF_Ywcountvideoappraise_online-error:" +e);
			
		}
	}
	
	// λ¼ͳ                           /start 
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywcountvideoappraise")
	public void query_dwlxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );

			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}

			List list = service.query_dwlx(map);
			int totalCount = service.count_dwlx(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-batch_delete_Ywcountvideoappraise-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	@OperateType(value = LogConstants.LOG_DELETE ,info ="count_dwlx")
	public void count_dwlx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			Struts2Utils.renderJson(service.count_dwlx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-count_dwlx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ͳ  ״ͼ
	@OperateType(value = LogConstants.LOG_DELETE ,info ="show_bar")
	public void show_bar(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			Struts2Utils.renderJson(service.show_bar(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountvideoappraiseAction-show_bar-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	// pdf λ¼
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_AreaOnline")
	public void expPDF_AreaOnline(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_dwlx(map);
			//ͷ
			String[] header = {"", "ص", "豸IP","¼","¼쳣","¼"};
			//
			String[][] expArr = null;
			List<String> footerList = null;
			if(RHUtil.isNotEmpty(sList)) {
				Integer zs = 0,zzcs = 0,zycs = 0;
				String  zwhl = "0";
				expArr = new String[sList.size()][header.length];
				int index = 0;
				for(Map smap : sList) {
					String zcs = (String) smap.get("recordduration");
					String ycs = (String) smap.get("norecordduration");
					String whl = "0";
					if (StringUtils.isEmpty(zcs)) {
						zcs = "0";
					}
					if (StringUtils.isEmpty(ycs)) {
						ycs = "0";
					}
					Integer mcount = Integer.parseInt(zcs) + Integer.parseInt(ycs);
					if(mcount != 0) {
						whl = division(Integer.parseInt(zcs), mcount);
					}
					smap.put("whl", whl);
					String[] zdbm = {"areaname", "videoname","ipaddress","recordduration","norecordduration","whl"};

					expArr[index][0] = StringUtil.transEmpty(smap.get("areaname")+"");
					expArr[index][1] = StringUtil.transEmpty(smap.get("videoname")+"");
					expArr[index][2] = StringUtil.transEmpty(smap.get("ipaddress")+"");
					expArr[index][3] = zcs;
					expArr[index][4] = ycs;
					expArr[index][5] = whl;
					index++;
					zs = zs + mcount;
					zzcs = zzcs + Integer.parseInt(zcs);
					zycs = zycs + Integer.parseInt(ycs);				
				}	
				// ܼ
				if(zs != 0) {
					zwhl = division(zzcs, zs);
				}
				footerList = new ArrayList<String>();
				footerList.add("ܼ");
				footerList.add("ܼ");
				footerList.add("ܼ");
				footerList.add(String.valueOf(zzcs));
				footerList.add(String.valueOf(zycs));
				footerList.add(String.valueOf(zwhl));
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "λ¼ͳ-"+dateTime);
			params.put("sheetName", "λ¼ͳ");
			params.put("header", "λ¼ͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
			new ExportPDF().exportCommPDF(params,header,footerList,3, expArr, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-expPDF_AreaOnline-error:" +e);
			
		}
	}
	// excel λ¼
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_AreaOnline")
	public void exp_AreaOnline(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_dwlx(map);
			Map footMap = new HashMap();
			if(RHUtil.isNotEmpty(sList)) {
				Integer zs = 0;
				Integer zzcs = 0;
				Integer zycs = 0;
				String  zwhl = "0";
				for(Map smap : sList) {
					String zcs = (String) smap.get("recordduration");
					String ycs = (String) smap.get("norecordduration");
					String whl = "0";
					if (StringUtils.isEmpty(zcs)) {
						zcs = "0";
					}
					if (StringUtils.isEmpty(ycs)) {
						ycs = "0";
					}
					Integer mcount = Integer.parseInt(zcs) + Integer.parseInt(ycs);
					if(mcount != 0) {
						whl = division(Integer.parseInt(zcs), mcount);
					}
					smap.put("whl", whl);
					
					zs = zs + mcount;
					zzcs = zzcs + Integer.parseInt(zcs);
					zycs = zycs + Integer.parseInt(ycs);				
				}	
				// ܼ
				if(zs != 0) {
					zwhl = division(zzcs, zs);
				}
				
				footMap.put("0", "ܼ");
				footMap.put("1", "ܼ");
				footMap.put("2", "ܼ");
				footMap.put("3", String.valueOf(zzcs));
				footMap.put("4", String.valueOf(zycs));
				footMap.put("5", String.valueOf(zwhl));
			}
			
			
			String[] zdbm = {"areaname", "videoname","ipaddress","recordduration","norecordduration","whl"};
			String[] zdmc = {"", "ص", "豸IP","¼","¼쳣","¼"};
			int excelNum = zdmc.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "λ¼ͳ-"+dateTime);
			params.put("sheetName", "λ¼ͳ");
			params.put("header", "λ¼ͳ");	
			//	new ExportEngine().exportCommData(params, cells, (ArrayList)sList, Struts2Utils.getResponse());
			exportCommData(params, cells, (ArrayList)sList, footMap, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-exp_AreaOnline-error:" +e);
			
		}
	}
	
	public void exportCommData(Map map, ExcelCol[] headertxt, List<HashMap> list,Map footMap, HttpServletResponse responses) {
		OutputStream os = null;
		try {
			ExportEngine exportEngine = new ExportEngine();
			os = responses.getOutputStream();
			responses.reset();// 
			String fileName = map.get("fileName").toString();
			fileName = ExportEngine.toUtf8String(fileName);
			responses.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");// 趨ļͷ
			responses.setContentType("application/msexcel");// 
			HSSFWorkbook workbook = new HSSFWorkbook();
			HSSFFont font = workbook.createFont();// 
			font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// Ӵ
			font.setFontName(" ");// 
			// Sheet
			HSSFSheet sheet = workbook.createSheet(map.get("sheetName").toString());
			sheet.setDefaultColumnWidth((short) 14);// Ĭп
			// ϲԪ,ͷ˵Ϣ
			sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headertxt.length - 1));
			HSSFCellStyle cellStyle2 = exportEngine.setHeadRegionStyle(workbook);// úϲͷԪʽ
			// һ
			HSSFRow row2 = sheet.createRow(0);
			row2.setHeight((short) 400);
			HSSFCell cell2 = row2.createCell(0);
			cell2.setCellValue(map.get("header").toString());
			cell2.setCellStyle(cellStyle2);
			for (int k = 1; k < headertxt.length; k++) {
				row2.createCell(k).setCellStyle(cellStyle2);
			}
			HSSFCellStyle cellStyle = exportEngine.setRowsRegionStyle(workbook);// úϲеԪʽ
			// ڶУɱͷ
			HSSFRow row = sheet.createRow(1);
			if (headertxt != null && headertxt.length > 0) {
				short j = 0;
				for (ExcelCol s : headertxt) {
					HSSFCell cell1 = row.createCell(j);
					cell1.setCellValue(headertxt[j].getColName());
					cell1.setCellStyle(cellStyle);
					j = (short) (j + 1);
				}
			}
			HSSFCellStyle cs = exportEngine.setCommonStyle(workbook);// ͨԪʽ
			// 
			for (int i = 0; i < list.size(); i++) {
				HSSFRow datarow = sheet.createRow((short) i + 2);
				Map mp = list.get(i);
				for (short k = 0; k < headertxt.length; k++) {
					HSSFCell datacell = datarow.createCell(k);
					datacell.setCellStyle(cs);
					datacell.setCellValue(mp.get(headertxt[k].getColKey()) == null ? "" : mp.get(headertxt[k].getColKey()) + "");
				}
			}
			int lastrowNum = list.size() + 2;
			if(RHUtil.isNotEmpty(footMap)) {
				sheet.addMergedRegion(new CellRangeAddress(lastrowNum, lastrowNum, 0, 2));
				HSSFRow datarow = sheet.createRow(lastrowNum);
				/*HSSFCell lastcell = datarow.createCell(0);
				lastcell.setCellValue("ܼ");
				lastcell.setCellStyle(cs);*/
				for(int m=0; m<footMap.size(); m++) {
					HSSFCell datacell = datarow.createCell(m);
					datacell.setCellStyle(cs);
					datacell.setCellValue((String)footMap.get(String.valueOf(m)));
				}
			}
			workbook.write(os);
			os.flush();    
			iLog.info("ɹExcel!");
			// дļ
		} catch (Exception ex) {
			iLog.error("Excel", ex);
		} finally {
			try {
				os.close();
			} catch (Exception ex) {
				iLog.error("رosʧ", ex);
			}
		}
	}

	
	// λ¼ͳ                           /end 
	/**
     * תɰٷ
     * ǰ
     * @param  num1 ,num2  num1/num2
     * @return  rate  2λС
     */
    public static String  division(int num1,int num2){
        String rate="0.00%";
        //ʽʼλ
        String format="0.00";
        if(num2 != 0 && num1 != 0){
            DecimalFormat dec = new DecimalFormat(format);
            rate =  dec.format((double) num1 / num2*100)+"%";
            while(true){
                if(rate.equals(format+"%")){
                    format=format+"0";
                    DecimalFormat dec1 = new DecimalFormat(format);
                    rate =  dec1.format((double) num1 / num2*100)+"%";
                }else {
                    break;
                }
            }
        }else if(num1 != 0 && num2 == 0){
            rate = "100%";
        }
        return rate;
    }
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywcountvideoappraise")
	public String imp_Ywcountvideoappraise(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwcountvideoappraiseAction-imp_Ywcountvideoappraise-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
