package cn.yw.alarmtaskmanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarmtaskmanage.service.YwalarmruleinfoService;

@SuppressWarnings({"all"})
@Component("ywalarmruleinfoAction")
public class YwalarmruleinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwalarmruleinfoAction.class);
	
	@Autowired
	private YwalarmruleinfoService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwalarmruleinfoByPage")
	public void listYwalarmruleinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwalarmruleinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-listYwalarmruleinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywalarmruleinfo")
	public void count_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywalarmruleinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-count_Ywalarmruleinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywalarmruleinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywalarmruleinfo")
	public void query_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywalarmruleinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-query_Ywalarmruleinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ѯ һYwalarmruleinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywalarmruleinfo")
	public void get_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywalarmruleinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoActionquery_Ywalarmruleinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwalarmruleinfo")
	public void delete_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywalarmruleinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-delete_Ywalarmruleinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywalarmruleinfo")
	public void insert_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(StringUtil.checkEmpty(map.get("alarmruleid"))){
				map.put("alarmruleid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmruleinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywalarmruleinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywalarmruleinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-insert_Ywalarmruleinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywalarmruleinfo")
	public void update_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmruleinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywalarmruleinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywalarmruleinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-update_Ywalarmruleinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywalarmruleinfo")
	public void batch_delete_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keywords = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keywords)) {
				String[] ids = keywords.split(",");
				map.clear();
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywalarmruleinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-batch_delete_Ywalarmruleinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ѯ 澯 Ƴ
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywalarmruleinfo")
	public void getAlarmTypeMc(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.getAlarmTypeMc(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-getAlarmTypeMc-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_Ywalarmruleinfo")
	public void edit_Ywalarmruleinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			String ids = (String) map.get("ids");
			if(RHUtil.isNotEmpty(ids)) {
				String[] keys = ids.split(",");
				map.put("keys", keys);
			}				
			int result = service.edit_Ywalarmruleinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinecpuAction-edit_Ywalarmruleinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywalarmruleinfo")
	public void exp_Ywalarmruleinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywalarmruleinfo(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά澯-"+dateTime);
			params.put("sheetName", "ά澯");
			params.put("header", "ά澯");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmruleinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywalarmruleinfo")
	public String imp_Ywalarmruleinfo(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwalarmruleinfoAction-imp_Ywalarmruleinfo-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
