package cn.map.szmap.schedule;

import java.util.Map;

import org.apache.log4j.Logger;

import cn.map.szmap.cache.CacheManager;
import cn.map.szmap.cache.ICache;

public class CacheRefreshPool {
	private static final Logger iLog = Logger.getLogger(CacheRefreshPool.class);
	private static CacheRefreshPool inst = new CacheRefreshPool();
	public static CacheRefreshPool getInstance() {
		return inst;
	}

	public void init() throws Exception {
		CacheManager.getIntance().init();
		Map<Long, ICache> layerMap = CacheManager.getIntance().getLayCache();
		if (layerMap != null && layerMap.size() > 0) {
			for (long key : layerMap.keySet()) {
				try {
					new Thread(new CacheRefreshThread(key,layerMap.get(key).toString())).start();
				} catch (Exception e) {
					iLog.error("CacheRefreshPool startˢʧܡtype=" + key, e);
				}
			}
		}
	}
	
}
