package cn.map.szmap.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.log4j.Logger;

public abstract class AbstractCache implements ICache {
	private static final Logger iLog = Logger.getLogger(AbstractCache.class);
	protected final Object lock = new Object();
	protected Map<String, Map> m_cache = new ConcurrentHashMap<String, Map>();
	protected AtomicLong refreshTime = new AtomicLong(-1);

	@Override
	public  List<Map> getAllData() throws Exception {
		List<Map> l_cache = new ArrayList<Map>();
		Iterator<?> iterator = m_cache.keySet().iterator();
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			l_cache.add(m_cache.get(key));
		}
		return l_cache;
	}

	public Map get(String key) throws Exception{
		return m_cache.get(key);
	}

	public long getRefreshTime(){
		return refreshTime.get();
	}

	public abstract void refreshAll(List<HashMap> list);
	public abstract List<Map> getData(Map condition);
}
