package cn.im.trafficplan.action;

 import cn.im.trafficplan.service.TrafficplanexecmodeService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("trafficplanexecmodeAction")
public class TrafficplanexecmodeAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficplanexecmodeAction.class);
	
	@Autowired
	private TrafficplanexecmodeService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficplanexecmodeByPage")
	public void listTrafficplanexecmodeByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficplanexecmodeByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-listTrafficplanexecmodeByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Trafficplanexecmode")
	public void delete_Trafficplanexecmode(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficplanexecmode(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-delete_Trafficplanexecmode-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficplanexecmode")
	public void insert_Trafficplanexecmode(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("execID"))){
				map.put("execID",StringUtil.getUUID());
			}
			service.insert_Trafficplanexecmode(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-listTrafficplanexecmodeByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficplanexecmode")
	public void update_Trafficplanexecmode(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Trafficplanexecmode(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-update_Trafficplanexecmode-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Trafficplanexecmode")
	public void query_Trafficplanexecmode(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.query_Trafficplanexecmode(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-query_Trafficplanexecmode-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ͨԤִзʽʼ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Trafficplanexecmode_Origin")
	public void query_Trafficplanexecmode_Origin(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("planID",Struts2Utils.getParameter("planID") );
			map.put("condition",Struts2Utils.getParameter("condition") );
			map.put("planType",Struts2Utils.getParameter("planType") );
			Struts2Utils.renderJson(this.service.query_Trafficplanexecmode_Origin(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-query_Trafficplanexecmode-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Trafficplanexecmode_plan")
	public void query_Trafficplanexecmode_plan(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.query_Trafficplanexecmode_plan(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexecmodeAction-query_Trafficplanexecmode_plan-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}

