package cn.im.trafficplan.action;

 import cn.im.trafficplan.service.TrafficplanexeclogService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;

@SuppressWarnings({"all"})
@Component("trafficplanexeclogAction")
public class TrafficplanexeclogAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficplanexeclogAction.class);
	
	@Autowired
	private TrafficplanexeclogService service;
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateExecLog")
	public void updateExecLog(){
		Map map = Struts2Utils.getRequestParameterMap();
		try{
			Struts2Utils.renderJson(this.service.updateExecLog(map));
		}catch(Exception e){
			e.printStackTrace();
			iLog.error("TrafficplanexeclogAction-updateExecLog-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 鿴Ԥ
	 * ͨaccidentIdplanIdѯִ־   
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficplanexeclogByAPID")
	public void listTrafficplanexeclogByAPID(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.listTrafficplanexeclogByAPID(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexeclogAction-listTrafficplanexeclogByAPID-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficplanexeclogByPage")
	public void listTrafficplanexeclogByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficplanexeclogByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexeclogAction-listTrafficplanexeclogByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficplanexeclog")
	public void insert_Trafficplanexeclog(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("logId"))){
				map.put("logId",StringUtil.getUUID());
			}
			String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			String now = DateUtil.currentDateTime();
			map.put("createAccount", userName);
			map.put("createTime", now);
			service.insert_Trafficplanexeclog(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexeclogAction-listTrafficplanexeclogByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	// ѯ¼¼
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptlyjlb")
	public void query_Ptlyjlb(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptlyjlb(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanexeclogAction-query_Ptlyjlb-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
