package cn.yw.nhyw.nhywsbipgl.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.*;
import cn.yw.nhyw.nhywsbipgl.service.NhywsbipglService;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;


@Component("nhywsbipglAction")
public class NhywsbipglAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger iLog = Logger.getLogger(NhywsbipglAction.class);

    @Autowired
    private NhywsbipglService service;

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listNhywsbipglByPage")
    public void listNhywsbipglByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listNhywsbipglByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-listNhywsbipglByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "count_Nhywsbipgl")
    public void count_Nhywsbipgl() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Nhywsbipgl(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-count_Nhywsbipgl-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_Nhywsbipgl")
    public void delete_Nhywsbipgl() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Nhywsbipgl(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-delete_Nhywsbipgl-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Nhywsbipgl")
    public void insert_Nhywsbipgl() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("id"))) {
                map.put("id", StringUtil.getUUID());
            }
            service.insert_Nhywsbipgl(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-insert_Nhywsbipgl()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Nhywsbipgl")
    public void update_Nhywsbipgl() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int result = service.update_Nhywsbipgl(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-update_Nhywsbipgl-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * Excel
     */

    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_Nhywsbipgl")
    public void exp_Nhywsbipgl() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            map.put("start", 0);
            map.put("limit", 5000);
            List<Map> sList = service.query_Nhywsbipgl(map);

            String[] zdbm = {"qs","zj","lhybh","jczhptbh","sjkkbh","zdkkbh","zpdybm","kkmc","zmptmc","sbh","fx","ip","ym","wg","vlan","lkdm","lddm","dlms","jd","wd","dlmc","fxlx","xzqh","ldlx","kkwzlx","kkyylx","jpljtj","zpfxlx","sfbjkk","ljdy","cdbh","dcxs","xcxs","zdxs","cdzs","cj","dkh","yhm","yhmm","sblx"};
            String[] zdmc = {"","","һ","ָƽ̨","ڱšо","ڱ_֧","ץĵԪ","","ƽ̨","豸","","IP","","","vlan","·ڴ","·δ","·","","γ","·","","","·","λ","Ӧ","߱","ץķ","Ƿ߽翨","ڽ","","","С","","","","˿ں","û","û","豸"};
            int excelNum = zdbm.length;
            ExcelCol[] cells = new ExcelCol[excelNum];
            for(int i=0;i<excelNum;i++){
                cells[i] = new ExcelCol();
                cells[i].setColKey(zdbm[i]);
                cells[i].setColName(zdmc[i]);
            }
            SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
            String dateTime = formart.format(new Date());
            Map params = new HashMap();
            params.put("fileName", "豸IP-" + dateTime);
            params.put("sheetName", "豸IP");
            params.put("header", "豸IP");
            new ExportEngine().exportCommData(params, cells, sList, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywsbipglAction-exp_Nhywsbipgl-error:" + e);

        }
    }

    /**
     * Excel
     */
    @OperateType(value = LogConstants.LOG_IMPORT, info = "imp_Nhywsbipgl")
    public void imp_Nhywsbipgl() {
        try {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
            String result = "0";
            List<Map> list = new ArrayList<>();
            List<List<Object>> listob = null;
            wrapper.getParameter("filename");
            File file = wrapper.getFiles("file")[0];
            if (null == file) {
                Struts2Utils.renderJson("ļ");
                iLog.error("NhywsbipglAction-imp_Nhywsbipgl-error:ļ");
            }
            String directory = "/upload";
            String targetDirectory = ServletActionContext.getServletContext().getRealPath(directory);
            //ϴļ
            File target = new File(targetDirectory, wrapper.getParameter("filename"));
            //ļѾڣɾԭļ
            if (target.exists()) {
                target.delete();
            }
            FileUtils.copyFile(file, target);           //fileʵϴ
            FileInputStream in = new FileInputStream(target);
            listob = new ImportExcelUtil().getBankListByExcel(in, target.getName());
            in.close();
            if (listob.size() > 0) {
                List<Object> columns = listob.get(0);
                if (columns.size() >= 13) { //жģǷȷ
                    for (int i = 0; i < listob.size(); i++) {
                        Map vo = new HashMap();
                        vo.put("id", StringUtil.getUUID());
                        vo.put("qs", String.valueOf(listob.get(i).get(0)));
                        vo.put("zj", String.valueOf(listob.get(i).get(1)));
                        vo.put("lhybh", String.valueOf(listob.get(i).get(2)));
                        vo.put("jczhptbh", String.valueOf(listob.get(i).get(3)));
                        vo.put("sjkkbh", String.valueOf(listob.get(i).get(4)));
                        vo.put("zdkkbh", String.valueOf(listob.get(i).get(5)));
                        vo.put("zpdybm", String.valueOf(listob.get(i).get(6)));
                        vo.put("kkmc", String.valueOf(listob.get(i).get(7)));
                        vo.put("zmptmc", String.valueOf(listob.get(i).get(8)));
                        vo.put("sbh", String.valueOf(listob.get(i).get(9)));
                        vo.put("fx", String.valueOf(listob.get(i).get(10)));
                        vo.put("ip", String.valueOf(listob.get(i).get(11)));
                        vo.put("ym", String.valueOf(listob.get(i).get(12)));
                        vo.put("wg", String.valueOf(listob.get(i).get(13)));
                        vo.put("vlan", String.valueOf(listob.get(i).get(14)));
                        vo.put("lkdm", String.valueOf(listob.get(i).get(15)));
                        vo.put("lddm", String.valueOf(listob.get(i).get(16)));
                        vo.put("dlms", String.valueOf(listob.get(i).get(17)));
                        vo.put("jd", String.valueOf(listob.get(i).get(18)));
                        vo.put("wd", String.valueOf(listob.get(i).get(19)));
                        vo.put("dlmc", String.valueOf(listob.get(i).get(20)));
                        vo.put("fxlx", String.valueOf(listob.get(i).get(21)));
                        vo.put("xzqh", String.valueOf(listob.get(i).get(22)));
                        vo.put("ldlx", String.valueOf(listob.get(i).get(23)));
                        vo.put("kkwzlx", String.valueOf(listob.get(i).get(24)));
                        vo.put("kkyylx", String.valueOf(listob.get(i).get(25)));
                        vo.put("jpljtj", String.valueOf(listob.get(i).get(26)));
                        vo.put("zpfxlx", String.valueOf(listob.get(i).get(27)));
                        vo.put("sfbjkk", String.valueOf(listob.get(i).get(28)));
                        vo.put("ljdy", String.valueOf(listob.get(i).get(29)));
                        vo.put("cdbh", String.valueOf(listob.get(i).get(30)));
                        vo.put("dcxs", String.valueOf(listob.get(i).get(31)));
                        vo.put("xcxs", String.valueOf(listob.get(i).get(32)));
                        vo.put("zdxs", String.valueOf(listob.get(i).get(33)));
                        vo.put("cdzs", String.valueOf(listob.get(i).get(34)));
                        vo.put("cj", String.valueOf(listob.get(i).get(35)));
                        vo.put("dkh", String.valueOf(listob.get(i).get(36)));
                        vo.put("yhm", String.valueOf(listob.get(i).get(37)));
                        vo.put("yhmm", String.valueOf(listob.get(i).get(38)));
                        vo.put("sblx", String.valueOf(listob.get(i).get(39)));
                        list.add(vo);
                    }
                    result = this.service.batch_insertNhywsbipglinfo(list);
                }
                if (result.equals("1")) {
                    Struts2Utils.renderJson("ɹ" + list.size() + "");
                } else {
                    Struts2Utils.renderJson("ʧ");
                }
            } else {
                Struts2Utils.renderJson("ģ");
            }
        } catch (Exception e) {
            iLog.error("NhywsbipglAction-imp_Nhywsbipgl-error:" + e);
            Struts2Utils.renderJson("ʧ");
        }

    }
}
