package cn.nhyw.khpj.action;


import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.*;
import cn.nhyw.khpj.service.MonthlyKPIService;
import cn.nhyw.khpj.service.YwglbmkhService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@SuppressWarnings({"all"})
@Component("monthlyKPIAction")
public class MonthlyKPIAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(MonthlyKPIAction.class);

    @Autowired
    private MonthlyKPIService service;

    /**
     * 查询所有
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listMonthlyKPI")
    public void listMonthlyKPI() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listMonthlyKPI(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-listMonthlyKPI-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * 修改
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "batchupdateMonthlyKPI")
    public void batchupdateMonthlyKPI() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (RHUtil.isNotEmpty(map.get("data"))) {
                Map queryMap = net.sf.json.JSONObject.fromObject(map.get("data"));
                //遍历前台参数key ,value  ,拆分成新的map  id:key  finalscore:value
                if (queryMap != null) {
                    List<Map> list = new ArrayList<>();
                    Set set = queryMap.entrySet();
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        Map valuemap = new HashMap();
                        Map.Entry<String, String> entry1 = (Map.Entry<String, String>) i.next();
                        valuemap.put("id", entry1.getKey());
                        valuemap.put("finalscore", entry1.getValue());
                        list.add(valuemap);
                    }
                    int result = service.batchupdateMonthlyKPI(list);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-batchupdateMonthlyKPI-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 查询所有
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "getMonthlyKPITotalScore")
    public void getMonthlyKPITotalScore() {
        try {
            Struts2Utils.renderJson(this.service.getMonthlyKPITotalScore());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-getMonthlyKPITotalScore-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 查询所有版本记录
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listMonthlyKPIByVer")
    public void listMonthlyKPIByVer() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listMonthlyKPIByVer(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-listMonthlyKPIByVer-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 查询最大版本及历史所有版本
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "maxMonthlyKPIByVer")
    public void maxMonthlyKPIByVer() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.maxMonthlyKPIByVer(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-maxMonthlyKPIByVer-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 新增考核项，分为新增版本和不新增版本
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_MonthlyKPIByVer")
    public void insert_MonthlyKPIByVer() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("id"))) {
                map.put("id", StringUtil.getUUID());
            }
            //判断是否生成新的版本
            if (RHUtil.isNotEmpty(map.get("isnewver")) ) {
                //获得当前最大版本，为空则赋值为1 ，当前版本号为1 ，历史版本号为1 ，
                if (RHUtil.isEmpty(map.get("maxver")) || map.get("maxver").equals("")) {
                    map.put("maxver", 1);
                    map.put("usingver", 1);
                    map.put("ver", ",1");
                } else if(map.get("isnewver").equals("1")) {
                    //最大版本加1 ，当前使用版本为最新生成的最大版本，历史版本号为当前使用 的版本号的所有考核项新增 最大版本号，
                    map.put("maxver", Integer.parseInt(map.get("maxver").toString()) + 1);
                    map.put("oldusingver", map.get("usingver").toString());
                    map.put("usingver", map.get("maxver").toString());
                    map.put("ver", "," + map.get("maxver"));//正在使用的为最大值
                }
                else{
                    map.put("ver",  "," +map.get("usingver"));
                }
            }else {
                map.put("XGTJid ", map.get("id"));
            }
            this.service.insert_MonthlyKPIByVer(map);
            //            //更新oldusingver 使用的版本更新当前使用版本及ver
            if(Integer.parseInt(map.get("maxver").toString())!=Integer.parseInt(map.get("usingver").toString())+1 )
            this.service.update_MonthlyKPIByUsingVer(map);
            //更新所有的usingver 及max
            this.service.update_Max_Usingver(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-insert_MonthlyKPIByVer-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }
    /**
     * 新增考核项，分为新增版本和不新增版本
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "update_MonthlyKPIByVer")
    public void update_MonthlyKPIByVer() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //判断是否生成新的版本
            if (RHUtil.isNotEmpty(map.get("isnewver")) && map.get("isnewver").equals("1")) {
                map.put("id", StringUtil.getUUID());
                //获得当前最大版本，将当前版本加1更新到所有包含当前版本的数据中
                //最大版本加1 ，当前使用版本号加1 ，历史版本号为最大加1 的值，
                map.put("maxver", Integer.parseInt(map.get("maxver").toString()) + 1);
                map.put("oldusingver", map.get("usingver"));
                map.put("usingver", map.get("maxver"));//最大版本号
                 map.put("ver", "," + map.get("maxver"));//历史使用版本号为最大版本号
                //将新数据插入到表中
                this.service.insert_MonthlyKPIByVer(map);
                //更新oldusingver 使用的版本更新当前使用版本及ver
                this.service.update_MonthlyKPIVerByUsingVer(map);
                //更新所有的usingver 及max
                this.service.update_Max_Usingver(map);

            }else if(RHUtil.isNotEmpty(map.get("isnewver")) && map.get("isnewver").equals("0")){
                //单纯的更新数据
                this.service.update_MonthlyKPIByXh(map);
            }else {
                //启用某版本
                map.put("XJTJusingver", map.get("usingver"));
                this.service.update_MonthlyKPIByXh(map);

            }
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-update_MonthlyKPIByVer-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 新增考核项，分为新增版本和不新增版本
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_MonthlyKPI")
    public void delete_MonthlyKPI() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //判断是否生成新的版本
            if (RHUtil.isNotEmpty(map.get("isnewver")) && map.get("isnewver").equals("1")) {
                //获得当前最大版本，将当前版本加1更新到所有包含当前版本的数据中
                //最大版本加1 ，当前使用版本号加1 ，历史版本号为最大加1 的值，
                map.put("maxver", Integer.parseInt(map.get("maxver").toString()) + 1);
                map.put("oldusingver", map.get("usingver"));
                map.put("usingver", map.get("maxver"));//最大版本号
                map.put("ver", "," + map.get("maxver"));//历史使用版本号为最大版本号
                //不删除的数据更新到新的版本，删除的数据不变
                this.service.update_MonthlyKPIByUsingVer(map);
                //更新所有的usingver 及max
                this.service.update_Max_Usingver(map);
            }else {
                //单纯的删除数据
                this.service.delete_MonthlyKPI(map);
            }
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("MonthlyKPIAction-delete_MonthlyKPI-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

}
