package cn.im.ptlxstore.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.im.ptlxstore.dao.PtlxccqDao;

@Service("ptlxccqService")
public class PtlxccqService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtlxccqService.class);
	
	@Autowired
	private PtlxccqDao ptlxccqDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptlxccq(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptlxccqDao.insert_Ptlxccq(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptlxccq(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptlxccqDao.update_Ptlxccq(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptlxccq(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptlxccqDao.delete_Ptlxccq(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptlxccq(Map map) throws SQLException{
		return ptlxccqDao.batch_delete_Ptlxccq(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptlxccq(Map map) throws SQLException{
		return ptlxccqDao.count_Ptlxccq(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptlxccq(Map map) throws SQLException{
		return ptlxccqDao.query_Ptlxccq(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptlxccq(Map map) throws SQLException{
		return ptlxccqDao.get_Ptlxccq(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtlxccq(Map map) throws SQLException{
		return this.listPtlxccqByPage(map);
	}
	
	/**
	 * Ptlxccq ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtlxccqByPage(Map map) throws SQLException {
		List<Map> list = ptlxccqDao.query_Ptlxccq(map);
		Integer totalCount = ptlxccqDao.count_Ptlxccq(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
