package cn.base.pdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import cn.base.util.StringUtil;


public class ExportPDF {

	private static final Logger logger = Logger.getLogger(ExportPDF.class);
	private static Font headfont;// С
	private static Font keyfont;// С
	private static Font textfont;// С
	private static int maxWidth; 
	static {
		// ĸʽ
		BaseFont bfChinese;
		try {
			// ʾ
			bfChinese = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
			headfont = new Font(bfChinese, 14, Font.BOLD);// С
			keyfont = new Font(bfChinese, 20, Font.BOLD);// С
			textfont = new Font(bfChinese, 12, Font.NORMAL);// С
			maxWidth = 520;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	Document document = new Document();
	public ExportPDF() {
		
	}
	/**
	* ļ
	* @param file ɵļ
	*/
    public ExportPDF(File file) {
        document.setPageSize(PageSize.A4);// ҳС
        try {
            PdfWriter.getInstance(document, new FileOutputStream(file));
            document.open();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * ļ
     * @param os
     */
    public ExportPDF(OutputStream os) {
    	document.setPageSize(PageSize.A4);// ҳС
    	try {
    		PdfWriter.getInstance(document, os);
    		document.open();
    	} catch (Exception e) {
    		e.printStackTrace();
    	}
    }

	
	/**
     * ʼļ
     * @param document
     * @param file
     */
	public void initFile(File file) {
		document.setPageSize(PageSize.A4);// ҳС
		try {
			PdfWriter.getInstance(document, new FileOutputStream(file));
			document.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * ʼļ
	 * @param os
	 */
	public void initFile(OutputStream os) {
		document.setPageSize(PageSize.A4);// ҳС
		try {
			PdfWriter.getInstance(document, os);
			document.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Ϊһ
	 * 
	 * @param value
	 *            ֵ
	 * @param font
	 *            
	 * @param align
	 *            뷽ʽ
	 * @return ӵı
	 */
	public PdfPCell createCell(String value, Font font, int align) {
		PdfPCell cell = new PdfPCell();
		cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(align);
		cell.setPhrase(new Phrase(value, font));
		return cell;
	}

	/**
	 * Ϊһ
	 * 
	 * @param value
	 *            ֵ
	 * @param font
	 *            
	 * @return ӵı
	 */
	public PdfPCell createCell(String value, Font font) {
		PdfPCell cell = new PdfPCell();
		cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Element.ALIGN_CENTER);
		cell.setPhrase(new Phrase(value, font));
		return cell;
	}

	/**
	 * Ϊһ
	 * 
	 * @param value
	 *            ֵ
	 * @param font
	 *            
	 * @param align
	 *            뷽ʽ
	 * @param colspan
	 *            ռ
	 * @return ӵı
	 */
	public PdfPCell createCell(String value, Font font, int align, int colspan) {
		PdfPCell cell = new PdfPCell();
		cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(align);
		cell.setColspan(colspan);
		cell.setPhrase(new Phrase(value, font));
		return cell;
	}

	/**
	 * Ϊһ
	 * 
	 * @param value
	 *            ֵ
	 * @param font
	 *            
	 * @param align
	 *            뷽ʽ
	 * @param colspan
	 *            ռ
	 * @param boderFlag
	 *            Ƿб߿
	 * @return ӵı
	 */
	public PdfPCell createCell(String value, Font font, int align, int colspan, boolean boderFlag) {
		PdfPCell cell = new PdfPCell();
		cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(align);
		cell.setColspan(colspan);
		cell.setPhrase(new Phrase(value, font));
		cell.setPadding(3.0f);
		if (!boderFlag) {
			cell.setBorder(0);
			cell.setPaddingTop(15.0f);
			cell.setPaddingBottom(8.0f);
		}
		return cell;
	}

	/**
	 * һ
	 * 
	 * @param colNumber
	 *            
	 * @return ɵı
	 */
	public PdfPTable createTable(int colNumber) {
		PdfPTable table = new PdfPTable(colNumber);
		try {
			table.setTotalWidth(maxWidth);
			table.setLockedWidth(true);
			table.setHorizontalAlignment(Element.ALIGN_CENTER);
			table.getDefaultCell().setBorder(1);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return table;
	}

	public PdfPTable createTable(float[] widths) {
		PdfPTable table = new PdfPTable(widths);
		try {
			table.setTotalWidth(maxWidth);
			table.setLockedWidth(true);
			table.setHorizontalAlignment(Element.ALIGN_CENTER);
			table.getDefaultCell().setBorder(1);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return table;
	}

	public PdfPTable createBlankTable() {
		PdfPTable table = new PdfPTable(1);
		table.getDefaultCell().setBorder(0);
		table.addCell(createCell("", keyfont));
		table.setSpacingAfter(20.0f);
		table.setSpacingBefore(20.0f);
		return table;
	}

	public <T> void generatePDF(String[] head, List<T> list, int colNum) {
		Class classType = list.get(0).getClass();
		// һֻcolNumеı
		PdfPTable table = createTable(colNum);
		// ӱע,󣬲ʾ߿
		table.addCell(createCell("APPϢб", keyfont, Element.ALIGN_LEFT, colNum, false));
		// ñͷ
		for (int i = 0; i < colNum; i++) {
			table.addCell(createCell(head[i], keyfont, Element.ALIGN_CENTER));
		}

		if (null != list && list.size() > 0) {
			int size = list.size();
			for (int i = 0; i < size; i++) {
				T t = list.get(i);
				for (int j = 0; j < colNum; j++) {
					// ĸ
					String firstLetter = head[j].substring(0, 1).toUpperCase();
					// get,getName,getAge
					String getMethodName = "get" + firstLetter + head[j].substring(1);
					Method method;
					try {
						// ͨӦgetڻӦֵ
						method = classType.getMethod(getMethodName);
						try {
							System.out.print(getMethodName + ":" + method.invoke(t, new Class[] {}) + ",");
							// 
							table.addCell(createCell(method.invoke(t, new Class[] {}).toString(), textfont));
						} catch (IllegalArgumentException e) {
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							e.printStackTrace();
						} catch (InvocationTargetException e) {
							e.printStackTrace();
						}
					} catch (SecurityException e) {
						e.printStackTrace();
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
					}
				}

				System.out.println();
			}
		}

		try {
			// ӵĵ
			document.add(table);
		} catch (DocumentException e) {
			e.printStackTrace();
		} 
			// ر
			document.close();
	}

	/**
	 * ṩõĽӿڣheadΪͷlistΪݵpdf
	 * 
	 * @param head ݱͷ
	 * @param list 
	 * @param savePath 洢ĸĿ¼
	 * @return excelڵ·
	 */
	public <T> String generatePDFs(String[] head, List<T> list,String savePath,String fileName) {
		final String FilePath = "pdfPath";
		String saveFilePathAndName = savePath + File.separator + fileName;

		// ô洢ĸĿ¼
//		String savePath = new GetFilePlace().getFileDirFromProperties(FilePath);

		// õ洢·,ɵļ
//		String realSavePath = new GenerateFold().getFold(savePath);

//		saveFilePathAndName = new GenerateFileName().generateFileName(realSavePath, "pdf");

		File file = new File(saveFilePathAndName);
		try {
			file.createNewFile();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		initFile(file);
		try {
			file.createNewFile(); // һpdfļ
		} catch (IOException e) {
			e.printStackTrace();
		}
		new ExportPDF(file).generatePDF(head, list, head.length);

		return saveFilePathAndName;
	}
	/**
	 * pdfļ
	 * @param fileMap 
	 * @param headerList
	 * @param footerList
	 * @param listData
	 * @param responses
	 */
	public void exportCommPDF(Map<String, String> fileMap, List<String> headerList, List footerList,
			List<Map> listData, HttpServletResponse responses) {
		OutputStream os = null;
		try {
			os = responses.getOutputStream();
			responses.reset();// 
			String fileName = fileMap.get("fileName");
			responses.setCharacterEncoding("utf-8");
	        responses.setHeader("Content-type", "application/pdf;charset=utf-8"); 
	        fileName = toUtf8String(fileName);
	        responses.addHeader("Content-Disposition","attachment;filename=" +fileName+".pdf");  
			// responses.setHeader("Content-disposition", "attachment;
			// filename=" + fileName + ".xls");// 趨ļͷ
			// responses.setContentType("application/msexcel");// 
			//ĵ
			initFile(os);
			//1ɱ
			PdfPTable table = createTable(headerList.size());
			// ӱע,󣬲ʾ߿
			table.addCell(createCell(fileMap.get("sheetName")+":", keyfont, Element.ALIGN_LEFT, headerList.size(), false));
			table.addCell(createCell(fileMap.get("header"), headfont, Element.ALIGN_CENTER, headerList.size(), true));
			//2ñͷ
			for(int i = 0 ; i < headerList.size() ; i++) {
	            table.addCell(createCell(headerList.get(i), textfont, Element.ALIGN_CENTER));
	        }
			//3
			for(int i=0;i<listData.size();i++){
				for(int j = 0 ; j < headerList.size() ; j++) {
		            table.addCell(createCell(StringUtil.transEmpty(listData.get(i).get(headerList.get(j))+""), textfont));
		        }
			}
			//4ӱβ
			if(footerList!=null && footerList.size()>0){
				table.addCell(createCell(StringUtil.transEmpty(footerList.get(0)+""), textfont, Element.ALIGN_CENTER, 2));
				for(int i=2;i<footerList.size();i++){
					table.addCell(createCell(StringUtil.transEmpty(footerList.get(i)+""), textfont));
				}
			}
			document.add(table);
			os.flush();
			document.close();
			logger.info("ɹPDF!");
		} catch (Exception ex) {
			logger.error("PDF", ex);
		} finally {
			try {
				os.close();
			} catch (Exception ex) {
				logger.error("رԴʧ", ex);
			}
		}
	}
	/**
	 * pdfļ
	 * @param fileMap 
	 * @param headerList
	 * @param footerList
	 * @param listData
	 * @param responses
	 */
	public void exportCommPDF(Map<String, String> fileMap, String[] headerArr, List footerList,int colspan,
			String[][] expArr, HttpServletResponse responses) {
		OutputStream os = null;
		try {
			os = responses.getOutputStream();
			responses.reset();// 
			String fileName = fileMap.get("fileName");
			responses.setCharacterEncoding("utf-8");
			responses.setHeader("Content-type", "application/pdf;charset=utf-8"); 
			fileName = toUtf8String(fileName);
			responses.addHeader("Content-Disposition","attachment;filename=" +fileName+".pdf");  
			// responses.setHeader("Content-disposition", "attachment;
			// filename=" + fileName + ".xls");// 趨ļͷ
			// responses.setContentType("application/msexcel");// 
			//ĵ
			initFile(os);
			//1ɱ
			PdfPTable table = createTable(headerArr.length);
			// ӱע,󣬲ʾ߿
			table.addCell(createCell(fileMap.get("sheetName")+":", keyfont, Element.ALIGN_LEFT, headerArr.length, false));
			table.addCell(createCell(fileMap.get("header"), headfont, Element.ALIGN_CENTER, headerArr.length, true));
			//2ñͷ
			for(int i = 0 ; i < headerArr.length ; i++) {
				table.addCell(createCell(headerArr[i], textfont, Element.ALIGN_CENTER));
			}
			//3
			for(int i=0;i<expArr.length;i++){
				for(int j = 0 ; j < expArr[i].length ; j++) {
					table.addCell(createCell(expArr[i][j], textfont));
				}
			}
			//4ӱβ
			if(footerList!=null && footerList.size()>0){
				table.addCell(createCell(StringUtil.transEmpty(footerList.get(0)+""), textfont, Element.ALIGN_CENTER, colspan));
				for(int i=colspan;i<footerList.size();i++){
					table.addCell(createCell(StringUtil.transEmpty(footerList.get(i)+""), textfont));
				}
			}
			document.add(table);
			os.flush();
			document.close();
			logger.info("ɹPDF!");
		} catch (Exception ex) {
			logger.error("PDF", ex);
		} finally {
			try {
				os.close();
			} catch (Exception ex) {
				logger.error("رԴʧ", ex);
			}
		}
	}
	// ַתutf8룬֤ļ
	public static String toUtf8String(String s) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c >= 0 && c <= 255) {
				sb.append(c);
			} else {
				byte[] b;
				try {
					b = Character.toString(c).getBytes(StandardCharsets.UTF_8);
				} catch (Exception ex) {
					b = new byte[0];
				}
				for (int j = 0; j < b.length; j++) {
					int k = b[j];
					if (k < 0)
						k += 256;
					sb.append("%" + Integer.toHexString(k).toUpperCase());
				}
			}
		}
		return sb.toString();
	}
}
