package cn.autocode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class AutoModelWEB {
	static String rl="\r\n";
	static String projectDir=System.getProperty("user.dir");
			
	public void initMode(String secondPackage, String model){
		String path = projectDir+"/WebRoot/"+secondPackage+"/"+model;
		makeDirs(path);
		
	}
	public void createWebJSP(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List fieldSizeList,List pkilist,List fieldChineseList,String chinaName)	throws IOException {
		/*
		String fullPackage= "WebRoot."+model.toLowerCase();
		String wordArray[]=fullPackage.split("\\.");
		String subDir=projectDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		*/
		String fullFileName=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model.toLowerCase()+"/"+(tablename)+"jsp";
		String fullFileName_p=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model.toLowerCase()+"/"+(tablename)+".jsp";
		String demopath = projectDir+"/src"+"/"+basePackage+"/autocode/";
		String demofile = "demojsp";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪGBKʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {
				if(line.indexOf("RHDemoService")!=-1){
					line = line.replace("RHDemoService", getFirstUppCaseName(tablename)+"Service");
				}
				if(line.indexOf("RH_DEMO_NAME")!=-1){
					line = line.replace("RH_DEMO_NAME",  (tablename));
				}
				if(line.indexOf("RH_TABLE_NAME")!=-1){
					line = line.replace("RH_TABLE_NAME", chinaName);
				}				
				if(line.indexOf("RH_DEMO_SEARCH1")!=-1){
					line = line.replace("RH_DEMO_SEARCH1", getRH_DEMO_SEARCH1(getFirstUppCaseName(tablename),fieldlist,typelist,fieldSizeList,pkilist,fieldChineseList));
				}
				if(line.indexOf("RH_DEMO_SEARCH2")!=-1){
					line = line.replace("RH_DEMO_SEARCH2", getRH_DEMO_SEARCH2(getFirstUppCaseName(tablename),fieldlist,typelist,fieldSizeList,pkilist,fieldChineseList));
				}
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}else{
			//createFileGBK(fullFileName,sb.toString());	
		}
	}
	
	public void createWebJSP_show(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List fieldSizeList,List pkilist,List fieldChineseList)	throws IOException {
		String fullPackage= "WebRoot."+secondPackage+"."+model.toLowerCase();
		String[] wordArray =fullPackage.split("\\.");
		String subDir=projectDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model.toLowerCase()+"/"+(tablename)+"_showjsp";
		String fullFileName_p=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model.toLowerCase()+"/"+(tablename)+"_show.jsp";
		String demopath = projectDir+"/src"+"/"+basePackage+"/autocode/";
		String demofile = "demo_showjsp";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪGBKʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {				
				if(line.indexOf("RH_DEMO_NAME")!=-1){
					line = line.replace("RH_DEMO_NAME",  getFirstUppCaseName(tablename));
				}				
				if(line.indexOf("RH_DEMO_DIV")!=-1){
					line = line.replace("RH_DEMO_DIV", getRH_DEMO_VIEW_DIV(getFirstUppCaseName(tablename),fieldlist,typelist,fieldSizeList,pkilist,fieldChineseList));
				}
				if(line.indexOf("RH_DEMO_VALUE")!=-1){
					line = line.replace("RH_DEMO_VALUE", getRH_DEMO_VIEW_VALUE(getFirstUppCaseName(tablename),fieldlist,typelist,pkilist,fieldChineseList));
				}
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}else{
			//createFileGBK(fullFileName,sb.toString());	
		}
	}	
	public static String getRH_DEMO_VIEW_DIV(String tablename,List fieldlist,List typelist,List fieldSizeList,List pkilist,List fieldChineseList){
		String rs = "";
		int xx = 0;
		String pki_rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);	
			String type = (String)typelist.get(i);	
			String fieldSize = (String)fieldSizeList.get(i);	
			String easyuiClass = "easyui-textbox";
			String validStr = "required:false,validType:'length[0,"+fieldSize+"]'";
			if(type.indexOf("num")!=-1||type.indexOf("dec")!=-1){
				easyuiClass = "easyui-numberbox";
			}
			boolean hasPki = false;
			for(int zz =0;zz<pkilist.size();zz++){
				String pki = (String)pkilist.get(zz);
				if(field.equals(pki)){
					pki_rs += "<input id=\""+pki+"\" type=\"hidden\" />"+rl;
					hasPki = true;
				}
			}
			if(hasPki){
				continue;
			}			
			if(xx%2==0){
				if(xx==0){
					rs += "	<div class=\"form-line clearfix\" >"+rl;
				}else{
					rs += "	<div class=\"form-line clearfix\">"+rl;
				}
			}
			rs += "		<div class=\"fl\">"+rl;
			rs += "			<span class=\"text-content\"><em class=\"must\"></em>"+fieldChineseList.get(i)+"</span> "+rl;
			rs += "			<input id=\""+field+"\" class=\""+easyuiClass+"\" data-options=\""+validStr+"\" missingMessage=\""+fieldChineseList.get(i)+"\" > "+rl;
			rs += "		</div> "+rl;		
			if(xx%2==1){
				rs += "	</div>"+rl;
			}
			if((fieldlist.size()-1)==i&&xx%2==0){
				rs += "	</div>"+rl;
			}
			xx++;
		}		
		rs = pki_rs+rs;
		return rs;
	}
	public static String getRH_DEMO_VIEW_VALUE(String tablename,List fieldlist,List typelist,List pkilist,List fieldChineseList){
		String rs = "";
		String pki_rs = "";
		int xx = 0;
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);
			String type = (String)typelist.get(i);
			boolean hasPki = false;
			for(int zz =0;zz<pkilist.size();zz++){
				String pki = (String)pkilist.get(zz);
				if(field.equals(pki)){
					pki_rs += "$(\"#"+field+"\").val(records."+field+");"+rl;
					hasPki = true;
				}
			}
			if(hasPki){
				continue;
			}						
			String useType = "textbox";
			if(type.indexOf("num")!=-1||type.indexOf("dec")!=-1){
				useType = "numberbox";
			}
			if(xx==0){
				rs += "		$(\"#"+field+"\")."+useType+"(\"setValue\",records."+field+");"+rl;
			}else{
				rs += "		$(\"#"+field+"\")."+useType+"(\"setValue\",records."+field+");"+rl;
			}
			xx++;
		}		
		return pki_rs+rs;
	}
	public static String getRH_DEMO_SEARCH1(String tablename,List fieldlist,List typelist,List fieldSizeList,List pkilist,List fieldChineseList){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);
			String type = (String)typelist.get(i);			
			if(i>3){
				break;
			}
			String useType = "textbox";
			if(type.indexOf("num")!=-1||type.indexOf("dec")!=-1){
				useType = "numberbox";
			}
			String fieldSize = (String)fieldSizeList.get(i);	
			String validStr = "data-options=\"validType:'length[0,"+fieldSize+"]'\"";
			if(i==0){
				rs += "<div class='fl'>"+rl;
				rs += "					<span class=\"text-content\">"+fieldChineseList.get(i)+"</span>"+rl;
				rs += "					<input class=\"easyui-"+useType+"\" id=\"LIKE"+field+"\" "+validStr+" >"+rl;
				rs += "				</div>"+rl;
			}else{
				rs += "				<div class='fl'>"+rl;
				rs += "					<span class=\"text-content\">"+fieldChineseList.get(i)+"</span>"+rl;
				rs += "					<input class=\"easyui-"+useType+"\" id=\"LIKE"+field+"\" "+validStr+">"+rl;
				rs += "				</div>"+rl;			
			}
		}		
		return rs;
	}
	public static String getRH_DEMO_SEARCH2(String tablename,List fieldlist,List typelist,List fieldSizeList,List pkilist,List fieldChineseList){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);	
			if(i<4){
				continue;
			}
			String fieldSize = (String)fieldSizeList.get(i);	
			String validStr = "data-options=\"validType:'length[0,"+fieldSize+"]'\"";
			if(i==4){
				rs += "<div class='fl'>"+rl;
				rs += "					<span class=\"text-content\">"+fieldChineseList.get(i)+"</span>"+rl;
				rs += "					<input id=\"LIKE"+field+"\" "+validStr+" >"+rl;
				rs += "				</div>"+rl;
			}else{
				rs += "				<div class='fl'>"+rl;
				rs += "					<span class=\"text-content\">"+fieldChineseList.get(i)+"</span>"+rl;
				rs += "					<input id=\"LIKE"+field+"\" "+validStr+" >"+rl;
				rs += "				</div>"+rl;			
			}
		}		
		return rs;
	}
	
	public static String getRH_DEMO_DIV(String tablename,List fieldlist,List typelist,List pkilist){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);		
			if(i==0){
				rs += "<div class=\"span-3\"></div>"+rl;
				rs += "					<div class=\"span-5\"><input id=\""+field+"\" class=\"span-4\" fieldName=\"\" depends=\"required,maxlength:100\"/></div>"+rl;
			}else if(i==fieldlist.size()-1){
				rs += "					<div class=\"span-3\"></div>"+rl;
				rs += "					<div class=\"span-5\"><input id=\""+field+"\" class=\"span-4\" fieldName=\"\" depends=\"required,maxlength:100\"/></div>";
			}else{
				rs += "					<div class=\"span-3\"></div>"+rl;
				rs += "					<div class=\"span-5\"><input id=\""+field+"\" class=\"span-4\" fieldName=\"\" depends=\"required,maxlength:100\"/></div>"+rl;
			}
		}		
		return rs;
	}
	
	
	public void createWebJS(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List pkilist,List fieldChineseList,String chinaName)	throws IOException {
		String RH_DEMO_PKI = "";
		if(pkilist.size()<2&&pkilist.size()>0){
			RH_DEMO_PKI = (String)pkilist.get(0);
		}
		String RH_DEMO_SEARCH = "";
		RH_DEMO_SEARCH +="' ',"+rl;
		RH_DEMO_SEARCH +="			{text:'',width:92},"+rl;
		RH_DEMO_SEARCH +="			{xtype:'textfield',id:'',width:120}"+rl;		     
		String fullPackage= "WebRoot."+secondPackage+"."+model.toLowerCase();
		String[] wordArray =fullPackage.split("\\.");
		String subDir=projectDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model+"/"+(tablename)+"js";
		String fullFileName_p=projectDir+File.separator+"WebRoot/"+secondPackage+"/"+model+"/"+(tablename)+".js";
		String demopath = projectDir+"/src"+"/"+basePackage+"/autocode/";
		String demofile = "demojs";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪGBKʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {
				if(line.indexOf("RH_PACKAGE")!=-1){
					line = line.replace("RH_PACKAGE", secondPackage+"/"+model);
				}
				if(line.indexOf("RH_DEMO_NAMEAction")!=-1){
					line = line.replace("RH_DEMO_NAMEAction",  getFirstLowCaseName(tablename)+"Action");
				}
				if(line.indexOf("RH_DEMO_NAME")!=-1){
					line = line.replace("RH_DEMO_NAME", getFirstUppCaseName(tablename));
				}
				if(line.indexOf("RH_JSPFILE")!=-1){
					line = line.replace("RH_JSPFILE", (tablename).toLowerCase());
				}
				if(line.indexOf("RH_TABLE_NAME")!=-1){
					line = line.replace("RH_TABLE_NAME", chinaName);
				}
				if(line.indexOf("RH_DEMO_DELETE_KEY")!=-1){
					line = line.replace("//RH_DEMO_DELETE_KEY", "model."+RH_DEMO_PKI+"=selRows."+RH_DEMO_PKI+";");
				}
				if(line.indexOf("RH_DEMO_UPDATE_KEY")!=-1){
					line = line.replace("//RH_DEMO_UPDATE_KEY", "model.XGTJ"+RH_DEMO_PKI+"=win.$('#"+RH_DEMO_PKI+"').textbox(\"getValue\");");
				}	
				if(line.indexOf("RH_DEMO_VALUE")!=-1){
					line = line.replace("//RH_DEMO_VALUE", getRH_DEMO_VALUE(getFirstUppCaseName(tablename),fieldlist,typelist,pkilist));
				}				
				if(line.indexOf("RH_DEMO_SEARCH_PARAM")!=-1){
					line = line.replace("//RH_DEMO_SEARCH_PARAM", getRH_DEMO_PARAM(getFirstUppCaseName(tablename),fieldlist,typelist,pkilist));
				}
				if(line.indexOf("RH_DEMO_GRID")!=-1){
					line = line.replace("//RH_DEMO_GRID", getRH_DEMO_GRID(getFirstUppCaseName(tablename),fieldlist,typelist,pkilist,fieldChineseList));
				}
				if(line.indexOf("//RH_UPDATE_PKI_VALUE")!=-1){
					line = line.replace("//RH_UPDATE_PKI_VALUE", getPki_UPDATE(pkilist));
				}
				if(line.indexOf("//RH_DELETE_PKI_VALUE")!=-1){
					line = line.replace("//RH_DELETE_PKI_VALUE", getPki_DELETE(pkilist));
				}
				if(line.indexOf("//RH_DELETE_PKILIST_VALUE")!=-1){
					line = line.replace("//RH_DELETE_PKILIST_VALUE", getPkiLIST_DELETE(pkilist));
				}
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}else{
			//createFileGBK(fullFileName,sb.toString());	
		}
	}
	public static String getPkiLIST_DELETE(List pkilist){
		String rs = "";
		String tt = ",";
		for(int i=0;i<pkilist.size();i++){
			String pki = (String)pkilist.get(i);
			if(i>0)
				break;
			rs += "selRows[i]."+pki;
		}
		return rs;
	}
	public static String getPki_DELETE(List pkilist){
		String rs = "";
		String tt = ",";
		for(int i=0;i<pkilist.size();i++){
			String pki = (String)pkilist.get(i);	
			if(i==pkilist.size()-1){
				tt = "";
			}
			rs += ""+pki+"	:	selRows."+pki+tt+rl;
		}
		return rs;
	}
	public static String getPki_UPDATE(List pkilist){
		String rs = "";
		for(int i=0;i<pkilist.size();i++){
			String pki = (String)pkilist.get(i);		
			rs += "model.XGTJ"+pki+" = jq('#"+pki+"').val();"+rl;
		}		
		return rs;
	}
	
	public static String getRH_DEMO_VALUE(String tablename,List fieldlist,List typelist,List pkilist){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);		
			if(i==0){
				rs += "model."+field+"=win.$('#"+field+"').textbox(\"getValue\");"+rl;
			}else{
				rs += "	model."+field+"=win.$('#"+field+"').textbox(\"getValue\");"+rl;
			}
		}		
		return rs;
	}
	public static String getRH_DEMO_PARAM(String tablename,List fieldlist,List typelist,List pkilist){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);		
			if(i==0){
				rs += "sParam.LIKE"+field+" = $('#LIKE"+field+"').textbox(\"getValue\");"+rl;
			}else{
				rs += "	sParam.LIKE"+field+" = $('#LIKE"+field+"').textbox(\"getValue\");"+rl;
			}
		}		
		return rs;
	}
	
	public static String getRH_DEMO_RECORDTYPE(String tablename,List fieldlist,List typelist,List pkilist){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);
			String type = ((String)typelist.get(i));
			if(type.equals("varchar")||type.equals("varchar2")||type.equals("date")||type.equals("VARCHAR")||type.equals("VARCHAR2")||type.equals("DATE")){
				type = "string";
			}
			if(type.equals("decimal")||type.equals("number")||type.equals("DECIMAL")||type.equals("NUMBER")){
				type = "int";
			}
			if(i==0){
				rs += "{name:'"+field+"',mapping:'"+field+"',type:'"+type+"'},"+rl;
			}else if(i==fieldlist.size()-1){
				rs += "		{name:'"+field+"',mapping:'"+field+"',type:'"+type+"'}";
			}else{
				rs += "		{name:'"+field+"',mapping:'"+field+"',type:'"+type+"'}, "+rl;
			}
		}		
		return rs;
	}
	public static String getRH_DEMO_GRID(String tablename,List fieldlist,List typelist,List pkilist,List fieldChineseList ){
		String rs = "";
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);		
			String fieldChinese = (String)fieldChineseList.get(i);		
			if(i==0){
				rs += "{field:'"+field+"',title:'"+field+"',hidden:true,width:120, "+rl;
				rs += "				formatter:function showClick(value,record,num){ "+rl;
				rs += "					return \"<a  href='javascript:void(0);' class='ahref' onclick='doUpdate(\"+num+\")'>\"+value+\"</a>\";"+rl;
				rs += "				}"+rl;
				rs += " 			},"+rl;
			}else if(i==fieldlist.size()-1){
				rs += "			{field:'"+field+"',title:'"+fieldChinese+"',hidden:true,width:120}";
			}else{
				String hidden = "true";
				if(i<6){
					hidden = "false";
				}
				rs += "			{field:'"+field+"',title:'"+fieldChinese+"',hidden:"+hidden+",width:120},"+rl;
			}
		}		
		return rs;
	}
	public static void createFileGBK(String fullFileName,String sb){
		try {
			OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fullFileName),"GBK");
			out.write(sb);
	        out.flush();
	        out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}	
	}
	
	public static void createFile(String fullFileName,String sb){
		try {
			OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fullFileName), StandardCharsets.UTF_8);
	        out.write(sb);
	        out.flush();
	        out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}	
	}
	public static boolean makeDirs(String path){
	    File tmpFile=new File(path);
	    boolean ret=tmpFile.mkdirs();
	    return ret;
	}
	public static String getFirstUppCaseName(String name){
		String retName ="";
		if(name.length()>0){
			retName = name.substring(0, 1).toUpperCase()+name.substring(1);
		}
		return retName;
	}
	public static String getFirstLowCaseName(String name){
		String retName ="";
		if(name.length()>0){
			retName = name.substring(0, 1).toLowerCase()+name.substring(1);
		}
		return retName;
	}
}
