package cn.yw.operationcount.arearecordcount.service;


import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.yw.operationcount.arearecordcount.dao.YwcountarearecordDao;

@Service("ywcountarearecordService")
public class YwcountarearecordService extends BaseService {
	
	private static final Log log = LogFactory.getLog(YwcountarearecordService.class);
	
	@Autowired
	private YwcountarearecordDao ywcountarearecordDao;
	
	/**
	 * ¼
	 */
	public void insert_Ywcountarearecord(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywcountarearecordDao.insert_Ywcountarearecord(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Ywcountarearecord(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywcountarearecordDao.update_Ywcountarearecord(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Ywcountarearecord(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywcountarearecordDao.delete_Ywcountarearecord(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer batch_delete_Ywcountarearecord(Map map) throws SQLException{
		return ywcountarearecordDao.batch_delete_Ywcountarearecord(map);
	}
	
	/**
	 * ѯ
	 */
	public Integer count_Ywcountarearecord(Map map) throws SQLException{
		return ywcountarearecordDao.count_Ywcountarearecord(map);
	}
	public Integer count_listareaRecordCount(Map map) throws SQLException{
		return ywcountarearecordDao.count_listareaRecordCount(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Ywcountarearecord(Map map) throws SQLException{
		return ywcountarearecordDao.query_Ywcountarearecord(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	public Map get_Ywcountarearecord(Map map) throws SQLException{
		return ywcountarearecordDao.get_Ywcountarearecord(map);
	}
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwcountarearecord(Map map) throws SQLException{
		return this.listYwcountarearecordByPage(map);
	}
	*/
	
	/**
	 * Ywcountarearecord ҳ
	 */
	public Map listYwcountarearecordByPage(Map map) throws SQLException {
		List<Map> list = ywcountarearecordDao.query_Ywcountarearecord(map);
		Integer totalCount = ywcountarearecordDao.count_Ywcountarearecord(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map listareaRecordCount(Map map) throws SQLException {
		List<Map> list = ywcountarearecordDao.listareaRecordCount(map);
		Integer totalCount = ywcountarearecordDao.count_listareaRecordCount(map);
		List<Map> result = new ArrayList<Map>(); 
		int totalSum=0,notConfigSum=0,recordnormalSum=0,recordabnormalSum=0;
		if(list!=null && list.size()>0){
			for(Map m : list){
				Map<String,Object> resultMap = new HashMap<String,Object>();
				Integer totalNum = StringUtil.str2Numeric(m.get("totalnum")+"");
				Integer confignum = StringUtil.str2Numeric(m.get("configcount")+"");
				Integer recordnormalcount = StringUtil.str2Numeric(m.get("recordnormalcount")+"");
				Integer recordabnormalcount = StringUtil.str2Numeric(m.get("recordabnormalcount")+"");
				totalSum += totalNum;
				notConfigSum += totalNum-confignum;
				recordnormalSum += recordnormalcount;
				recordabnormalSum += recordabnormalcount;
				resultMap.put("areaname", m.get("areaname"));
				resultMap.put("totalnum", totalNum);
				resultMap.put("notconfignum", totalNum-confignum);
				resultMap.put("recordnormalcount", recordnormalcount);
				resultMap.put("recordabnormalcount", recordabnormalcount);
				if((recordnormalcount+recordabnormalcount)==0){
					resultMap.put("recordintactrate", "0%");
				}else{
					resultMap.put("recordintactrate", new DecimalFormat("0.00").format(recordnormalcount*100.0/(recordnormalcount+recordabnormalcount))+"%");
				}
				result.add(resultMap);
			}
			Map<String,Object> totalMap = new HashMap<String,Object>();
			totalMap.put("totalSum", totalSum);
			totalMap.put("notconfigSum", notConfigSum);
			totalMap.put("recordnormalSum", recordnormalSum);
			totalMap.put("recordabnormalSum", recordabnormalSum);
			if((recordnormalSum+recordabnormalSum)!=0){
				totalMap.put("recordintactrate", new DecimalFormat("0.00").format(recordnormalSum*100.0/(recordnormalSum+recordabnormalSum))+"%");
			}else{
				totalMap.put("recordintactrate","0%");
			}
			result.add(totalMap);
		}
		map.clear();
		map.put("total", totalCount);
		map.put("rows", result);
		return map;
	}
}
