package cn.yw.nhyw.nhywjtjxgl.service;

 import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

 import cn.yw.nhyw.nhywjtjxgl.dao.NhywjtjxglcurrentstateDao;
 import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.im.ptxztree.dao.PtxzsDao;
 import cn.yw.machinemanage.service.YwmachinecurrentstateService;

@Service("nhywjtjxglcurrentstateService")
public class NhywjtjxglcurrentstateService extends BaseService {
	
	private static Log log = LogFactory.getLog(NhywjtjxglcurrentstateService.class);
	
	@Autowired
	private NhywjtjxglcurrentstateDao nhywjtjxglcurrentstateDao;
	@Autowired
	private PtxzsDao ptxzsDao;
	@Autowired
	private YwmachinecurrentstateService ywmachinecurrentstateService;
	
	public Map statisticsNhywjtjxglIntactRate() throws SQLException{
		Map result = nhywjtjxglcurrentstateDao.statisticsNhywjtjxglIntactRate();
		return result;
	}
	public Map statisticsNhywjtjxglOnlineRate(Map param) throws SQLException{
		return nhywjtjxglcurrentstateDao.statisticsNhywjtjxglOnlineRate(param);
	}
	public Map statisticsRecordIntactRate() throws SQLException{
		return nhywjtjxglcurrentstateDao.statisticsRecordIntactRate();
	}
	public Map nhywjtjxglCurrentStateStatistics(Map map) throws SQLException{
		Map<String,List<Map>> result= new HashMap<String,List<Map>>();
		List<Map> lists = nhywjtjxglcurrentstateDao.nhywjtjxglCurrentStateStatistics(map);
//		if(lists!=null && lists.size()>0){
//			for(Map m : lists){
//				result.put(m.get("name")+"", m.get("total")+"");
//			}
//		}
		result.put("data",lists);
		return result;
	}
	
	/**
	 * �����¼
	 */
	/*
	public void insert_nhywjtjxglcurrentstate(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		nhywjtjxglcurrentstateDao.insert_nhywjtjxglcurrentstate(map);
	}
	*/

	/**
	 * �޸ļ�¼
	 */
	public Integer update_nhywjtjxglcurrentstate(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return nhywjtjxglcurrentstateDao.update_nhywjtjxglcurrentstate(map);
	}
	public Integer update_nhywjtjxglcurrentstate_WorkOrder(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return nhywjtjxglcurrentstateDao.update_nhywjtjxglcurrentstate_WorkOrder(map);
	}
	
	
	/**
	 * ɾ����¼
	 */
	/*
	public Integer delete_nhywjtjxglcurrentstate(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return nhywjtjxglcurrentstateDao.delete_nhywjtjxglcurrentstate(map);
	}
	*/
	
	/**
	 * ������ɾ����¼
	 */
	/*
	public Integer batch_delete_nhywjtjxglcurrentstate(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.batch_delete_nhywjtjxglcurrentstate(map);
	}
	*/
	
	/**
	 * ��ѯ����
	 */
	public Integer count_nhywjtjxglcurrentstate(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.count_nhywjtjxglcurrentstate(map);
	}
	
	/**
	 * ��ѯ�б��¼SELECT
	 */
	public List<Map> query_nhywjtjxglcurrentstate(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.query_nhywjtjxglcurrentstate(map);
	}
	
	/**
	 * ��ѯһ��
	 */
	 
	public Map get_nhywjtjxglcurrentstate(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.get_nhywjtjxglcurrentstate(map);
	}
	
	/**
	 * ����EXCEL
	 */
	 
	/*
	public Map exportnhywjtjxglcurrentstate(Map map) throws SQLException{
		return this.listnhywjtjxglcurrentstateByPage(map);
	}
	*/
	
	/**
	 * nhywjtjxglcurrentstate ��ҳ
	 */
	public Map listnhywjtjxglcurrentstateByPage(Map map) throws SQLException {
		List<Map> list = nhywjtjxglcurrentstateDao.query_nhywjtjxglcurrentstate(map);
		Integer totalCount = nhywjtjxglcurrentstateDao.count_nhywjtjxglcurrentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map listNhywjtjxglDetailByPage(Map map) throws SQLException {
		List<Map> list = nhywjtjxglcurrentstateDao.query_nhywjtjxglcurrentstate_detail(map);
		Integer totalCount = nhywjtjxglcurrentstateDao.count_nhywjtjxglcurrentstate_detail(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map vdqStatisticsRegion(Map map) throws SQLException {
		List<Map> result = new ArrayList<Map>();
		List<Map> list = nhywjtjxglcurrentstateDao.vdqStatisticsRegion(map);
		Integer totalCount = nhywjtjxglcurrentstateDao.count_vdqStatisticsRegion(map);
		int monitorSum = 0,noinspectionSum = 0,zxSum = 0,lxSum = 0,
				videoabnormalSum = 0,videonormalSum = 0,nosignalstatusSum = 0,
				videoocclusionstatusSum = 0,scenechangestatusSum = 0,imgtoodarkstatusSum = 0,
				imgoverbrightstatusSum = 0,imgclearstatusSum = 0,imgcolorstatusSum = 0;
		for(Map m : list){
			Map<String,Object> mapTemp = new HashMap<String,Object>();
			mapTemp.put("videocatalog", m.get("videocatalog"));
			mapTemp.put("videocatalogname", m.get("videocatalogname")==null?"-":m.get("videocatalogname"));
			mapTemp.put("nosignalstatusnum", StringUtil.str2Numeric(m.get("nosignalstatusnum")+""));
			mapTemp.put("videoocclusionstatusnum", StringUtil.str2Numeric(m.get("videoocclusionstatusnum")+""));
			mapTemp.put("scenechangestatusnum", StringUtil.str2Numeric(m.get("scenechangestatusnum")+""));
			mapTemp.put("imgtoodarkstatusnum", StringUtil.str2Numeric(m.get("imgtoodarkstatusnum")+""));
			mapTemp.put("imgoverbrightstatusnum", StringUtil.str2Numeric(m.get("imgoverbrightstatusnum")+""));
			mapTemp.put("imgclearstatusnum", StringUtil.str2Numeric(m.get("imgclearstatusnum")+""));
			mapTemp.put("imgcolorstatusnum", StringUtil.str2Numeric(m.get("imgcolorstatusnum")+""));
			int jknum = StringUtil.str2Numeric(m.get("jknum")+"");//Ѳ����
			int totalnum = StringUtil.str2Numeric(m.get("totalnum")+"");//��λ����
			mapTemp.put("totalnum", totalnum);
			mapTemp.put("noinspectionnum", totalnum-jknum);//δѲ��
			int lxnum = StringUtil.str2Numeric(m.get("lxnum")+"");
			int zxnum = StringUtil.str2Numeric(m.get("zxnum")+"");
			mapTemp.put("lxnum", lxnum);//������
			mapTemp.put("zxnum", zxnum);//������
			int videoabnormalnum = StringUtil.str2Numeric(m.get("videoabnormalnum")+"");
			int videonormalnum = StringUtil.str2Numeric(m.get("videonormalnum")+"");
			mapTemp.put("videoabnormalnum", videoabnormalnum);//��Ƶ�쳣��
			mapTemp.put("videonormalnum", videonormalnum);//��Ƶ������
			if(jknum==0){
				mapTemp.put("zxrate", "0%");
				mapTemp.put("videorate", "0%");
			}else{
				mapTemp.put("zxrate", new DecimalFormat("0.00").format((zxnum)*100.0/jknum)+"%");
				mapTemp.put("videorate", new DecimalFormat("0.00").format((videonormalnum)*100.0/jknum)+"%");
			}
			//�ܼ�
			monitorSum += totalnum;
			noinspectionSum += totalnum-jknum;
			zxSum += zxnum;
			lxSum += lxnum;
			videoabnormalSum += videoabnormalnum;
			videonormalSum += videonormalnum;
			nosignalstatusSum += StringUtil.str2Numeric(m.get("nosignalstatusnum")+"");
			videoocclusionstatusSum += StringUtil.str2Numeric(m.get("videoocclusionstatusnum")+"");
			scenechangestatusSum += StringUtil.str2Numeric(m.get("scenechangestatusnum")+"");
			imgtoodarkstatusSum += StringUtil.str2Numeric(m.get("imgtoodarkstatusnum")+"");
			imgoverbrightstatusSum += StringUtil.str2Numeric(m.get("imgoverbrightstatusnum")+"");
			imgclearstatusSum += StringUtil.str2Numeric(m.get("imgclearstatusnum")+"");
			imgcolorstatusSum += StringUtil.str2Numeric(m.get("imgcolorstatusnum")+"");
			result.add(mapTemp);
		}
		//�ܼ�
		Map<String,Object> totalMap = new HashMap<String,Object>();
		totalMap.put("monitorSum", monitorSum);
		totalMap.put("noinspectionSum", noinspectionSum);
		totalMap.put("zxSum", zxSum);
		totalMap.put("lxSum", lxSum);
		totalMap.put("videoabnormalSum", videoabnormalSum);
		totalMap.put("videonormalSum", videonormalSum);
		totalMap.put("nosignalstatusSum", nosignalstatusSum);
		totalMap.put("videoocclusionstatusSum", videoocclusionstatusSum);
		totalMap.put("scenechangestatusSum", scenechangestatusSum);
		totalMap.put("imgtoodarkstatusSum", imgtoodarkstatusSum);
		totalMap.put("imgoverbrightstatusSum", imgoverbrightstatusSum);
		totalMap.put("imgclearstatusSum", imgclearstatusSum);
		totalMap.put("imgcolorstatusSum", imgcolorstatusSum);
		if((zxSum+lxSum)!=0){
			//totalMap.put("zxrate", new DecimalFormat("0.00").format(zxSum*100.0/(zxSum+lxSum))+"%");
			totalMap.put("zxrate", new DecimalFormat("0.00").format(zxSum*100.0/monitorSum)+"%");
		}else{
			totalMap.put("zxrate","0.00%");
		}
		if((videoabnormalSum+videonormalSum)!=0){
			//totalMap.put("videorate", new DecimalFormat("0.00").format(videonormalSum*100.0/(videoabnormalSum+videonormalSum))+"%");
			totalMap.put("videorate", new DecimalFormat("0.00").format(videonormalSum*100.0/monitorSum)+"%");
		}else{
			totalMap.put("videorate","0.00%");
		}
		result.add(totalMap);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", result);
		return map;
	}
	// ��Ƶ�������ͳ������
	public Integer count_vdqStatisticsRegion(Map map) throws SQLException {
		return nhywjtjxglcurrentstateDao.count_vdqStatisticsRegion(map);
	}
	// ����������ͳ��        ================== start
		public List<Map> query_areaOnline(Map map) throws SQLException{
			return nhywjtjxglcurrentstateDao.query_areaOnline(map);
		}
	public List<Map> query_xhdareaOnline(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.query_xhdareaOnline(map);
	}

	public Integer count_xhdareaOnline(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.count_xhdareaOnline(map);
	}

	public Integer count_areaOnline(Map map) throws SQLException{
			return nhywjtjxglcurrentstateDao.count_areaOnline(map);
		}
		
	public List<Map> query_AreaNotonlineDetail(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.query_AreaNotonlineDetail(map);
	}
	public Integer count_AreaNotonlineDetail(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.count_AreaNotonlineDetail(map);
	}
		// ����������ͳ��        ================== end

	//����������̖����led
	public List<Map> query_AreaNotonlineDeviceDetail(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.query_AreaNotonlineDeviceDetail(map);
	}
	public Integer count_AreaNotonlineDeviceDetail(Map map) throws SQLException{
		return nhywjtjxglcurrentstateDao.count_AreaNotonlineDeviceDetail(map);
	}

	// ��ҳͳ��
		public Map count_HomepageFalultType(Map map) throws SQLException{
			Map res = nhywjtjxglcurrentstateDao.count_HomepageFalultType(map);
			return res;
		}
		// ��ҳ  �м��ѯ�豸
		public Map query_videoState(Map map) throws SQLException{
			List<Map> list = nhywjtjxglcurrentstateDao.query_videoState(map);
			Integer totalCount = nhywjtjxglcurrentstateDao.count_videoState(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			return map;
		}
	/**
	 * ��ȡ�����豸��״����
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map queryVideoTree(Map map) throws SQLException{
		//���ս��map
		Map<String,Object> result = new HashMap<String,Object>();
		//��ȡ�����������Ϣ
		Map<String,Object> machineMap = new HashMap<String,Object>();
		List<Map> listMachine = ywmachinecurrentstateService.listMachineInfo(map);
		Map machineIntactMap =  ywmachinecurrentstateService.listStatisticsMachineIntactRate();
		machineMap.put("intactRate","0.00%");
		machineMap.put("children",listMachine);
		if(machineIntactMap!=null && machineIntactMap.size()>0){
			Integer machineIntactNum = StringUtil.str2Numeric(machineIntactMap.get("intactNum")+"");
			Integer machineUnIntactNum = StringUtil.str2Numeric(machineIntactMap.get("unIntactNum")+"");
			if((machineIntactNum+machineUnIntactNum)>0){
				machineMap.put("intactRate", new DecimalFormat("0.00").format(machineIntactNum*100.0/(machineIntactNum+machineUnIntactNum))+"%");
			}
		}
		result.put("machine", machineMap);
		//��ȡ��������Ϣ
		List<Map> listVideo = new ArrayList<Map>();
		String rootNode = StringUtil.transEmpty(map.get("sjxzbh")+"");
		List<Map> list = ptxzsDao.query_Ptxzs(map);
		if(list!=null && list.size()>0){
			for(Map m : list){
				StringBuilder conditionXzbh = new StringBuilder();
				Map<String,Object> tempMap = new HashMap<String,Object>();
				String xzbh = StringUtil.transEmpty(m.get("xzbh")+"");
				conditionXzbh.append(" and videocatalog in ('").append(xzbh).append("'");
				conditionXzbh = getAllXzbh(xzbh,conditionXzbh).append(")");
				tempMap.put("tableparam", conditionXzbh.toString());
				//��ȡ��Ŀ¼�����豸��Ϣ
				List<Map> videoList = nhywjtjxglcurrentstateDao.getDpVideoByXzbh(tempMap);
				List<Map> intactList = nhywjtjxglcurrentstateDao.getDpIntact(tempMap);
				if(intactList!=null && intactList.size()>0){
					Integer total = 0;
					Integer intactNum = 0;
					for(Map intactM : intactList){
						String name = intactM.get("name")+"";
						if("total".equals(name)){
							total = StringUtil.str2Numeric(intactM.get("total")+"");
						}else if("intactnum".equals(name)){
							intactNum = StringUtil.str2Numeric(intactM.get("total")+"");
							
						}
					}
					if(total>0){
						tempMap.put("intactRate", new DecimalFormat("0.00").format(intactNum*100.0/total)+"%");
					}else{
						tempMap.put("intactRate", "0.00%");
						
					}
							
				}
				tempMap.put("children", videoList);
				tempMap.put("xzbh", xzbh);
				tempMap.put("xzmc", m.get("xzmc"));
				listVideo.add(tempMap);
			}
		}
		result.put("video", listVideo);
		return result;
	}
	/**
	 * �ݹ��ȡĳ�ڵ��������������
	 * @param parentXzbh
	 * @param conditionXzbh
	 * @return
	 */
	public StringBuilder getAllXzbh(String parentXzbh,StringBuilder conditionXzbh){
//		String result = "('"+parentXzbh+"'";
		Map<String,String> map = new HashMap<String,String>();
		map.put("sjxzbh", parentXzbh);
		try {
			List<Map> list = ptxzsDao.query_Ptxzs(map);
			if(list!=null && list.size()>0){
				for(Map m : list){
					String xzbh = StringUtil.transEmpty(m.get("xzbh")+"");
					conditionXzbh.append(",'").append(xzbh).append("'");
					getAllXzbh(xzbh,conditionXzbh);
				}
			}else{
				return conditionXzbh;
			}
		} catch (SQLException e) {
			e.printStackTrace();
			return null;
		}
		return conditionXzbh;
		
	}

	public Map queryjsgs(Map map) throws SQLException {
		return  nhywjtjxglcurrentstateDao.queryjsgs(map);
	}
	public Integer updatejsgs(Map map) throws SQLException {
		return  nhywjtjxglcurrentstateDao.updatejsgs(map);
	}
	public Integer update_sbtdspsrRemarks(Map map) throws SQLException {
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return  nhywjtjxglcurrentstateDao.update_sbtdspsrRemarks(map);
	}
	public Integer update_nhywjtjxglcurrentstateRepairState(Map map) throws SQLException {
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return  nhywjtjxglcurrentstateDao.update_nhywjtjxglcurrentstateRepairState(map);
	}

}
