package cn.yw.softwaremanage.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.softwaremanage.dao.YwsoftwarelistDao;

@Service("ywsoftwarelistService")
public class YwsoftwarelistService extends BaseService {
	
	private static final Log log = LogFactory.getLog(YwsoftwarelistService.class);
	
	@Autowired
	private YwsoftwarelistDao ywsoftwarelistDao;
	
	/**
	 * ¼
	 */
	
	public void insert_Ywsoftwarelist(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywsoftwarelistDao.insert_Ywsoftwarelist(map);
	}
	

	
	/**
	 * ޸ļ¼
	 */
	
	public Integer update_Ywsoftwarelist(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywsoftwarelistDao.update_Ywsoftwarelist(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer delete_Ywsoftwarelist(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywsoftwarelistDao.delete_Ywsoftwarelist(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer batch_delete_Ywsoftwarelist(Map map) throws SQLException{
		return ywsoftwarelistDao.batch_delete_Ywsoftwarelist(map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Ywsoftwarelist(Map map) throws SQLException{
		return ywsoftwarelistDao.count_Ywsoftwarelist(map);
	}
	
	
	/**
	 * ѯб¼SELECT
	 */
	
	public List<Map> query_Ywsoftwarelist(Map map) throws SQLException{
		return ywsoftwarelistDao.query_Ywsoftwarelist(map);
	}
	
	
	/**
	 * ѯһ
	 */
	 
	
	public Map get_Ywsoftwarelist(Map map) throws SQLException{
		return ywsoftwarelistDao.get_Ywsoftwarelist(map);
	}
	
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwsoftwarelist(Map map) throws SQLException{
		return this.listYwsoftwarelistByPage(map);
	}
	*/
	
	/**
	 * Ywsoftwarelist ҳ
	 */
	
	public Map listYwsoftwarelistByPage(Map map) throws SQLException {
		List<Map> list = ywsoftwarelistDao.query_Ywsoftwarelist(map);
		Integer totalCount = ywsoftwarelistDao.count_Ywsoftwarelist(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
}
