package cn.yw.repairmanage.action;


import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.pdf.ExportPDF;
import cn.base.util.*;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarm.service.YwalarmeventinfoService;
import cn.yw.detector.service.DetectorService;
import cn.yw.machinemanage.service.YwmachinecurrentstateService;
import cn.yw.nhyw.nhywjtledydpgl.service.NhywjtledydpglService;
import cn.yw.nhyw.nhywjtxhdgl.service.NhywjtxhdglService;
import cn.yw.repairmanage.service.YwrepairjobinfoService;
import cn.yw.repairmanage.service.YwrepairjoboplogService;
import cn.yw.video.videostate.service.YwvideocurrentstateService;
import cn.yw.zxld.service.ZxldService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

//import cn.base.excel.ExcelReader;

@SuppressWarnings({"all"})
@Component("ywrepairjobinfoAction")
public class YwrepairjobinfoAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(YwrepairjobinfoAction.class);
    String urlStr = "https://44.64.176.222/api.php?appkey=ww123456&tradeCode=networkdevicelist&limit=500";
    String urlStrdept = "https://44.64.176.222/api.php?appkey=ww123456&tradeCode=departlist&limit=500";
    @Autowired
    private YwrepairjobinfoService service;
    @Autowired
    private YwrepairjoboplogService ywrepairjoboplogService;
    @Autowired
    private YwvideocurrentstateService ywvideocurrentstateService;
    @Autowired
    private YwmachinecurrentstateService ywmachinecurrentstateService;
    @Autowired
    private YwalarmeventinfoService ywalarmeventinfoService;

    @Autowired
    private NhywjtledydpglService nhywjtledydpglService;
    @Autowired
    private DetectorService detectorService;

    @Autowired
    private NhywjtxhdglService nhywjtxhdglService;

    @Autowired
    private ZxldService zxldService;

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listYwrepairjobinfoByPage")
    public void listYwrepairjobinfoByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String yhbh = ptyh.getYhbh();
            String bmbh = ptyh.getBmbh();
            String yhzh = ptyh.getYhzh();
            Integer sfgly = ptyh.getSfgly();
            String flag = map.get("flag") + "";
            if ("null".equals(flag) || StringUtils.isEmpty(flag) || "my".equals(flag)) {  //칤--ҵĹ
                //map.put("jobreportcompany", bmbh);
                map.put("jobreportpeople", yhzh);
                map.put("jobprocessstate", 901);
            } else if ("accept".equals(flag)) {  //칤--
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("jobacceptcompany", bmbh);
                    map.put("jobacceptpeople", yhzh);
                }
                map.put("jobprocessstates", " jobprocessstate in ('901','904')");
            } else if ("feedback".equals(flag)) {    //칤--
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("feedbackcompany", bmbh);
                    map.put("feedbackpeople", yhzh);
                }
                map.put("jobprocessstates", " jobprocessstate in ('902','913')"); // TODO jobprocessstates
            } else if ("confirm".equals(flag)) {    //칤--ȷϹ
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("confirmcompany", bmbh);
                    map.put("confirmpeople", yhzh);
                }
                map.put("jobprocessstates", " jobprocessstate in ('906','916')");
            } else if ("check".equals(flag)) {    //칤--չ
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("confirmcompany", bmbh);
                    map.put("receiverpeople", yhzh);
                }
                map.put("jobprocessstate", 911);
            } else if ("delay".equals(flag)) {        //칤--ڴ
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("delayforcompany", bmbh);
                    map.put("delayforpeople", yhzh);
                }
                map.put("jobprocessstate", 908);
            } else if ("todo".equals(flag)) { //ҳʾ
                if (sfgly == 1) { //Աѯд칤
                    //901ϱ-902ά--904906ѷȷϣ908ˣ913άȷϲͨ
                    String comprehensive = " jobprocessstate in ('901','902','904','906','908','913')";
                    map.put("comprehensive", comprehensive);
                } else { //ѯǰûĴ칤
                    String comprehensive = " (extend1='" + yhzh + "') "
                            + " and jobprocessstate in ('901','902','904','906','908','913')";
                    map.put("comprehensive", comprehensive);
                }
				/*
				String comprehensive = " ((jobreportcompany='"+bmbh+"' and jobreportpeople='"+yhzh+"') "
						+" or (jobacceptcompany='"+bmbh+"' and jobacceptpeople='"+yhzh+"') "
						+" or (feedbackcompany='"+bmbh+"' and feedbackpeople='"+yhzh+"') "
						+" or (delayforcompany='"+bmbh+"' and delayforpeople='"+yhzh+"') "
						+" or (confirmcompany='"+bmbh+"' and confirmpeople='"+yhzh+"') ) "
						+ " and jobprocessstate in ('901','902','904','906',908)";
				*/

            } else {//ۺϲѯ
                //Աѯ
                if (ptyh.getSfgly() != 1) {

                    String comprehensive = " ((jobreportcompany='" + bmbh + "' and jobreportpeople='" + yhzh + "') "
                            + " or (jobacceptcompany='" + bmbh + "' and jobacceptpeople='" + yhzh + "') "
                            + " or (feedbackcompany='" + bmbh + "' and feedbackpeople='" + yhzh + "') "
                            + " or (delayforcompany='" + bmbh + "' and delayforpeople='" + yhzh + "') "
                            + " or (confirmcompany='" + bmbh + "' and confirmpeople='" + yhzh + "')"
                            + " or (receivercompany='" + bmbh + "' and receiverpeople='" + yhzh + "') )";
                    map.put("comprehensive", comprehensive);
                }
            }

            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listYwrepairjobinfoByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listYwrepairjobinfoByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ
     */
    //@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywrepairjobinfo")
    public void count_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Ywrepairjobinfo(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-count_Ywrepairjobinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ Ywrepairjobinfo
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_Ywrepairjobinfo")
    public void query_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_Ywrepairjobinfo(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-query_Ywrepairjobinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ һYwrepairjobinfo
     */
    @OperateType(value = LogConstants.LOG_GET, info = "get_Ywrepairjobinfo")
    public void get_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            // ȡû
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            map.put("yhbh", ptyh.getYhbh());
            Map ywrepairjobinfoMap = this.service.get_Ywrepairjobinfo(map);
            if (ywrepairjobinfoMap != null) {
                ywrepairjobinfoMap.put("yhbh", ptyh.getYhbh());
                ywrepairjobinfoMap.put("yhzh", ptyh.getYhzh());
            }
            Struts2Utils.renderJson(ywrepairjobinfoMap);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoActionquery_Ywrepairjobinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "deleteYwrepairjobinfo")
    public void delete_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Ywrepairjobinfo(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-delete_Ywrepairjobinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Ywrepairjobinfo")
    public void insert_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String username = ptyh.getYhzh();
            map.put("createaccount", username);
            map.put("modifyaccount", username);
            map.put("createtime", DateUtil.currentDateTime());
            map.put("modifytime", DateUtil.currentDateTime());
            String jobid = null;
            if (StringUtil.checkEmpty(map.get("jobid"))) {
                jobid = StringUtil.getUUID();
                map.put("jobid", jobid);
            } else {
                jobid = map.get("jobid").toString();
            }
            service.insert_Ywrepairjobinfo(map);
            //  ־Ӽ¼  ywrepairjoboplog
            String faultdescription = map.get("faultdescription") == null ? "" : String.valueOf(map.get("faultdescription"));
            insert_repairjoboplog(jobid, "901", faultdescription, ptyh);
			/*Map logMap = new HashMap();
			logMap.put("logId", StringUtil.getUUID());
			logMap.put("jobid", jobid);
			logMap.put("processstate", "901");
			logMap.put("processtime", DateUtil.currentDateTime());
			logMap.put("processcompany", ptyh.getBmbh());
			logMap.put("processpeople", username);
			logMap.put("processphone", ptyh.getSjhm());
			logMap.put("processdescription", map.get("faultdescription"));
			logMap.put("createaccount", username);
			logMap.put("modifyaccount", username);
			logMap.put("createtime", DateUtil.currentDateTime());
			logMap.put("modifytime", DateUtil.currentDateTime());
			ywrepairjoboplogService.insert_Ywrepairjoboplog(logMap);*/

            //  ywvideocurrentstate      ywmachinecurrentstate + ywalarmeventinfo 
            String alarmdevicetype = map.get("faultdevicetype") == null ? "" : String.valueOf(map.get("faultdevicetype"));
            String alarmdeviceid = map.get("faultdeviceid") == null ? "" : String.valueOf(map.get("faultdeviceid"));
            String channelnum = map.get("channelnum") == null ? "" : String.valueOf(map.get("channelnum"));
            String repairstate = "901";
            String alarmeventid = map.get("alarmeventid") == null ? "" : String.valueOf(map.get("alarmeventid"));
            updateState(alarmdevicetype, repairstate, alarmdeviceid, channelnum, alarmeventid);

            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-insert_Ywrepairjobinfo()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Ywrepairjobinfo")
    public void update_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Ywrepairjobinfo(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    int result = service.update_Ywrepairjobinfo(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                int result = service.update_Ywrepairjobinfo(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-update_Ywrepairjobinfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_delete_Ywrepairjobinfo")
    public void batch_delete_Ywrepairjobinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Map m = new HashMap();
            if(null!=map.get("keyword"))
            m.put("keyword", map.get("keyword").toString().split(","));
            int result = service.batch_delete_Ywrepairjobinfo(m);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-batch_delete_Ywrepairjobinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    // ѯûϢ
    public void getUserInfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean userInfo = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String yhbh = userInfo.getYhbh();
            map.put("yhbh", yhbh);
            Map user = service.getUserInfo(map);
            Struts2Utils.renderJson(user);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-getUserInfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    // ȨڵĲ
    public void getReportBm() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            List list = service.getReportBm(map);
            Struts2Utils.renderJson(list);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-getUserInfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    // Ȩ
    public void getReportUser() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            List list = service.getReportUser(map);
            Struts2Utils.renderJson(list);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-getReportUser-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ״̬     豸  豸 + ywalarmeventinfo ״̬
     *
     * @param alarmdevicetype 豸  1    2
     * @param jobacceptstate  ״̬
     * @param deviceId        豸
     * @param channelnum      ͨ
     * @param eventId         澯¼id
     * @throws SQLException
     */
    private void updateState(String alarmdevicetype, String jobacceptstate, String deviceId,
                             String channelnum, String eventId) throws SQLException {

        PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
        if ("1".equals(alarmdevicetype)) {                // 豸
            Map videoMap = new HashMap();
            videoMap.put("XGTJvideonum", deviceId);
            videoMap.put("XGTJchannelnum", channelnum);
            videoMap.put("repairstate", jobacceptstate);
            videoMap.put("modifyaccount", ptyh.getYhzh());
            videoMap.put("modifytime", DateUtil.currentDateTime());
            ywvideocurrentstateService.update_Ywvideocurrentstate(videoMap);
        } else if ("2".equals(alarmdevicetype)) {            // 豸
            Map machineMap = new HashMap();
            machineMap.put("XGTJmachineid", deviceId);
            machineMap.put("repairstate", jobacceptstate);
            machineMap.put("modifyaccount", ptyh.getYhzh());
            machineMap.put("modifytime", DateUtil.currentDateTime());
            ywmachinecurrentstateService.update_Ywmachinecurrentstate(machineMap);
        } else if ("3".equals(alarmdevicetype)) {            // źŵ
            Map machineMap = new HashMap();
            machineMap.put("XGTJxh", deviceId);
            machineMap.put("repairstate", jobacceptstate);
            nhywjtxhdglService.update_NhyxhdCurrentState(machineMap);
        } else if ("4".equals(alarmdevicetype)) {            // յ
            Map machineMap = new HashMap();
            machineMap.put("XGTJxh", deviceId);
            machineMap.put("repairstate", jobacceptstate);
            nhywjtledydpglService.update_NhywledydpCurrentState(machineMap);
        } else if ("10".equals(alarmdevicetype) || "11".equals(alarmdevicetype)) {            // "10"://ش,"11"://΢
            Map machineMap = new HashMap();
            if ("10".equals(alarmdevicetype)) {
                machineMap.put("detectortype", "GVD");
            } else if ("11".equals(alarmdevicetype)) {
                machineMap.put("detectortype", "SMARTSENSOR");
            }
            machineMap.put("XGTJid", deviceId);
            machineMap.put("repairstate", jobacceptstate);
            detectorService.update_DetectorCurrentState(machineMap);
        } else if ("12".equals(alarmdevicetype)) {            // ״
            Map machineMap = new HashMap();
            machineMap.put("XGTJxh", deviceId);
            machineMap.put("repairstate", jobacceptstate);
            zxldService.update_ZxldCurrentState(machineMap);
        }
        //  ywalarmeventinfo ״̬
        Map eventMap = new HashMap();
        eventMap.put("XGTJalarmeventid", eventId);
        eventMap.put("processstatus", jobacceptstate);
        eventMap.put("modifyaccount", ptyh.getYhzh());
        eventMap.put("modifytime", DateUtil.currentDateTime());
        ywalarmeventinfoService.update_Ywalarmeventinfo(eventMap);

    }


    /**
     * ݵ ־   ywrepairjoboplog
     *
     * @param jobid              id
     * @param processstate       ״̬
     * @param processdescription 
     * @param ptyh               ȡûϢ
     * @throws SQLException
     */
    private void insert_repairjoboplog(String jobid, String processstate,
                                       String processdescription, PtyhBean ptyh) throws SQLException {
        Map logMap = new HashMap();
        logMap.put("logId", StringUtil.getUUID());
        logMap.put("jobid", jobid);
        logMap.put("processstate", processstate);
        logMap.put("processtime", DateUtil.currentDateTime());
        logMap.put("processcompany", ptyh.getBmbh());
        logMap.put("processpeople", ptyh.getYhzh());
        logMap.put("processphone", ptyh.getSjhm());
        logMap.put("processdescription", processdescription);
        logMap.put("createaccount", ptyh.getYhzh());
        logMap.put("modifyaccount", ptyh.getYhzh());
        logMap.put("createtime", DateUtil.currentDateTime());
        logMap.put("modifytime", DateUtil.currentDateTime());
        ywrepairjoboplogService.insert_Ywrepairjoboplog(logMap);
    }

    /**
     * -
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "updateWorkOrderInfo")
    public void updateWorkOrderInfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean userInfo = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String userName = userInfo.getYhzh();
            String bmbh = userInfo.getBmbh();
            String now = DateUtil.currentDateTime();
            //ǰ
            String deviceType = map.get("faultdevicetype") + "";
            if (!("null".equals(deviceType) || StringUtils.isEmpty(deviceType))) {
				/*if("1".equals(deviceType)){//
					ywvideocurrentstateService.update_Ywvideocurrentstate_WorkOrder(map);
				}else if("2".equals(deviceType)){//
					ywmachinecurrentstateService.update_Ywmachinecurrentstate_WorkOrder(map);
				}*/
                //״̬
                updateState(deviceType, StringUtil.transEmpty(map.get("processstatus") + ""),
                        StringUtil.transEmpty(map.get("XGTJfaultdeviceid") + ""),
                        StringUtil.transEmpty(map.get("XGTJchannelnum") + ""),
                        StringUtil.transEmpty(map.get("XGTJalarmeventid") + ""));
            }
//			//澯
//			ywalarmeventinfoService.update_Ywalarmeventinfo(map);
            //άά޹Ϣ
            String jobprocessstate = map.get("jobprocessstate") + "";
            if (!("null".equals(jobprocessstate) || StringUtils.isEmpty(jobprocessstate))) {
                if ("911".equals(jobprocessstate)) {
                    map.put("actualfinishtime", now);
                    String jobreporttime = map.get("jobreporttime") + "";
                    if (!("null".equals(jobreporttime) || StringUtils.isEmpty(jobreporttime))) {
                        map.put("repairdays", DateUtil.subtractDay(jobreporttime, now));
                    }
                } else if ("904".equals(jobprocessstate)) {
                    // 
                    // =ǰû
                    map.put("hanguppeople", userInfo.getYhbh());
                    // ʱ=ǰʱ
//					map.put("hanguptime", now);
                    // ˵λ=ǰûλ
                    map.put("hangupcompany", userInfo.getBmbh());
                } else if ("905".equals(jobprocessstate)) {
                    // ȡ
                    // ȡ=ǰû
                    map.put("unhanguppeople", userInfo.getYhbh());
                    // ȡʱ=ǰʱ
//					map.put("unhanguptime", now);
                    // ȡ˵λ=ǰûλ
                    map.put("unhangupcompany", userInfo.getBmbh());
                }
            }
            map.put("modifyaccount", userName);
            map.put("modifytime", now);
            map.put("XGTJchannelnum", StringUtil.transEmpty(map.get("XGTJchannelnum") + ""));
            service.update_Ywrepairjobinfo(map);
            //־
            Map<String, Object> insertLog = new HashMap<String, Object>();
            insertLog.put("logId", StringUtil.getUUID());
            insertLog.put("jobid", map.get("XGTJjobid"));
            insertLog.put("processstate", map.get("processstatus"));
            insertLog.put("processtime", now);
            insertLog.put("createaccount", userName);
            insertLog.put("createtime", now);
            insertLog.put("processcompany", bmbh);
            insertLog.put("processpeople", userName);
            insertLog.put("processdescription", map.get("processdescription"));
            ywrepairjoboplogService.insert_Ywrepairjoboplog(insertLog);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-updateWorkOrderInfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    @OperateType(value = LogConstants.LOG_UPDATE, info = "edit_confirmOrder")
    public void edit_confirmOrder() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //  Ywrepairjobinfo 
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            map.put("modifyaccount", ptyh.getYhzh());
            map.put("modifytime", DateUtil.currentDateTime());
            int result = service.update_Ywrepairjobinfo(map);

            String repairstate = null;
            String processdescription = null;
            String flag = String.valueOf(map.get("flag"));
            if ("feedback".equals(flag)) {
                repairstate = map.get("jobprocessstate") == null ? "" : String.valueOf(map.get("jobprocessstate"));
                processdescription = map.get("delaycause") == null ? "" : String.valueOf(map.get("delaycause"));
            } else if ("delay".equals(flag)) {
                repairstate = map.get("delayforstate") == null ? "" : String.valueOf(map.get("delayforstate"));
                processdescription = map.get("delayfordescription") == null ? "" : String.valueOf(map.get("delayfordescription"));
            }
            // µǰ״̬
            String alarmdevicetype = map.get("faultdevicetype") == null ? "" : String.valueOf(map.get("faultdevicetype"));
            String alarmdeviceid = map.get("faultdeviceid") == null ? "" : String.valueOf(map.get("faultdeviceid"));
            String channelnum = map.get("channelnum") == null ? "" : String.valueOf(map.get("channelnum"));
            String alarmeventid = map.get("alarmeventid") == null ? "" : String.valueOf(map.get("alarmeventid"));
            updateState(alarmdevicetype, repairstate, alarmdeviceid, channelnum, alarmeventid);
            // ־Ӽ¼
//			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
            String jobid = String.valueOf(map.get("XGTJjobid"));
            insert_repairjoboplog(jobid, repairstate, processdescription, ptyh);
            Struts2Utils.renderJson(Constants.SUCCESS);

        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-edit_confirmOrder-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * Excel
     */
    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_Ywrepairjobinfo")
    public void exp_Ywrepairjobinfo() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Map queryMap = JSONObject.fromObject(map.get("downParam"));
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String yhbh = ptyh.getYhbh();
            String bmbh = ptyh.getBmbh();
            String yhzh = ptyh.getYhzh();
            Integer sfgly = ptyh.getSfgly();
            String flag = queryMap.get("flag") + "";
            if ("null".equals(flag) || StringUtils.isEmpty(flag) || "my".equals(flag)) {  //칤--ҵĹ
                //map.put("jobreportcompany", bmbh);
                queryMap.put("jobreportpeople", yhzh);
                queryMap.put("jobprocessstate", 901);
            } else if ("accept".equals(flag)) {  //칤--
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("jobacceptcompany", bmbh);
                    queryMap.put("jobacceptpeople", yhzh);
                }
                queryMap.put("jobprocessstates", " jobprocessstate in ('901','904')");
            } else if ("feedback".equals(flag)) {    //칤--
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("feedbackcompany", bmbh);
                    queryMap.put("feedbackpeople", yhzh);
                }
                queryMap.put("jobprocessstates", " jobprocessstate in ('902','913')"); // TODO jobprocessstates
            } else if ("confirm".equals(flag)) {    //칤--ȷϹ
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("confirmcompany", bmbh);
                    queryMap.put("confirmpeople", yhzh);
                }
                queryMap.put("jobprocessstate", 906);
            } else if ("delay".equals(flag)) {        //칤--ڴ
                if (sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
                    //map.put("delayforcompany", bmbh);
                    queryMap.put("delayforpeople", yhzh);
                }
                queryMap.put("jobprocessstate", 908);
            } else if ("todo".equals(flag)) { //ҳʾ
                if (sfgly == 1) { //Աѯд칤
                    //901ϱ-902ά--904906ѷȷϣ908ˣ913άȷϲͨ
                    String comprehensive = " jobprocessstate in ('901','902','904','906','908','913')";
                    queryMap.put("comprehensive", comprehensive);
                } else { //ѯǰûĴ칤
                    String comprehensive = " (extend1='" + yhzh + "') "
                            + " and jobprocessstate in ('901','902','904','906','908','913')";
                    queryMap.put("comprehensive", comprehensive);
                }
            } else {//ۺϲѯ
                String comprehensive = " ((jobreportcompany='" + bmbh + "' and jobreportpeople='" + yhzh + "') "
                        + " or (jobacceptcompany='" + bmbh + "' and jobacceptpeople='" + yhzh + "') "
                        + " or (feedbackcompany='" + bmbh + "' and feedbackpeople='" + yhzh + "') "
                        + " or (delayforcompany='" + bmbh + "' and delayforpeople='" + yhzh + "') "
                        + " or (receivercompany='" + bmbh + "' and receiverpeople='" + yhzh + "') "
                        + " or (confirmcompany='" + bmbh + "' and confirmpeople='" + yhzh + "') )";
                queryMap.put("comprehensive", comprehensive);
            }
            queryMap.put("start", 0);
            queryMap.put("limit", 5000);
            Map resMap = service.listYwrepairjobinfoByPage(queryMap);
            List<Map> sList = (List<Map>) resMap.get("rows");
            String[] zdbm = {"jobnum", "jobprocessstatename", "faultdevicetypename", "faultdevicename", "faultdeviceid", "channelnum", "faulttypename", "faultdescription", "jobreporttime"};
            String[] zdmc = {"", "״̬", "豸", "豸", "豸", "ͨ", "", "", "ϱʱ"};
            int excelNum = zdbm.length;
            ExcelCol[] cells = new ExcelCol[excelNum];
            for (int i = 0; i < excelNum; i++) {
                cells[i] = new ExcelCol();
                cells[i].setColKey(zdbm[i]);
                cells[i].setColName(zdmc[i]);
            }
            new ExportEngine().exportCommExcel("ѯ", cells, sList, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjoboplogAction-exoprtExcel-error:" + e);

        }
    }

    //ѯ豸ά
    @OperateType(value = LogConstants.LOG_QUERY, info = "listYwrepairDevicejobinfoByPage")
    public void listYwrepairDevicejobinfoByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listYwrepairDevicejobinfoByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjobinfoAction-listYwrepairDevicejobinfoByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_YwrepairDevicejobinfo")
    public void exp_YwrepairDevicejobinfo() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            map.put("start", 0);
            map.put("limit", 5000);
            Map resMap = service.listYwrepairjobinfoByPage(map);
            List<Map> sList = (List<Map>) resMap.get("rows");
            String[] zdbm = {"jobnum", "jobprocessstatename", "faultdevicetypename", "faultdevicename", "faultdeviceid", "channelnum", "faulttypename", "faultdescription", "jobreporttime"};
            String[] zdmc = {"", "״̬", "豸", "豸", "豸", "ͨ", "", "", "ϱʱ"};
            int excelNum = zdbm.length;
            ExcelCol[] cells = new ExcelCol[excelNum];
            for (int i = 0; i < excelNum; i++) {
                cells[i] = new ExcelCol();
                cells[i].setColKey(zdbm[i]);
                cells[i].setColName(zdmc[i]);
            }
            new ExportEngine().exportCommExcel("ѯ", cells, sList, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwrepairjoboplogAction-exp_YwrepairDevicejobinfo-error:" + e);

        }
    }

    //ͳ
    @OperateType(value = LogConstants.LOG_QUERY, info = "countYwrepairjobinstent")
    public void countYwrepairjobinstent() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            if (null != map.get("xzbh")) {
                String xzbh = map.get("xzbh").toString();
                map.put("xzbh", xzbh.split(","));
            }
            Struts2Utils.renderJson(this.service.countYwrepairjobinstent(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listYwrepairDevicejobinfoByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * pdf
     */
    @OperateType(value = LogConstants.LOG_EXPORT, info = "expPDF_countYwrepairjobInstent")
    public void expPDF_countYwrepairjobInstent() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Map queryMap = JSONObject.fromObject(map.get("downParam"));
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String bmbh = ptyh.getBmbh();
            if (ptyh.getSfgly() != 1) {
                queryMap.put("bmbh", bmbh);
            }
            if (null != queryMap.get("xzbh")) {
                String xzbh = queryMap.get("xzbh").toString();
                queryMap.put("xzbh", xzbh.split(","));
            }
            queryMap.put("start", 0);
            queryMap.put("limit", 5000);
            List<Map> sList = service.query_Ywrepairjobinstent(queryMap);
            //ͷ
            String[] header = {"", "", "豸", "豸", "ʱά", "δʱά", "ʱά"};
            //
            String[][] expArr = null;
            if (RHUtil.isNotEmpty(sList)) {
                expArr = new String[sList.size() + 1][header.length];
                Integer zs = 0;
                Integer zhf = 0;
                String zhfl = "0";
                int index = 0;
                for (Map smap : sList) {
                    String zcount = smap.get("cnt") == null ? "0" : String.valueOf(smap.get("cnt"));
                    String hfcount = smap.get("uncnt") == null ? "0" : String.valueOf(smap.get("uncnt"));
                    String hfl = "0";
                    if ("0".equals(hfcount)) {
                        smap.put("hfl", hfl);
                    } else {
                        hfl = division(Integer.parseInt(hfcount), Integer.parseInt(zcount));
                        smap.put("hfl", hfl);
                    }
                    expArr[index][0] = StringUtil.transEmpty(smap.get("xzmc") + "");
                    expArr[index][1] = zcount;
                    expArr[index][2] = hfcount;
                    expArr[index][3] = hfl;
                    index++;
                    zs = zs + Integer.parseInt(zcount);
                    zhf = zhf + Integer.parseInt(hfcount);
                }
                if (zhf != 0) {
                    zhfl = division(zhf, zs);
                }
                expArr[index][0] = "ܼ";
                expArr[index][1] = zs + "";
                expArr[index][2] = zhf + "";
                expArr[index][3] = zhfl;
            }
            SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
            String dateTime = formart.format(new Date());
            Map params = new HashMap();
            params.put("fileName", "άʱͳ-" + dateTime);
            params.put("sheetName", "άʱͳϢ");
            params.put("header", "άʱͳ(Ʊʱ䣺" + DateUtil.currentDateTime() + ")");
            new ExportPDF().exportCommPDF(params, header, sList, 0, expArr, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmcountAction-expPDF_Ywalarmcount-error:" + e);

        }
    }

    // excel λ¼
    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_countYwrepairjobInstent")
    public void exp_countYwrepairjobInstent() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Map queryMap = JSONObject.fromObject(map.get("downParam"));
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String bmbh = ptyh.getBmbh();
            if (ptyh.getSfgly() != 1) {
                queryMap.put("bmbh", bmbh);
            }
            if (null != queryMap.get("xzbh")) {
                String xzbh = queryMap.get("xzbh").toString();
                queryMap.put("xzbh", xzbh.split(","));
            }
            queryMap.put("start", 0);
            queryMap.put("limit", 5000);
            List<Map> sList = service.query_Ywrepairjobinstent(queryMap);
            if (null != sList && sList.size() > 0) {
                Map footMap = new HashMap();
                if (RHUtil.isNotEmpty(sList)) {
                    Integer zs = 0;
                    Integer zzcs = 0;
                    Integer zycs = 0;
                    String zwhl = "0";
                    for (Map smap : sList) {
                        String zcs = String.valueOf(smap.get("cnt")) == "null" ? "0" : String.valueOf(smap.get("cnt"));
                        String ycs = String.valueOf(smap.get("uncnt")) == "null" ? "0" : String.valueOf(smap.get("uncnt"));
                        String whl = "0";
                        Integer mcount = Integer.parseInt(zcs) + Integer.parseInt(ycs);
                        if (mcount != 0) {
                            whl = division(Integer.parseInt(zcs), mcount);
                        }
                        smap.put("whl", whl);
                        zs = zs + mcount;
                        zzcs = zzcs + Integer.parseInt(zcs);
                        zycs = zycs + Integer.parseInt(ycs);
                    }
                    // ܼ
                    if (zs != 0) {
                        zwhl = division(zzcs, zs);
                    }
                    footMap.put("0", "ܼ");
                    footMap.put("1", "ܼ");
                    footMap.put("2", "ܼ");
                    footMap.put("3", "ܼ");
                    footMap.put("4", String.valueOf(zzcs));
                    footMap.put("5", String.valueOf(zycs));
                    footMap.put("6", String.valueOf(zwhl));
                }
                String[] zdbm = {"xzbh", "xzmc", "sbbh", "tdmc", "cnt", "uncnt", "whl"};
                String[] zdmc = {"", "", "豸", "豸", "ʱά", "δʱά", "ʱά"};
                int excelNum = zdmc.length;
                ExcelCol[] cells = new ExcelCol[excelNum];
                for (int i = 0; i < excelNum; i++) {
                    cells[i] = new ExcelCol();
                    cells[i].setColKey(zdbm[i]);
                    cells[i].setColName(zdmc[i]);
                }
                SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = formart.format(new Date());
                Map params = new HashMap();
                params.put("fileName", "άʱͳ-" + dateTime);
                params.put("sheetName", "άʱͳ");
                params.put("header", "άʱͳ");
                new ExportEngine().exportCommDataWithCellRange(params, cells, sList, footMap, Struts2Utils.getResponse(), 3);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-exp_AreaOnline-error:" + e);

        }
    }

    public static String division(int num1, int num2) {
        String rate = "0.00%";
        //ʽʼλ
        String format = "0.00";
        if (num2 != 0 && num1 != 0) {
            DecimalFormat dec = new DecimalFormat(format);
            rate = dec.format((double) num1 / num2 * 100) + "%";
            while (true) {
                if (rate.equals(format + "%")) {
                    format = format + "0";
                    DecimalFormat dec1 = new DecimalFormat(format);
                    rate = dec1.format((double) num1 / num2 * 100) + "%";
                } else {
                    break;
                }
            }
        } else if (num1 != 0 && num2 == 0) {
            rate = "100%";
        }
        return rate;
    }

    /***
     *ѯ
     */
    @OperateType(value = LogConstants.LOG_EXPORT, info = "queryAgentTaskByPage")
    public void queryAgentTaskByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        String yhbh = "";
        //ѯûǷδ
        if (RHUtil.isNotEmpty(map.get("yhbh"))) {
            yhbh = String.valueOf(map.get("yhbh"));
        } else {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            if (null != ptyh) {
                yhbh = ptyh.getYhbh();
            }
        }
        //ѯûµӣоͣûв
        String comprehensive = " (extend1='" + yhbh + "') "
                + " and jobprocessstate in ('901','902','904','906','908','913')";
        map.put("comprehensive", comprehensive);
        map.put("tableparam", " and  jobreporttime <='" + DateUtil.currentDateTime() + "' and jobreporttime>='" + DateUtil.getDateTimeStr(DateUtil.day(-7)) + "'");
        try {
            Map resultmap = new HashMap();
            resultmap.put("total", service.count_Ywrepairjobinfo(map));
            resultmap.put("rows", service.query_Ywrepairjobinfo(map));
            Struts2Utils.renderJson(resultmap);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-queryAgentTaskByPage-error:" + e);
        }
    }

    /***
     * ksh_picture
     */

    @OperateType(value = LogConstants.LOG_QUERY, info = "insert_kshPicture")
    public void insert_kshPicture() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            if (RHUtil.isNotEmpty(map.get("data"))) {
                List<Map> picturelist = JSONArray.toList(JSONArray.fromObject(map.get("data")), Map.class);
                // Ӵʱ䣬ˣobjecttype
                List<Map> list = new ArrayList<Map>();
                for (Map pictureMap : picturelist) {
                    pictureMap.put("create_time", new Date());
                    pictureMap.put("id", pictureMap.get("name"));
                    pictureMap.put("name", pictureMap.get("originalname"));
                    pictureMap.put("create_user ", ptyh.getYhzh());
                    pictureMap.put("object_type", map.get("type"));
                    pictureMap.put("object_id", map.get("jobid"));
                    this.service.batch_insert_KSHPicture(pictureMap);
                    list.add(pictureMap);
                }

                //ϴĽ
                Struts2Utils.renderJson(list);
            } else Struts2Utils.renderJson("Ϊ!");
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-insert_kshPicture-error:" + e);
        }
    }

    /***
     * object_id ѯͼƬϢ
     */

    @OperateType(value = LogConstants.LOG_QUERY, info = "listYwrepairjobinfoByPage")
    public void query_kshPictureByObjectId() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_kshPictureByObjectId(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listYwrepairjobinfoByPage-error:" + e);
        }
    }


    /***
     * id ɾͼƬϢ
     */

    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_kshPictureByID")
    public void delete_kshPictureByID() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            this.service.delete_kshPictureByID(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-delete_kshPictureByID-error:" + e);
        }
    }


    //ͳƹ
    @OperateType(value = LogConstants.LOG_QUERY, info = "originStatistic")
    public void originStatistic() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.originStatistic(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-originStatistic-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ͳÿ豸
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "query_maxDevicetypeorigin")
    public void query_maxDevicetypeorigin() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_maxDevicetypeorigin(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-query_maxDevicetypeorigin-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /***
     * ѯյļ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "query_YwrepairjobinfoReceiver")
    public void query_YwrepairjobinfoReceiver() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_YwrepairjobinfoReceiver(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-query_YwrepairjobinfoReceiver-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /***
     * ѯд״̬
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listjobprocessstate")
    public void listjobprocessstate() {
        try {
            Struts2Utils.renderJson(this.service.listjobprocessstate());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listjobprocessstate-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /***
     * ͬ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "batchInsertDeviceData")
    public void batchInsertDeviceData() {
        ObjectMapper objectMapper = new ObjectMapper();
        //Զб
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        // ַת
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        // 
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
//        String  str="{'data':[{'status':0,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.226.93','IP':'44.64.226.93','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13746,'DeviceStatus':'0','SIP':'44.64.226.93','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-26 11:26:15','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'FF:2C:40:E2:5D:00','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null},{'status':0,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.231.11','IP':'44.64.231.11','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13747,'DeviceStatus':'0','SIP':'44.64.231.11','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-26 15:46:28','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'FF:2C:40:E7:0B:00','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null},{'status':0,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.233.61','IP':'44.64.233.61','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13748,'DeviceStatus':'0','SIP':'44.64.233.61','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-26 17:42:31','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'FF:2C:40:E9:3D:00','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null},{'status':0,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.178.227','IP':'44.64.178.227','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13749,'DeviceStatus':'0','SIP':'44.64.178.227','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-27 10:49:16','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'80:FA:5B:7B:B4:6C','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null},{'status':1,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.235.126','IP':'44.64.235.126','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13750,'DeviceStatus':'0','SIP':'44.64.235.126','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-27 16:42:35','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'FF:2C:40:EB:7E:00','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null},{'status':1,'DeviceRiskID':null,'devCode':null,'DevName':'44.64.235.142','IP':'44.64.235.142','Tag':null,'alldepartName':'Ϻ\\/ȷϹ','Type':1000,'TypeImgName':'icon-weizhishebei','TypeName':'ʶ','ManuFactory':null,'DeviceID':13751,'DeviceStatus':'0','SIP':'44.64.235.142','ProID':'--','ProStatus':'δƷ','DeviceRiskModule':null,'FromType':0,'ParentID':0,'ChannelID':0,'IsNvrDev':0,'PrivateNet':0,'ShowIP':'','ProDev':0,'Attribute':'--','SwitchIp':null,'SwitchPort':null,'UserName':null,'RunTime':null,'Remark':'Զ豸!','InsertTime':'2022-05-27 16:42:35','departName':'ȷϹ','ClassID':'豸','DeviceModel':null,'Mac':'FF:2C:40:EB:8E:00','Version':null,'BuildDate':null,'Registered':-2,'UnLinkStatus':0,'Longitude':null,'Latitude':null,'GBID':'','DB33':'','PostCode':null,'MonPoType':'','IPv6':'','InstallAddress':'','InstallTime':'','OSD':null,'User':null,'Pwd':null,'MonitoringType':null,'VideoType':null,'FunType':null,'FillAttr':null,'VideoCode':null,'PositionType':null,'MonitoringPosition':null,'Networking':null,'Organ':null,'ManagementUnit':null,'ManagementTel':null,'SaveDays':null,'Industry':null,'AscID':'local','SerLength':5,'DevImg':'','Tel':null,'CPUNumber':null,'GPUNumber':null,'DiskSize':'0Bytes','Memory':'0Bytes','Pixel':null,'LeverCode':0,'Expand_1':null,'Expand_2':null,'Expand_3':null,'Expand_4':null,'Expand_5':null}],'count':2,'code':0,'msg':''}";
        String str = HttpUtil.doget(urlStr + "&page=1");
        Map map = new HashedMap();
        if (str != null) {
            try {
                map = objectMapper.readValue(str, Map.class);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            if (null == map.get("count") || null == map.get("data")) {
                Struts2Utils.renderJson(Constants.FAIL);
                return;
            }
            int count = (int) map.get("count");
            //òҸ
            List<Map> mapdata = (List<Map>) map.get("data");
            try {
                if (mapdata.size() > 0) {
                    service.delete_deviceData();
                    service.batch_insert_deviceData(mapdata);
                }
            } catch (Exception e) {
                iLog.error(e.toString());
                e.printStackTrace();
            }
//        Runnable run = new Runnable() {
//            @Override
//            public void run() {
            try {
              int page = count % 500 == 0 ? count / 500 : (count / 500) + 1;
                if (null != Struts2Utils.getSession()) {
                    Struts2Utils.getSession().setAttribute("percent", "1" + "/" + page);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
                for (int i = 2; i <= page; i++) {
                    if (null != Struts2Utils.getSession()) {
                        Struts2Utils.getSession().setAttribute("percent", i + "/" + page);
                    }
                    //ʣµļҳ
                    try {
                        str = HttpUtil.doget(urlStr + "&page=" + i);
                        if (null == str) continue;
                        try {
                            map = objectMapper.readValue(str, Map.class);
                        } catch (Exception e) {
                            iLog.error(e.toString());
                            e.printStackTrace();
                            continue;
                        }
                        if (null == map.get("data")) continue;
//                                    map = JSON.parseObject(str, Map.class);
                        mapdata = (List<Map>) map.get("data");
                        if (mapdata.size() > 0) {
                            service.batch_insert_deviceData(mapdata);
                        }
                    } catch (Exception e) {
                        iLog.error(e.toString());
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                iLog.error(e.toString());
                e.printStackTrace();
                Struts2Utils.renderJson(Constants.FAIL);
            }
        }
        if (null != Struts2Utils.getSession())
            Struts2Utils.getSession().setAttribute("percent", "100");
//        };
//    Thread  t=new Thread(run);
//    t.start();
    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "batchInsertDeviceDatapercent")
    public void batchInsertDeviceDatapercent() {
        if (Struts2Utils.getSession() != null && null != Struts2Utils.getSession().getAttribute("percent")) {
            Struts2Utils.renderJson(Struts2Utils.getSession().getAttribute("percent"));
        } else {
            Struts2Utils.renderJson("0");
        }

    }

    /***
     * ͬ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "batchInsertDept")
    public void batchInsertDept() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        String str = HttpUtil.doget(urlStrdept + "&page=1");
//        String str="{'data':[{'DepartID':610,'UpID':605,'DepartName':'ƽ-K05-ƽ˳·ƾ·Լ100·','OrderIndex':605,'IPSegment':''},{'DepartID':611,'UpID':605,'DepartName':'ƽ-K06-·Լ400·','OrderIndex':605,'IPSegment':''}],'count':2366,'code':0,'msg':''}";
        Map map = new HashedMap();

        if (str != null) {
            try {
                map = objectMapper.readValue(str, Map.class);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            if (null == map.get("count") || null == map.get("data")) {
                Struts2Utils.renderJson(Constants.FAIL);
                return;
            }
            int count = (int) map.get("count");
            //òҸ
            List<Map> mapdata = (List<Map>) map.get("data");
            try {
                if (mapdata.size() > 0) {
                    service.delete_deptData();//ȫ
                    //жǷȫձ
                    Map  jxmap=new HashMap();
                    jxmap.put("DepartID",9999);
                    jxmap.put("UpID",0);
                    jxmap.put("DepartName","");
                    jxmap.put("OrderIndex",9999);
                    jxmap.put("IPSegment",null);
                    mapdata.add(jxmap);
                    service.batch_insert_deptData(mapdata);
                }
            } catch (Exception e) {
                iLog.error(e.toString());
                e.printStackTrace();
            }
            try {
                int page = count % 500 == 0 ? count / 500 : (count / 500) + 1;
                if (null != Struts2Utils.getSession()) {
                    Struts2Utils.getSession().setAttribute("deptpercent", "1" + "/" + page);
                }
                Struts2Utils.renderJson(Constants.SUCCESS);
                for (int i = 2; i <= page; i++) {
                    if (null != Struts2Utils.getSession()) {
                        Struts2Utils.getSession().setAttribute("deptpercent", i + "/" + page);
                    }
                    //ʣµļҳ
                    try {
                        str = HttpUtil.doget(urlStrdept + "&page=" + i);
                        if (null == str) continue;
                        try {
                            map = objectMapper.readValue(str, Map.class);
                        } catch (Exception e) {
                            iLog.error(e.toString());
                            e.printStackTrace();
                            continue;
                        }
                        if (null == map.get("data")) continue;
                        mapdata = (List<Map>) map.get("data");
                        if (mapdata.size() > 0) {
                            service.batch_insert_deptData(mapdata);
                        }
                    } catch (Exception e) {
                        iLog.error(e.toString());
                        e.printStackTrace();
                    }

                }
            } catch (Exception e) {
                iLog.error(e.toString());
                e.printStackTrace();
                Struts2Utils.renderJson(Constants.FAIL);
            }

        }
        if (null != Struts2Utils.getSession())
            Struts2Utils.getSession().setAttribute("deptpercent", "100");
    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "batchInsertDeptDatapercent")
    public void batchInsertDeptDatapercent() {
        if (Struts2Utils.getSession() != null && null != Struts2Utils.getSession().getAttribute("deptpercent")) {
            Struts2Utils.renderJson(Struts2Utils.getSession().getAttribute("deptpercent"));
        } else {
            Struts2Utils.renderJson("0");

        }

    }

    @OperateType(value = LogConstants.LOG_QUERY, info = "listNetworkdeviceyPage")
    public void listNetworkdeviceyPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listNetworkdeviceyPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listNetworkdeviceyPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }
    @OperateType(value = LogConstants.LOG_QUERY, info = "listNetworkdeviceType")
    public void listNetworkdeviceType() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.listNetworkdeviceType());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("ywrepairjobinfoAction-listNetworkdeviceType-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }
}
