package cn.yw.nhyw.nhywjtxcrzgl.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.ImportExcelUtil;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component("uploadFileAction")
public class UploadFileAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger iLog = Logger.getLogger(UploadFileAction.class);

    @OperateType(value = LogConstants.LOG_IMPORT, info = "uploadFile")
    public void uploadFile() {
        try {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
            String result = "0";
            List<Map> list = new ArrayList<>();
            List<List<Object>> listob = null;
            wrapper.getParameter("filename");
            File[] files = wrapper.getFiles("file");
            if (null == files || files.length==0) {
                iLog.error("NhywjjzcxxAction-imp_Nhywjjzcxx-error:ļ");
            }
            String directory = "/upload";
            String targetDirectory = ServletActionContext.getServletContext().getRealPath(directory);
            for(File file:files)
            {
                //ϴļ
                File target = new File(targetDirectory, wrapper.getParameter("filename"));
                //ļѾڣɾԭļ
                if (target.exists()) {
                    target.delete();
                }
                FileUtils.copyFile(file, target);           //fileʵϴ
                FileInputStream in = new FileInputStream(target);
                listob = new ImportExcelUtil().getBankListByExcel(in, target.getName());
                in.close();
            }
            Struts2Utils.renderJson("ʧ");
        } catch (Exception e) {
            iLog.error("NhywjjzcxxAction-imp_Nhywjjzcxx-error:" + e);
            Struts2Utils.renderJson("ʧ");
        }

    }

    @OperateType(value = LogConstants.LOG_IMPORT, info = "uploadFile")
    public void insert_kshPicture() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Map queryMap = JSONObject.fromObject(map.get("fileParam"));

        } catch (Exception e) {
            iLog.error("NhywjjzcxxAction-imp_Nhywjjzcxx-error:" + e);
            Struts2Utils.renderJson("ʧ");
        }

    }
}
