package cn.yw.nhyw.nhywjjzcxx.action;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.*;
import cn.yw.nhyw.nhywjjzcxx.service.NhywjjzcxxService;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.*;


@Component("nhywjjzcxxAction")
public class NhywjjzcxxAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger iLog = Logger.getLogger(NhywjjzcxxAction.class);

    @Autowired
    private NhywjjzcxxService service;

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listNhywjjzcxxByPage")
    public void listNhywjjzcxxByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listNhywjjzcxxByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-listNhywjjzcxxByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "count_Nhywjjzcxx")
    public void count_Nhywjjzcxx() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Nhyjjzcxx(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-count_Nhyjjzcxx-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ Nhyjjzcxx
     */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywjjzcxx")
	public void query_Nhywjjzcxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhyjjzcxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjjzcxxAction-query_Nhyjjzcxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

    /**
     * ѯ һNhyjjzcxx
     */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywjjzcxx")
	public void get_Nhywjjzcxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhyjjzcxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjjzcxxActionquery_Nhyjjzcxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "delete_Nhywjjzcxx")
    public void delete_Nhywjjzcxx() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Nhywjjzcxx(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-delete_Nhyjjzcxx-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Nhywjjzcxx")
    public void insert_Nhywjjzcxx() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("xh"))) {
                map.put("xh", StringUtil.getUUID());
            }
            service.insert_Nhywjjzcxx(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-insert_Nhyjjzcxx()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Nhywjjzcxx")
    public void update_Nhywjjzcxx() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int result = service.update_Nhywjjzcxx(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-update_Nhywjjzcxx-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywjjzcxx")
	public void batch_delete_Nhywjjzcxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhyjjzcxx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjjzcxxAction-batch_delete_Nhyjjzcxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

    /**
     * Excel
     */

    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_Nhywjjzcxx")
    public void exp_Nhywjjzcxx() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            map.put("start", 0);
            map.put("limit", 5000);
            List<Map> sList = service.query_Nhywjjzcxx(map);

            String[] zdbm = {"zcbm","zcmc","zclb","zcxh","zcdw","bdfs","syqk","syrq","cfdd","zcsl","yzyb","syip","state","bz"};
            String[] zdmc = {"ʲ","ʲ","ʲ","ʲͺ","λ","䶯ʽ","ʹ","ʹ","ŵص","","ԭֵԭңԪ","ʹip","豸״̬","ע"};
            int excelNum = zdbm.length;
            ExcelCol[] cells = new ExcelCol[excelNum];
            for (int i = 0; i < excelNum; i++) {
                cells[i] = new ExcelCol();
                cells[i].setColKey(zdbm[i]);
                cells[i].setColName(zdmc[i]);
            }
            SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
            String dateTime = formart.format(new Date());
            Map params = new HashMap();
            params.put("fileName", "ʲϢ-" + dateTime);
            params.put("sheetName", "ʲϢ");
            params.put("header", "ʲϢ");
            new ExportEngine().exportCommData(params, cells,  sList, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("NhywjjzcxxAction-exp_Nhywjjzcxx-error:" + e);

        }
    }

    /**
     * Excel
     */
    @OperateType(value = LogConstants.LOG_IMPORT, info = "imp_Nhywjjzcxx")
    public void imp_Nhywjjzcxx() {
        try {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
            String result = "0";
            List<Map> list = new ArrayList<>();
            List<List<Object>> listob = null;
            wrapper.getParameter("filename");
            File file = wrapper.getFiles("file")[0];
            if (null == file) {
                iLog.error("NhywjjzcxxAction-imp_Nhywjjzcxx-error:ļ");
            }
            String directory = "/upload";
            String targetDirectory = ServletActionContext.getServletContext().getRealPath(directory);
            //ϴļ
            File target = new File(targetDirectory, wrapper.getParameter("filename"));
            //ļѾڣɾԭļ
            if (target.exists()) {
                target.delete();
            }
            FileUtils.copyFile(file, target);           //fileʵϴ
            FileInputStream in = new FileInputStream(target);
            listob = new ImportExcelUtil().getBankListByExcel(in, target.getName());
            in.close();
            //ôɵserviceӦݱ浽ݿУֻ
            //String lolumn = "ʲ,ʲ,ʲ,ʲͺ,λ,䶯ʽ,ʹ,ʹ,ŵص,,ԭֵԭ,ʹip,ע";

            if (listob.size() > 0) {
                List<Object> columns = listob.get(0);
                if (columns.size() >= 14) { //жģǷȷ
                    for (int i = 0; i < listob.size(); i++) {
                        Map vo = new HashMap();
                        vo.put("xh", StringUtil.getUUID());
                        vo.put("zcbm", String.valueOf(listob.get(i).get(0)));
                        vo.put("zcmc", String.valueOf(listob.get(i).get(1)));
                        vo.put("zclb", String.valueOf(listob.get(i).get(2)));
                        vo.put("zcxh", String.valueOf(listob.get(i).get(3)));
                        vo.put("zcdw", String.valueOf(listob.get(i).get(4)));
                        vo.put("bdfs", String.valueOf(listob.get(i).get(5)));
                        vo.put("syqk", String.valueOf(listob.get(i).get(6)));
                        vo.put("syrq", String.valueOf(listob.get(i).get(7)));
                        vo.put("cfdd", String.valueOf(listob.get(i).get(8)));
                        vo.put("zcsl", String.valueOf(listob.get(i).get(9)));
                        vo.put("yzyb", String.valueOf(listob.get(i).get(10)));
                        vo.put("syip", String.valueOf(listob.get(i).get(11)));
                        if(null!=listob.get(i).get(12)) {
                            if(listob.get(i).get(12).equals(""))
                              vo.put("zcstate", "1");
                            else if(listob.get(i).get(12).equals("ͣ"))
                                vo.put("zcstate", "2");
                            else if(listob.get(i).get(12).equals(""))
                                vo.put("zcstate", "3");
                        }
                        vo.put("bz", String.valueOf(listob.get(i).get(13)));
                        list.add(vo);
                    }
                    result = this.service.batch_insert_Nhywjjzcxxinfo(list);
                }
                if(result.equals("1")) {
                    Struts2Utils.renderJson("ɹ"+list.size()+"");
                }
                else {
                    Struts2Utils.renderJson("ʧ");
                }
            }else {
                Struts2Utils.renderJson("ģ");
            }

        } catch (Exception e) {
            iLog.error("NhywjjzcxxAction-imp_Nhywjjzcxx-error:" + e);
            Struts2Utils.renderJson("ʧ");
        }

    }
}
