package cn.yw.alarmtaskmanage.service;


import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.alarmtaskmanage.dao.YwalarmruleinfoDao;

@Service("ywalarmruleinfoService")
public class YwalarmruleinfoService extends BaseService {
	
	private static final Log log = LogFactory.getLog(YwalarmruleinfoService.class);
	
	@Autowired
	private YwalarmruleinfoDao ywalarmruleinfoDao;
	
	/**
	 * ¼
	 */
	
	public void insert_Ywalarmruleinfo(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywalarmruleinfoDao.insert_Ywalarmruleinfo(map);
	}
	

	
	/**
	 * ޸ļ¼
	 */
	
	public Integer update_Ywalarmruleinfo(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywalarmruleinfoDao.update_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer delete_Ywalarmruleinfo(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywalarmruleinfoDao.delete_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer batch_delete_Ywalarmruleinfo(Map map) throws SQLException{
		return ywalarmruleinfoDao.batch_delete_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Ywalarmruleinfo(Map map) throws SQLException{
		return ywalarmruleinfoDao.count_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * ѯб¼SELECT
	 */
	
	public List<Map> query_Ywalarmruleinfo(Map map) throws SQLException{
		return ywalarmruleinfoDao.query_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * ѯһ
	 */
	 
	
	public Map get_Ywalarmruleinfo(Map map) throws SQLException{
		return ywalarmruleinfoDao.get_Ywalarmruleinfo(map);
	}
	
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwalarmruleinfo(Map map) throws SQLException{
		return this.listYwalarmruleinfoByPage(map);
	}
	*/
	
	/**
	 * Ywalarmruleinfo ҳ
	 */
	
	public Map listYwalarmruleinfoByPage(Map map) throws SQLException {
		List<Map> list = ywalarmruleinfoDao.query_Ywalarmruleinfo(map);
		Integer totalCount = ywalarmruleinfoDao.count_Ywalarmruleinfo(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	// ѯ 澯 Ƴ
	public List<Map>  getAlarmTypeMc(Map map) throws SQLException{
		return ywalarmruleinfoDao.getAlarmTypeMc(map);
	}
	
	// 
	public Integer edit_Ywalarmruleinfo(Map map) throws SQLException{
		return ywalarmruleinfoDao.edit_Ywalarmruleinfo(map);
	}
}
