package cn.im.trafficplan.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;
import com.ibatis.sqlmap.client.SqlMapClient;

import cn.amq.peas.TrafficEventExecStateActionHolder;
import cn.base.util.DateUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.im.trafficplan.model.TrafficplanexeclogBean;

@Repository("trafficplanexeclogDao")
public class TrafficplanexeclogDao  extends SqlMapClientDaoSupport{

	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public  void initSqlMapClient(){  
    	super.setSqlMapClient(sqlMapClient);      
    }
	
	
	/**
	 * Ӽ¼
	 */
	public void insert_Trafficplanexeclog(Map map) throws SQLException{
		this.getSqlMapClientTemplate().insert("insert_Trafficplanexeclog",map);
	}

	/**
	 * ѯ
	 */
	public Integer count_Trafficplanexeclog(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_Trafficplanexeclog",map);
	}
	
	/**
	 * ѯб¼
	 */
	public List<Map> query_Trafficplanexeclog(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_Trafficplanexeclog",map);
	}
	public List<Map> listTrafficplanexeclogByAPID(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("listTrafficplanexeclogByAPID",map);
	}
	public Integer updateExecLog(TrafficEventExecStateActionHolder bean,String logType){
		String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
		String now = DateUtil.currentDateTime();
		Map<String ,String> map = new HashMap<String,String>();
		map.put("accidentId", bean.getEventId());
		map.put("deviceId", bean.getDeviceId());
		map.put("logType", logType);
		map.put("modifyAccount", userName);
		map.put("modifyTime", now);
		map.put("deviceType", bean.getDeviceType());
		String state = bean.getExecState();
		if("1".equals(state)){ //1δִУ2ִУ3ִгɹ4ִʧ
			map.put("operateState", "δִ");
		}else if("2".equals(state)){
			map.put("operateState", "ִ");
		}else if("3".equals(state)){
			map.put("operateState", "ִгɹ");
		}else if("4".equals(state)){
			map.put("operateState", "ִʧ");
		}
		return this.getSqlMapClientTemplate().update("updateExecLog", map);
	}
	public Integer updateExecLog(Map map){
		String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
		String now = DateUtil.currentDateTime();
		map.put("modifyAccount", userName);
		map.put("modifyTime", now);
		return this.getSqlMapClientTemplate().update("updateExecLog", map);
	}
	
	// ѯ¼¼
	public Map query_Ptlyjlb(Map map) {
		return (Map) this.getSqlMapClientTemplate().queryForObject("query_Ptlyjlb", map);
	}
}
