package cn.im.trafficalarm.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;
import com.ibatis.sqlmap.client.SqlMapClient;

import cn.im.trafficalarm.model.TrafficaccidentinfoBean;


@Repository("trafficaccidentinfoDao")
public class TrafficaccidentinfoDao  extends SqlMapClientDaoSupport{

	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public  void initSqlMapClient(){  
    	super.setSqlMapClient(sqlMapClient);      
    }
	
	
	/**
	 * Ӽ¼
	 */
	public void insert_Trafficaccidentinfo(Map map) throws SQLException{
		this.getSqlMapClientTemplate().insert("insert_Trafficaccidentinfo_map",map);
	}
	
	
	public void jkdClick(TrafficaccidentinfoBean tb) throws SQLException{
		this.getSqlMapClientTemplate().insert("insert_Trafficaccidentinfo",tb);
	}
	/**
	 * Ӽ¼
	 */
	public Map insert_Trafficaccidentinfo(TrafficaccidentinfoBean obj) throws SQLException{
		Map map = new HashMap();
		try{	
			this.getSqlMapClientTemplate().insert("insert_Trafficaccidentinfo",obj);
			map.put("msg", "ɹ");
			map.put("success", new Boolean(true));	
		}catch(Exception e){
			
		}
		return map;
	}
	
	
	
	
	/**
	 * Ӽ¼
	 */
	/*
	public void batch_insert_Trafficaccidentinfo(List batch) throws SQLException{
		this.getSqlMapClientTemplate().insert("batch_insert_Trafficaccidentinfo",batch);
	}
	*/
	 
	/**
	 * ޸ļ¼
	 */
	public Integer update_Trafficaccidentinfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("update_Trafficaccidentinfo",map);
	}
	public Integer updateTrafficaccidentinfo_planEnd(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("updateTrafficaccidentinfo_planEnd",map);
	}
	
	/**
	 * ޸ҳpushletݵ״̬
	 * @param accidentId  ¼
	 * @param accidentState ¼״̬Ϊ0-չʾδ鿴
	 */
	public Integer batch_update_TrafficHomePageinfo(String accidentId,String accidentState) throws SQLException{
		//return this.getSqlMapClientTemplate().update("update_Trafficaccidentinfo",map);
		try { 
			this.getSqlMapClient().startTransaction(); 
			this.getSqlMapClient().startBatch();
			String[] p = accidentId.split("\\,");
			if(p.length>0){
				for (int i = 0; i < p.length; i++) {
					if(p[i].length()>0){
						Map m = new HashMap();
						m.put("XGTJaccidentId", p[i]);
						m.put("accidentState", accidentState);
						this.getSqlMapClient().update("update_Trafficaccidentinfo",m);
					}
				}
			}
			this.getSqlMapClient().executeBatch(); 
			this.getSqlMapClient().commitTransaction(); 
			return 1;
			}catch (Exception e) { 
				e.printStackTrace(); 
				return 0;
			} finally { 
					this.getSqlMapClient().endTransaction(); 
			}
	}
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer delete_Trafficaccidentinfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("delete_Trafficaccidentinfo",map);
	}
	*/
	
	/**
	 * ɾ¼
	 */
	
	
	public Integer batch_delete_Trafficaccidentinfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("batch_delete_Trafficaccidentinfo",map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Trafficaccidentinfo(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_Trafficaccidentinfo",map);
	}
	
	
	/**
	 * ѯб¼
	 */
	public List<Map> query_Trafficaccidentinfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_Trafficaccidentinfo",map);
	}
	/**
	 * ҳ
	 */
	public List<Map> query_TrafficHomePagetinfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_TrafficHomePagetinfo",map);
	}
	/**
	 * ҳ
	 */
	public Integer count_TrafficHomePagetinfo(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_TrafficHomePagetinfo",map);
	}
	
	/**
	 * ҳ̨дкδ
	 */
	public List<Map> query_TrafficHomePageCount(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_TrafficHomePagetCount",map);
	}
	
	/**
	 * ѯͨ¼Ϣʾҳ̨
	 */
	public List<Map> query_TrafficaccidentPushlet(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_TrafficaccidentPushlet",map);
	}
	
	/**
	 * ѯб¼
	 */
	/*
	public Map get_Trafficaccidentinfo(Map map) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("query_Trafficaccidentinfo",map);
	}
	*/
	
	
	/**
	 * @param map
	 * @return ѯ豸Ϣ id +    
	 * @throws SQLException
	 */
	public List<Map> get_Cameras(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_Cameras",map);
	}
	
	// ѯԤ
	public Map get_bjya(Map map) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("get_bjya", map);	
	}
	
	/**
	 * ͷϢ
	 */
	public List<Map> query_listBigscreenInitCamere(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_listBigscreenInitCamere",map);
	}
	
	/**
	 * Ϣ
	 */
	public List<Map> query_listBigscreenInitTunnel(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_listBigscreenInitTunnel",map);
	}
	
	/**
	 * 鱨Ϣ
	 */
	public List<Map> query_listBigscreenInitLedBoard(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_listBigscreenInitLedBoard",map);
	}
	
	/**
	 * յϢ
	 */
	public List<Map> query_listBigscreenInitTrafficLight(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_listBigscreenInitTrafficLight",map);
	}
	
	/**
	 * ؽͨ¼ϢϢ
	 */
	public List<Map> query_listBigscreenInitAlarm(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_listBigscreenInitAlarm",map);
	}
	
	
	// ѯԤ
	public Map get_Trafficaccidentinfo(Map map) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("query_Trafficaccidentinfo", map);	
	}
	
	
}
