package cn.im.trafficalarm.action;

 import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.amq.peas.TrafficEventAlarmPeas;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.conf.ModuleConfFactory;
import cn.base.conf.TraffAccident;
import cn.base.tinyftp.TinyFtpCfgInfo;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.FTPUrl;
import cn.base.util.FTPUtil;
import cn.base.util.ImageHepler;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.im.trafficalarm.model.TrafficaccidentinfoBean;
import cn.im.trafficalarm.service.TrafficaccidentinfoService;
import cn.im.trafficalarm.service.TrafficaccidentstateService;
import cn.im.trafficplan.service.TrafficplanmanageService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("trafficaccidentinfoAction")
public class TrafficaccidentinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficaccidentinfoAction.class);
	
	@Autowired
	private TrafficaccidentinfoService service;	
	@Autowired
	private TrafficplanmanageService trafficplanmanageService;	
	@Autowired
	private TrafficaccidentstateService trafficaccidentstateService;
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getConfigPlanVideoInfo")
	public void getConfigPlanVideoInfo(){
		try {
			String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			String now = DateUtil.currentDateTime();
			String path = TrafficaccidentinfoService.class.getClassLoader().getResource("temp.json").toString().replace("file:/","");
			System.out.println(path);
			String input = FileUtils.readFileToString(new File(path), "GBK");
//			JSONObject jsonObject = (JSONObject)(JSONObject.fromObject(input)).get("planVideo");
			JSONArray jsonArray = (JSONObject.fromObject(input)).getJSONObject("planVideo").getJSONArray("list");
			Struts2Utils.renderJson(jsonArray);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-getConfigPlanVideoInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	//̬ȡtemp.jsonļĲϢ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getConfigTempInfo")
	public void getConfigTempInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String tabName = Struts2Utils.getParameter("tabNAme");
			String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			String now = DateUtil.currentDateTime();
			String path = TrafficaccidentinfoService.class.getClassLoader().getResource("temp.json").toString().replace("file:/","");
			System.out.println(path);
			String input = FileUtils.readFileToString(new File(path), "GBK");
			//JSONObject jsonObject = (JSONObject)(JSONObject.fromObject(input)).get(tabName);
			//JSONArray jsonArray = (JSONObject.fromObject(input)).getJSONObject(tabName).getJSONArray("list");
			JSONObject jsonObject = (JSONObject.fromObject(input)).getJSONObject(tabName);
			Struts2Utils.renderJson(jsonObject);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-getConfigTempInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ص
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="jkdClick")
	public void jkdClick(){
		try {
			String userName = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			String now = DateUtil.currentDateTime();
			String path = TrafficaccidentinfoService.class.getClassLoader().getResource("temp.json").toString().replace("file:/","");
			System.out.println(path);
			String input = FileUtils.readFileToString(new File(path), "GBK");
			JSONObject jsonObject = (JSONObject)(JSONObject.fromObject(input)).get("trafficaccidentinfo");
//		    System.out.println(((JSONObject)(JSONObject.fromObject(input).get("trafficaccidentinfo"))).get("eventUrl"));
//			Map<String,Object> map = new HashMap<String,Object>();
			TrafficaccidentinfoBean tb = new TrafficaccidentinfoBean();
			//jsonļȡ
			tb.setAccidentId(StringUtil.getUUID());
			tb.setAccidentState("1");
			tb.setDeviceId(String.valueOf(jsonObject.get("deviceId")));
			tb.setDeviceType("0");
			tb.setEventId("330100180419101533");
			tb.setEventSource("2");
			tb.setEventType(String.valueOf(jsonObject.get("eventType")));
			tb.setOccurTime(now);
			tb.setAlarmTime(now);
			tb.setAlarmLevel("1");
			tb.setEventBigUrl(String.valueOf(jsonObject.get("eventUrl")));
			tb.setEventSmallUrl(String.valueOf(jsonObject.get("eventUrl")));
			tb.setEventUrl(String.valueOf(jsonObject.get("eventUrl")));
			tb.setVdId(String.valueOf(jsonObject.get("vdId")));
			tb.setChannelId(String.valueOf(jsonObject.get("channelId")));
			tb.setPlanID("1");
			tb.setCreateAccount(userName);
			tb.setModifyAccount("alarmDemo");
			tb.setCreateTime(now);
			tb.setModifyTime(now);
			this.service.jkdClick(tb);
			//͸澯¼AMQ
			BeanHelper.getAmqTrafficEventAlarmService().publishTrafficEventAlarmAction(tb.getAccidentId(), 
					tb.getOccurTime(), tb.getVdId(), "", tb.getChannelId(), tb.getEventType(), 
					tb.getAlarmLevel(), "", "", "", tb.getEventBigUrl(),tb.getDeviceId());
			//Ƶ¼AMQ
			BeanHelper.getAmqVdLinkageRecordService().publishVdLinkageRecordAction(tb.getAccidentId(),tb.getOccurTime(),
					tb.getVdId(), tb.getChannelId(), tb.getEventType());
			Struts2Utils.renderJson("success");
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-jkdClick-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficaccidentinfoByPage")
	public void listTrafficaccidentinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			String accidentState = Struts2Utils.getParameter("accidentState");
			if (RHUtil.isNotEmpty(accidentState)) {  //¹״̬ 
				String[] state = null;
				if("199".equals(accidentState)) {  //199Ϊȫ
					state = new String[]{"0","2","3","4"};
					map.put("accidentState",state );
					//map.put("accidentStateNotIn",'1' );
				}else if ("0".equals(accidentState)){ //0-չʾδִУδ
					state = new String[]{"0"};
					map.put("accidentState",state );
				}else if("2".equals(accidentState)) {  //2-УС
					state = new String[]{"2"};
					map.put("accidentState",state );
				}else if("3".equals(accidentState)) {  //3-Ѻ,4-     Ѵ
					state = new String[]{"3","4"};
					map.put("accidentState",state);
				}
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficaccidentinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-listTrafficaccidentinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
//  ͨ¼ҳѯʽ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getlistTrafficaccidentinfoByPage")
	public void getlistTrafficaccidentinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
						
			//Դжϣǰв䣬ǰ˲Ϊ
			String eventSource = String.valueOf( map.get("eventSource"));
			if (RHUtil.isNotEmpty(eventSource)) {  
				if("1".equals(eventSource)) {						// 			xml   createAccount   != 				
					map.put("createAccount", "webservice");
				}else if("2".equals(eventSource)) {						// 㷨
					map.put("createAccount", "sqlserver");
				}else {
					map.put("createAccount", "");
				}
			}else {//ǰݴ䣬siyouΪ
				if("3".equals(ModuleConfFactory.getModuleConfService().getTraffAccident().getAlarmSearchChoose())){
					map.put("createAccount", "webservice");
				}else if("2".equals(ModuleConfFactory.getModuleConfService().getTraffAccident().getAlarmSearchChoose())){
					map.put("createAccount", "sqlserver");
				}else{
					map.put("createAccount", "");
				}
			}
			//״̬ 
			String accidentState = String.valueOf( map.get("accidentState"));
			if (RHUtil.isNotEmpty(accidentState)) {  
				String[] state = null;
				if("99".equals(accidentState)) {  //199Ϊȫ
					state = new String[]{"0","1","2","3","4","5"};
					map.put("accidentState",state );
				}else if ("0".equals(accidentState)){ //01δ
					state = new String[]{"0","1","5"};
					map.put("accidentState",state );
				}else if("1".equals(accidentState)){ //01δ{
					state = new String[]{"0","1","5"};
					map.put("accidentState",state );
				}else if("2".equals(accidentState)) {  //2-УС
					state = new String[]{"2"};
					map.put("accidentState",state );
				}else if("3".equals(accidentState)) {  //3-Ѻ,
					state = new String[]{"3"};
					map.put("accidentState",state);
				}else if("4".equals(accidentState)) {  // 4   Ѵ
					state = new String[]{"4","6","7"};
					map.put("accidentState",state);
				}else if("5".equals(accidentState)) {  // 5   Ѳ鿴
					state = new String[]{"5"};
					map.put("accidentState",state);
				}
			}
			
			// ʱѯ
			String time_start = String.valueOf(map.get("time_start"));
			String time_end = String.valueOf( map.get("time_end"));
			if(StringUtils.isNotEmpty(time_start)){
				time_start  = time_start+" 00:00:00";
			}else{
				time_start = "";
			}
			map.put("time_start", time_start);
			if(StringUtils.isNotEmpty(time_end)){
				time_end  = time_end +" 23:59:59";
			}else{
				time_end = "";
			}
			map.put("time_end", time_end);
			
			//ȼ
			
			String accidentTime = String.valueOf( map.get("accidentTime"));
			if("1".equals(accidentTime)) {					        // 1
				String currDate = DateUtil.getYMD();
				Date currDay_date = DateUtil.day(-7);
				String currDay = DateUtil.date(currDay_date);
				currDay = currDay +" 00:00:00";
				currDate = currDate + " 23:59:59";
				map.put("time_start",currDay);
				map.put("time_end",currDate);
			}else if("2".equals(accidentTime)) {                    // 1
				String currDate = DateUtil.getYMD();
				Date currMonth_date = DateUtil.month(-1);
				String currMonth = DateUtil.date(currMonth_date);
				currMonth = currMonth + " 00:00:00";
				currDate = currDate + " 23:59:59";
				map.put("time_start",currMonth);
				map.put("time_end",currDate);
			}else if("3".equals(accidentTime)) {                    // 3
				String currDate = DateUtil.getYMD();
				Date currMonth_date = DateUtil.month(-3);
				String currMonth = DateUtil.date(currMonth_date);
				currMonth = currMonth + " 00:00:00";
				currDate = currDate + " 23:59:59";
				map.put("time_start",currMonth);
				map.put("time_end",currDate);
			}
				
			// ¼                           eventType ,ɲ
			String accType = String.valueOf( map.get("eventType"));
			if("199".equals(accType)) {						// ȫ				
				String[] accidentType = new String[]{"1","5","6","30","31","32","33","34","35","36","37","38","39","99"};
				map.put("accidentType", accidentType);
				map.remove("eventType");
			}
			
			// ѡ
			String vId = String.valueOf( map.get("vId"));
			if("199".equals(vId)) {							// ȫ  
				
			}else {
				String videoIds = String.valueOf( map.get("videoIds"));
				String[] tdbh = videoIds.split(",");
				map.put("tdbh", tdbh);
			}
			
	
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",page );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficaccidentinfoByPage(map));
			
		}catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-getlistTrafficaccidentinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	
	/**
	 * ѯ
	 */
	/*
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Trafficaccidentinfo")
	public void count_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Trafficaccidentinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-count_Trafficaccidentinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ҳ̨ܣѯʱ䡢¼״̬ҳϢ
	 * ѯ Trafficaccidentinfo
	 * @param ¼  occurTime
	 * @param ¹״̬  accidentState;0-չʾδִ,1-δչʾδִУ2-У3-Ѻԣ4-᡿      5-Ѳ鿴
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_TrafficHomePageinfo")
	public void query_TrafficHomePageinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			//ʱ
			String occurTime = Struts2Utils.getParameter("occurTime");
			if (RHUtil.isNotEmpty(occurTime)) {  //ʱ
				if("1".equals(occurTime)) { //1-
					String currDate = DateUtil.getYMD();
					currDate = currDate + " 00:00:00";
					map.put("occurTimeStart",currDate);
				}else if("2".equals(occurTime)) {  //2-һ
					String currDate = DateUtil.getYMD();
					Date currDay_date = DateUtil.day(-7);
					String currDay = DateUtil.date(currDay_date);
					currDay = currDay +" 00:00:00";
					currDate = currDate + " 23:59:59";
					map.put("occurTimeStart",currDay);
					map.put("occurTimeEnd",currDate);
				}else if("3".equals(occurTime)) {  //3-һ
					String currDate = DateUtil.getYMD();
					Date currMonth_date = DateUtil.month(-1);
					String currMonth = DateUtil.date(currMonth_date);
					currMonth = currMonth + " 00:00:00";
					currDate = currDate + " 23:59:59";
					map.put("occurTimeStart",currMonth);
					map.put("occurTimeEnd",currDate);
				}else {  //ʱ  YYYY-MM-DD/YYYY-MM-DD
					String date[] = occurTime.split("/");
					map.put("occurTimeStart",date[0]);
					map.put("occurTimeEnd",date[1]);
				}
			}
			//¹״̬ 
			String accidentState = Struts2Utils.getParameter("accidentState");
			if (RHUtil.isNotEmpty(accidentState)) {  //¹״̬ 
				System.out.println("accidentState = " + accidentState);
				String[] state = null;
				if("199".equals(accidentState)) {  //199Ϊȫ
					state = new String[]{"0","2","3","4"};
					map.put("accidentState",state );
					//map.put("accidentStateNotIn",'1' );
				}else if ("0".equals(accidentState)){ //0-չʾδִУδ
					state = new String[]{"0"};
					map.put("accidentState",state );
				}else if("2".equals(accidentState)) {  //2-УС
					state = new String[]{"2"};
					System.out.println("state = " + state);
					map.put("accidentState",state );
				}else if("3".equals(accidentState)) {  //3-Ѻ,4-     Ѵ
					state = new String[]{"3","4"};
					map.put("accidentState",state);
				}
			}
			// 
			String search = Struts2Utils.getParameter("search");
			if (RHUtil.isNotEmpty(search)) {  //  
				map.put("LIKEsearch",search);
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("pages", String.valueOf(page));
			map.put("start",start );
			map.put("limit",rows );
			//System.out.println("************************start ==== "+ start);
			//System.out.println("************************rows ==== "+ rows);
			Struts2Utils.renderJson(this.service.query_TrafficHomePagetinfo(map));
			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_TrafficHomePagetinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳֱ̨ͳδʹе
	 * ѯ Trafficaccidentinfo
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_TrafficHomePageCount")
	public void query_TrafficHomePageCount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_TrafficHomePagetCount(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_TrafficHomePageCount-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һTrafficaccidentinfo
	 */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Trafficaccidentinfo")
	public void get_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Trafficaccidentinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoActionquery_Trafficaccidentinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteTrafficaccidentinfo")
	public void delete_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficaccidentinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-delete_Trafficaccidentinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * 
	 */
//	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficaccidentinfo")
	public void insert_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String accidentId = StringUtil.getUUID();
			String eventId = StringUtil.getUUID();
			String imgBase64 = (String.valueOf( map.get("imgBase64"))).split(",")[1];
					
			/*String[] ftpInfos = ModuleConfFactory.getInstance().getTraffAccident().
									getTraffAccidentFtp().split("\\$");
			FTPUrl fu = new FTPUrl(ftpInfos[0],Integer.parseInt(ftpInfos[1]),ftpInfos[2],ftpInfos[3]);
			*/
			FTPUrl fu = new FTPUrl();
			List<TinyFtpCfgInfo> list = BeanHelper.getModuleConfFactory().getFtps().getimpywTinyFtpCfgInfoList();
			if(RHUtil.isNotEmpty(list)) {
				TinyFtpCfgInfo tfci = list.get(0);
				String ip = tfci.getFtpServerHost();
				String port = tfci.getFtpServerPort();
				String user = tfci.getLoginName();
				String password = tfci.getLoginPasword();
				fu = new FTPUrl(ip,Integer.parseInt(port),user,password);
			}
			String ftpPath = FTPUtil.getFtpUrl(fu)+"/traffaccident/"+ DateUtil.getYMD().replaceAll("-", "\\/");
			
//			TrafficaccidentinfoBean bean = new TrafficaccidentinfoBean();
			//ͼ
			FTPUtil.uploadFile(fu, ftpPath,accidentId+"_"+map.get("alarmType")+"_small.jpg", ImageHepler.cutImage(imgBase64, 200, 170));
			//bigͼ
			FTPUtil.uploadFile(fu, ftpPath,accidentId+"_"+map.get("alarmType")+"_big.jpg", imgBase64);
			//middleͼ
			FTPUtil.uploadFile(fu, ftpPath,accidentId+"_"+map.get("alarmType")+"_middle.jpg", ImageHepler.cutImage(imgBase64, 500, 500));
			
			
			map.put("accidentState","1");
			map.put("eventUrl", ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_big.jpg");
			map.put("eventSmallUrl", ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_small.jpg");
			map.put("eventBigUrl", ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_middle.jpg");
			map.put("accidentId",accidentId);
			map.put("deviceType", "10");
			map.put("eventType", map.get("alarmType"));
			map.put("alarmTime", map.get("occurTime"));
			map.put("createAccount", "sqlserver");
			map.put("createTime", DateUtil.getDateTimeStr(new Date()));
			
			map.put("eventId",eventId );
//			map.put("alarmLevel", map.get("alarmLevel"));
//			map.put("occurTime", map.get("occurTime"));
//			map.put("deviceId", map.get("deviceId"));
			service.insert_Trafficaccidentinfo(map);
			//澯ǰ
			List list_alarm = new ArrayList();
			TrafficaccidentinfoBean tb = new TrafficaccidentinfoBean();
			tb.setAccidentId(accidentId);
			tb.setAccidentState("1");
			tb.setEventType(String.valueOf(map.get("alarmType")));
			tb.setAlarmLevel(String.valueOf(map.get("alarmLevel")));
			tb.setEventBigUrl( ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_middle.jpg");
			tb.setEventUrl(ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_big.jpg");
			tb.setVdId(String.valueOf(map.get("vdId")));
			tb.setChannelId(String.valueOf(map.get("channelId")));
			tb.setDeviceId(String.valueOf(map.get("deviceId")));
			tb.setAlarmTime(String.valueOf(map.get("occurTime")));
			tb.setOccurTime(String.valueOf(map.get("occurTime")));
			tb.setTdmc(String.valueOf(map.get("tdmc")));
			list_alarm.add(tb);
			if("bigScreen".equals(map.get("source"))){
				// ͳӦֵ
				BeanHelper.getAlarm2AlarmWorkTableService().setAlarm2AlarmWorkTableDataListListAdd(list_alarm);
			}else if("alarmWorkTable".equals(map.get("source"))){
				//ʹ
				BeanHelper.getTrafficEventAlarmStateDataService().setTrafficEventAlarmStateListAdd(list_alarm);
			}
			
			Map<String,String> result = new HashMap<String,String>();
			result.put("result", Constants.SUCCESS);
			result.put("accidentId", accidentId);
			result.put("eventId", eventId);
			result.put("eventUrl",  ftpPath+"/"+accidentId+"_"+map.get("alarmType")+"_big.jpg");
			Struts2Utils.renderJson(result);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-insert_Trafficaccidentinfo-error:" +e);
			Map<String,String> result = new HashMap<String,String>();
			result.put("result", Constants.ERROR);
			result.put("accidentId", "");
			result.put("eventId", "");
			result.put("eventUrl",  "");
			Struts2Utils.renderJson(result);
		}
	}
	
	/**
	 * ޸Ľͨ¼״̬ȷԤ/Ԥ
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficaccidentinfo")
	public void update_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String accidentId = Struts2Utils.getParameter("accidentId"); //¹ID
			String accidentState = Struts2Utils.getParameter("accidentState"); //¹״̬
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			map.put("XGTJaccidentId", accidentId);//¹״̬
			map.put("accidentState", accidentState);//¹״̬2У-3
			if("2".equals(accidentState)){
				map.put("confirmAccount", username);
				map.put("confirmTime", DateUtil.currentDateTime());
				//Ԥ,ѯԤ
				Map smap = new HashMap();
				smap.put("alarmType", Struts2Utils.getParameter("alarmType"));
				smap.put("planGrade", Struts2Utils.getParameter("planGrade"));
				smap.put("channelId", Struts2Utils.getParameter("channelId"));
				List<Map> list = trafficplanmanageService.query_Trafficplanmanage_sjgl(smap);
				for(int i=0;i<list.size();i++){
					Map mm = (Map)list.get(i);
					map.put("planID", mm.get("planID"));
					break;
				}
				//¼״̬
				Map iMap = new HashMap();
				iMap.put("planID", map.get("planID"));
				iMap.put("accidentId", accidentId);
				List rs = trafficaccidentstateService.get_Trafficaccidentstate(iMap);
				if(RHUtil.isEmpty(rs)){
					trafficaccidentstateService.insert_Trafficaccidentstate_plan(iMap);
				}
				
			}
			map.put("modifyAccount", username);
			map.put("modifyTime", DateUtil.currentDateTime());
			int result = service.update_Trafficaccidentinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-update_Trafficaccidentinfo-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	/**
	 * ҳ--¹״̬ҳpushlet״̬б
	 * @param ¼  accidentId   ¼мöŷָ
	 * @param ¼  accidentState  ¼״̬
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="batch_update_TrafficHomePageinfo")
	public void batch_update_TrafficHomePageinfo(){
		//Map map = Struts2Utils.getRequestParameterMap();
		String accidentId = Struts2Utils.getParameter("accidentId");  //¼
		String accidentState = Struts2Utils.getParameter("accidentState");  //¼״̬Ϊ0-չʾδ鿴
		System.out.println("****************batch_update_TrafficHomePageinfo*************accidentId=="+accidentId);
		System.out.println("****************batch_update_TrafficHomePageinfo*************accidentState=="+accidentState);
		try {
			if(StringUtils.isNotBlank(accidentId)&&StringUtils.isNotBlank(accidentState)){
				int result = service.batch_update_TrafficHomePageinfo(accidentId,accidentState);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				Struts2Utils.renderJson(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction - batch_update_TrafficHomePageinfo() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Trafficaccidentinfo")
	public void batch_delete_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			String[] arr = null; 
			String keywords = String.valueOf( map.get("keywords"));
			if(RHUtil.isNotEmpty(keywords)) {
				arr = keywords.split(","); 
			}
			m.put("accidentIds", arr);
			int result = service.batch_delete_Trafficaccidentinfo(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-batch_delete_Trafficaccidentinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	/*
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportTrafficaccidentinfo(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "ͨ¹ʼϢ");
			params.put("sheetName", "ͨ¹ʼϢ");
			params.put("header", "ͨ¹ʼϢ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	// ѯ豸Ϣ id +    
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Cameras")
	public void get_Cameras(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Cameras(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-get_Cameras-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ѯԤ
	@OperateType(value = LogConstants.LOG_QUERY, info="get_bjya")
	public void get_bjya() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_bjya(map));
		}catch(Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-get_bjya-error:"+e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Ϣ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listBigscreenInitCamere")
	public void listBigscreenInitCamere(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_listBigscreenInitCamere(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_listBigscreenInitCamere-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Ϣ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listBigscreenInitCamere")
	public void listBigscreenInitTunnel(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_listBigscreenInitTunnel(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_listBigscreenInitTunnel-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * 鱨Ϣ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listBigscreenInitLedBoard")
	public void listBigscreenInitLedBoard(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_listBigscreenInitLedBoard(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_listBigscreenInitLedBoard-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * յϢ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listBigscreenInitTrafficLight")
	public void listBigscreenInitTrafficLight(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_listBigscreenInitTrafficLight(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_listBigscreenInitTrafficLight-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ؽͨ¼ϢϢ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listBigscreenInitAlarm")
	public void listBigscreenInitAlarm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_listBigscreenInitAlarm(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-query_listBigscreenInitAlarm-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="updateTrafficaccidentinfo_planEnd")
	public void updateTrafficaccidentinfo_planEnd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			map.put("modifyAccount", username);
			map.put("modifyTime",DateUtil.currentDateTime());
			Struts2Utils.renderJson(this.service.updateTrafficaccidentinfo_planEnd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-updateTrafficaccidentinfo_planEnd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ޸Ľͨ¼״̬ȷԤ/Ԥ
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficaccidentinfo_plan")
	public void update_Trafficaccidentinfo_plan(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String accidentId = Struts2Utils.getParameter("accidentId"); //¹ID
			String accidentState = Struts2Utils.getParameter("accidentState"); //¹״̬
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
			map.put("XGTJaccidentId", accidentId);//¹״̬
			map.put("accidentState", accidentState);//¹״̬2У-3
			if("2".equals(accidentState)){
				map.put("confirmAccount", username);
				map.put("confirmTime", DateUtil.currentDateTime());
				//Ԥ,ѯԤ
				Map smap = new HashMap();
				smap.put("alarmType", Struts2Utils.getParameter("alarmType"));
				smap.put("planGrade", Struts2Utils.getParameter("planGrade"));
				smap.put("channelId", Struts2Utils.getParameter("tmpDeviceId"));
				List<Map> list = trafficplanmanageService.query_Trafficplanmanage_sjgl(smap);
				for(int i=0;i<list.size();i++){
					Map mm = (Map)list.get(i);
					map.put("planID", mm.get("planID"));
					break;
				}
				//¼״̬
				Map iMap = new HashMap();
				iMap.put("planID", map.get("planID"));
				iMap.put("accidentId", accidentId);
				List rs = trafficaccidentstateService.get_Trafficaccidentstate(iMap);
				if(RHUtil.isEmpty(rs)){
					trafficaccidentstateService.insert_Trafficaccidentstate_plan(iMap);
				}
				
			}
			map.put("modifyAccount", username);
			map.put("modifyTime", DateUtil.currentDateTime());
			int result = service.update_Trafficaccidentinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-update_Trafficaccidentinfo_plan-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Trafficaccidentinfo")
	public void get_Trafficaccidentinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Trafficaccidentinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficaccidentinfoAction-get_Trafficaccidentinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
