package cn.bsystem.ptuserrole.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.bsystem.ptuserrole.dao.PtcdjsDao;

@Service("ptcdjsService")
public class PtcdjsService extends BaseService {
	
	private static final Log log = LogFactory.getLog(PtcdjsService.class);
	
	@Autowired
	private PtcdjsDao ptcdjsDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptcdjs(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptcdjsDao.insert_Ptcdjs(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptcdjs(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptcdjsDao.update_Ptcdjs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptcdjs(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptcdjsDao.delete_Ptcdjs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptcdjs(Map map) throws SQLException{
		return ptcdjsDao.batch_delete_Ptcdjs(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptcdjs(Map map) throws SQLException{
		return ptcdjsDao.count_Ptcdjs(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptcdjs(Map map) throws SQLException{
		return ptcdjsDao.query_Ptcdjs(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptcdjs(Map map) throws SQLException{
		return ptcdjsDao.get_Ptcdjs(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtcdjs(Map map) throws SQLException{
		return this.listPtcdjsByPage(map);
	}
	
	/**
	 * Ptcdjs ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtcdjsByPage(Map map) throws SQLException {
		List<Map> list = ptcdjsDao.query_Ptcdjs(map);
		Integer totalCount = ptcdjsDao.count_Ptcdjs(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	 
	public List<Map> getPtcdjsMemuListByJSBH(Map map) throws SQLException{
		return ptcdjsDao.getPtcdjsMemuListByJSBH(map);
	}
	
	public Integer deletePtcdjsMenuIdByJSBH(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptcdjsDao.deletePtcdjsMenuIdByJSBH(map);
	}
	
	
	/**
	 * ¼ByJSBH
	 */
	public void insert_ptcdjsMenuIdByJSBH(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptcdjsDao.insert_ptcdjsMenuIdByJSBH(map);
	}
	public List<Map> listPtcdjs( ) throws SQLException{
		return ptcdjsDao.listPtcdjs();
	}


}
