package cn.bsystem.ptuserrole.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.service.PtyhbmService;

@SuppressWarnings({"all"})
@Component("ptyhbmAction")
public class PtyhbmAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtyhbmAction.class);
	
	@Autowired
	private PtyhbmService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhbmByPage")
	public void listPtyhbmByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listPtyhbmByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - listPtyhbmByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_ptyhbm_ext")
	public void query_ptyhbm_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.query_ptyhbm_ext(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - listPtyhbmByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptyhbm")
	public void count_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptyhbm(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - count_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptyhbm
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptyhbm")
	public void query_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptyhbm(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - query_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һPtyhbm
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptyhbm")
	public void get_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptyhbm(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - query_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyhbm")
	public void delete_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptyhbm(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - delete_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyhbm")
	public void insert_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("bmbh"))){
				map.put("bmbh",StringUtil.getUUID());
			}
			service.insert_Ptyhbm(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - listPtyhbmByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyhbm")
	public void update_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptyhbm(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - update_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptyhbm")
	public void batch_delete_Ptyhbm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptyhbm(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - batch_delete_Ptyhbm() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtyhbm(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtyhbmAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}

	/**
	 * ȡǰûв˵
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_alldept")
	public void query_alldept(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List list = this.service.query_alldept(map);
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ptyhbmAction - query_alldept() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_ptyhdepart_ext")
	public void query_ptyhdepart_ext(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.query_ptyhdepart_ext(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - query_ptyhdepart_ext() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯids
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listdepartidsByyhbh")
	public void  listdepartidsByyhbh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {

			Struts2Utils.renderJson(this.service.querydepartidsByyhbh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhbmAction - query_ptyhdepart_ext() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}

}
