package cn.bsystem.ptmenu.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import cn.acx.IcxDacClient;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.conf.Ditu;
import cn.base.conf.ModuleConfFactory;
import cn.base.conf.Node;
import cn.base.conf.Scatter;
import cn.base.util.RHUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.ice.autoDef.PtxzsEntityArrayHolder;

@SuppressWarnings({"all"})
@Component("menuConfigAction")
public class MenuConfigAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(MenuConfigAction.class);

	public void getWebRtcInfo(){
		try {
			Struts2Utils.renderJson(BeanHelper.getModuleConfFactory().getWebrtc().getWebRtcSocketUrl());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getWebRtcInfo" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void getDacLoginInfo(){
		try {
			Map map =  new HashMap();
			String[]  splity = BeanHelper.getModuleConfFactory().getWebrtc().getWebRtcServerUrl().split("\\:");
			PtyhBean userInfo = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			map.put("serverIP", splity[0]);
			map.put("serverPort", splity[1]);
			map.put("yhzh", userInfo.getYhzh());
			map.put("yhmm", userInfo.getYhmm());
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getDacLoginInfo" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void getChannelListFromSystem(){
		List list = new ArrayList();
		Map map = Struts2Utils.getRequestParameterMap();
		Map mapRtn = new HashMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			PtyhBean userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			map.put("yhzh", userInfo.getYhzh());
			cn.ice.autoDef.SbtdspsrEntityArrayHolder holder = new  cn.ice.autoDef.SbtdspsrEntityArrayHolder();
	 		Date d1 = new Date();
	 		map.put("module", "impyw");
//	 		map.put("module", "imps");
	 		map.put("liketdmc", Struts2Utils.getParameter("LIKEtdmc"));
	 		map.put("sbtd_start", String.valueOf(start));
	 		map.put("sbtd_limit", String.valueOf(rows));
//	 		map.put("sbtd_limit", String.valueOf(start+rows));
	 		//map.put("noSort", "noSort");//dacchannelб򣬶ƻkey
	 		iLog.info(" dac getChannelListFromSystem client map : "+(map.toString()));
	 		IcxDacClient client = (IcxDacClient) BeanHelper.getBean("IcxDacClient");
			int loginret = client.getDacServicePrx().queryVideoInChannelArray(map, holder);
			Date d2  = new Date();
			iLog.info(" dac webrtc client query time "+(d2.getTime()-d1.getTime()));
			iLog.info("getChannelListFromSystem from dac ice Ret="+loginret+" size="+holder.value.length);
	 		for(int i=0;i<holder.value.length;i++){
	 			if(i == 0){
	 				map.put("total", holder.value[i].kz1); //dacչб
	 			}
	 			Map mm = new HashMap();
	 			mm.put("xh",holder.value[i].xh);
	 			mm.put("name",holder.value[i].tdmc);
	 			mm.put("pid",holder.value[i].xzbh);
	 			mm.put("jdpx",holder.value[i].jdpx);
	 			mm.put("sbbh",holder.value[i].sbbh);	 			
	 			mm.put("tdbh",holder.value[i].tdbh);
	 			mm.put("tdmc",holder.value[i].tdmc);
	 			mm.put("tdmcpy",holder.value[i].tdmcpy);
	 			mm.put("xzbh",holder.value[i].xzbh);
	 			mm.put("ggbh",holder.value[i].ggbh);
	 			mm.put("dqx",holder.value[i].dqx);
	 			mm.put("xqx",holder.value[i].xqx);
	 			mm.put("pqx",holder.value[i].pqx);
	 			mm.put("kqx",holder.value[i].kqx);
	 			mm.put("lxxzqx",holder.value[i].lxxzqx);
	 			mm.put("tdzt",holder.value[i].tdzt);
	 			mm.put("jd",holder.value[i].jd);
	 			mm.put("wd",holder.value[i].wd);
	 			mm.put("sfzx",holder.value[i].sfzx);
	 			mm.put("sfzlx",holder.value[i].sfzlx);
	 			mm.put("lxzt",holder.value[i].lxzt);
	 			mm.put("tdlx",holder.value[i].tdlx);
	 			mm.put("nodeOrder",holder.value[i].jdpx);
	 			mm.put("sj",holder.value[i].sj);
	 			list.add(mm);
	 		}
	 		map.put("rows", list);
	 		Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuConfigAction-getChannelListFromSystem error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void getXzTreeChannelListFromSystem(){
		List list = new ArrayList();
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			map.put("yhzh", userInfo.getYhzh());
			cn.ice.autoDef.SbtdspsrEntityArrayHolder holder = new  cn.ice.autoDef.SbtdspsrEntityArrayHolder();
	 		Date d1 = new Date();
	 		map.put("module", "imps");
//	 		map.put("noSort", "noSort");//dacchannelб򣬶ƻkey
	 		iLog.info(" getXzTreeChannelListFromSystem webrtc client map : "+(map.toString()));
	 		IcxDacClient client = (IcxDacClient) BeanHelper.getBean("IcxDacClient");
			int loginret = client.getDacServicePrx().queryVideoInChannelArray(map, holder);
			Date d2  = new Date();
			iLog.info(" dac webrtc client query time "+(d2.getTime()-d1.getTime()));
			iLog.info("getChannelListFromSystem from dac ice Ret="+loginret+" size="+holder.value.length);				
	 		for(int i=0;i<holder.value.length;i++){
	 			Map mm = new HashMap();
	 			mm.put("order",i);
	 			mm.put("xh",holder.value[i].xh);
	 			mm.put("name",holder.value[i].tdmc);
	 			mm.put("pid",holder.value[i].xzbh);
	 			mm.put("jdpx",holder.value[i].jdpx);
	 			mm.put("sbbh",holder.value[i].sbbh);	 			
	 			mm.put("tdbh",holder.value[i].tdbh);
	 			mm.put("tdmc",holder.value[i].tdmc);
	 			mm.put("tdmcpy",holder.value[i].tdmcpy);
	 			mm.put("xzbh",holder.value[i].xzbh);
	 			mm.put("ggbh",holder.value[i].ggbh);
	 			mm.put("dqx",holder.value[i].dqx);
	 			mm.put("xqx",holder.value[i].xqx);
	 			mm.put("pqx",holder.value[i].pqx);
	 			mm.put("kqx",holder.value[i].kqx);
	 			mm.put("lxxzqx",holder.value[i].lxxzqx);
	 			mm.put("tdzt",holder.value[i].tdzt);
	 			mm.put("jd",holder.value[i].jd);
	 			mm.put("wd",holder.value[i].wd);
	 			mm.put("sfzx",holder.value[i].sfzx);
	 			mm.put("sfzlx",holder.value[i].sfzlx);
	 			mm.put("lxzt",holder.value[i].lxzt);
	 			mm.put("tdlx",holder.value[i].tdlx);
	 			mm.put("nodeOrder",holder.value[i].jdpx);
	 			mm.put("sj",holder.value[i].sj);
	 			list.add(mm);
	 		}
	 		Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuConfigAction-getXzTreeChannelListFromSystem error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void query_Ptxzs(){
		List list = new ArrayList();
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			PtyhBean userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			map.put("yhzh", userInfo.getYhzh());
			map.put("order", " order by jdpx asc ");
			PtxzsEntityArrayHolder holder = new  PtxzsEntityArrayHolder();
	 		Date d1 = new Date();
	 		iLog.info(" dac query_Ptxzs map : "+(map.toString()));
	 		IcxDacClient client = (IcxDacClient) BeanHelper.getBean("IcxDacClient");
			int loginret = client.getDacServicePrx().queryXzTreeArray(map, holder);
			Date d2  = new Date();
			iLog.info(" dac query_Ptxzs query time "+(d2.getTime()-d1.getTime()));
			iLog.info("query_Ptxzs from dac ice Ret="+loginret+" size="+holder.value.length);
	 		Struts2Utils.renderJson(holder.value);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuConfigAction-query_Ptxzs error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void getDitu(){
		try {
			Map map =  new HashMap();
			Ditu ditu = BeanHelper.getModuleConfFactory().getDitu();
			map.put("ditu", ditu);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getDitu" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void getConfig(){
		try {
			Map map =  new HashMap();
			Ditu ditu = BeanHelper.getModuleConfFactory().getDitu();
			map.put("ditu", ditu);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getConfig" +e);
			Struts2Utils.renderJson(null);
		}
	}
	public void getCustomName(){
		try {
			Map map =  new HashMap();
			String customName = ModuleConfFactory.getInstance().getScatter().getCustomName();
			map.put("customName", customName);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getCustomName" +e);
			Struts2Utils.renderJson(null);
		}
	}
	 
	public void getPicProxyConfig(){
		try {
			Map map =  new HashMap();
			String isPicProxy = ModuleConfFactory.getInstance().getScatter().getIsPicProxy();
			map.put("isPicProxy", isPicProxy);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("getPicProxyConfig" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void select_PicPorxy(){
		List list = new ArrayList();
		Map map = Struts2Utils.getRequestParameterMap();
		Map<String, List> mm = new HashMap<String, List>();
		Map mrs = new HashMap();
		String localProIp = "";
		String defaultPorxyUrl = "";
		if(RHUtil.isNotEmpty(map.get("localProIp"))){
			localProIp = map.get("localProIp").toString();
			//defaultPorxyUrl = "http://"+localProIp+":8080/pac/sourceProxy?fileType=picUrlProxy&picUrl=";
		}		
		List impagentList = ModuleConfFactory.getInstance().getImpagent().getList();
		for(int i=0;i<impagentList.size();i++){
			Node node = (Node)impagentList.get(i);
			if(RHUtil.isNotEmpty(node.getValue())){
				String name = node.getName();
				String value = node.getValue();
				mrs.put(name, value);
			}
		}
		Struts2Utils.renderJson(mrs);
	}
	
	public Map getMatchIpList(String clientIp,List<Map> ips){
		Map mmm = new HashMap();
		String matchIp = "";
		if(RHUtil.isNotEmpty(ips)){
			mmm = (Map)ips.get(0);
		}
		if(clientIp.length()==1) return mmm;
		for(int i=0;i<clientIp.length();i++){
			String shortClientIp = clientIp.substring(0,clientIp.length()-i-1);
			for(int j=0;j<ips.size();j++){
				Map ipp = (Map)ips.get(j);
				String ip = "";
				if(RHUtil.isNotEmpty(ipp.get("matchIp"))){
					ip = ipp.get("matchIp").toString();
				}
				if(ip.startsWith(shortClientIp)){
					matchIp = ip;
					return ipp;
				}
			}
		}
		return mmm;
	}
}
