package cn.base.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.socket.quartz.DeviceDateJob;
import org.apache.commons.lang.StringUtils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class StringUtil extends StringUtils {

	// 32λUUID
	public static String getUUID() {
		String id = UUID.randomUUID().toString().replaceAll("-", "");
		return id;
	}

	public static Date getDateZeroTime() {
		Calendar c = Calendar.getInstance();// Զÿʱ򵥶޸
		int year = c.get(Calendar.YEAR);
		int month = c.get(Calendar.MONTH)+1;
		int date = c.get(Calendar.DAY_OF_MONTH);
		String strDate = year + "-" + month + "-" + date + " 00:00:00";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date newDate = null;
		try {
			newDate = sdf.parse(strDate);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return newDate;
	}
	
	public static void main(String[] args) {
		Date date = getDateZeroTime();
		System.out.println(date);
	}

	// ƥ䴦
	public static String getPlateNo(String plateNo) {
		if (plateNo != null && !plateNo.equals("")) {
			if (plateNo.indexOf("*") != -1 || plateNo.indexOf("?") != -1) {
				plateNo = plateNo.replace('?', '_').replace('*', '%').toUpperCase();
				plateNo = " plateNo like '" + plateNo + "'";
			} else {
				plateNo = " plateNo = '" + plateNo.toUpperCase() + "'";
			}
			return plateNo;
		}
		return "";
	}

	// ųƺŴ
	public static String getNoBrandId(String noBrandId) {
		if (noBrandId != null && !noBrandId.equals("")) {
			if (noBrandId.indexOf("*") != -1 || noBrandId.indexOf("?") != -1) {
				noBrandId = noBrandId.replace('?', '_').replace('*', '%').toUpperCase();
				noBrandId = " plateNo not like '" + noBrandId + "'";
			} else {
				noBrandId = " plateNo <> '" + noBrandId.toUpperCase() + "'";
			}
			return noBrandId;
		}
		return "";
	}

	/**
	 * жַstrǷΪnull""
	 * 
	 * @param str
	 * @return boolean
	 */
	public static boolean isEmpty(String str) {
		return str == null || str.length() == 0;
	}

	public static boolean isNotEmpty(String str) {
		return !isEmpty(str);
	}

	/**
	 * жַstrǷΪnull""" "
	 * 
	 * @param str
	 * @return boolean
	 */
	public static boolean isBlank(String str) {
		int strLen;
		if (str == null || (strLen = str.length()) == 0) {
			return true;
		}
		for (int i = 0; i < strLen; i++) {
			if ((Character.isWhitespace(str.charAt(i)) == false)) {
				return false;
			}
		}
		return true;
	}

	public static String doNullOfStr(Object oTag) {
		if (oTag == null || ("null").equals(oTag))
			return "";
		else
			return oTag.toString();
	}

	/**
	 * ַ
	 * 
	 * @param str
	 * @return String
	 */
	public static String sortString(String str) {
		List<Character> slist = new ArrayList<Character>();
		for (int i = 0; i < str.length(); i++) {
			slist.add(str.charAt(i));
		}
		Collections.sort(slist);
		String strs = "";
		for (int j = 0; j < slist.size(); j++) {
			strs += slist.get(j).toString().trim();
		}
		return strs;
	}

	/**
	 * htmlеimgǩ,%%number,%%,inputǩ,10-01-04
	 * 
	 * @author sunxiaosong
	 * @return String
	 */
	public static String dealWithImg(String htmlStr) {
		if (!StringUtils.isEmpty(htmlStr)) {
			// ȥ<img/>,%%number,%%,<input/>ǩ
			htmlStr = htmlStr.replaceAll("<img.*/>", "ͼƬ").replaceAll("%%[0-9]{1,}", "").replaceAll("%%", "").replaceAll("<input.*?/>", "");
		}
		return htmlStr;
	}

	public static boolean isNotBlank(String str) {
		return !isBlank(str);
	}

	public static final String trim(String str) {
		return ((str == null) ? str : str.trim());
	}

	public static String clean(String str) {
		return str == null ? "" : str.trim();
	}

	public static final String emptyToDefault(String value, String defaultValue) {
		return (((value != null) && (value.length() > 0)) ? value : defaultValue);
	}

	public static final String nullToEmpty(String value) {
		return ((value == null) ? "" : value);
	}

	/**
	 * ַת
	 * 
	 * @param value
	 * @param from
	 * @param to
	 * @return String
	 */
	public static final String changeEncode(String value, String from, String to) {
		if (isEmpty(value))
			return "";
		try {
			String str = new String(value.getBytes(from), to);
			return str;
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * ַISO8859-1תUTF-8
	 * 
	 * @param value
	 * @return String
	 */
	public static final String toUtf8(String value) {
		return changeEncode(value, "ISO8859-1", "utf-8");
	}

	/**
	 * ת
	 * 
	 * @param value
	 * @param encode
	 * @return String
	 */
	public static final String encode(String value, String encode) {
		if (isEmpty(value))
			return "";
		try {
			String str = URLEncoder.encode(value, encode);
			return str;
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * 
	 * 
	 * @param value
	 * @param encode
	 * @return String
	 */
	public static final String decode(String value, String encode) {
		if (isEmpty(value))
			return "";
		try {
			String str = URLDecoder.decode(value, encode);
			return str;
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * תUTF-8
	 * 
	 * @param value
	 * @return String
	 */
	public static final String encode(String value) {
		return encode(value, "UTF-8");
	}

	/**
	 * UTF-8н
	 * 
	 * @param value
	 * @return String
	 */
	public static final String decode(String value) {
		return decode(value, "UTF-8");
	}
	// жǷ
	public static boolean hasFullSize(String inStr) {
        return inStr.getBytes().length != inStr.length();
    }
	public static String getChineseEncoding(String url) {
		String encodeStr = "";
		if (url != null) {
			try {
				for (int i = 0; i < url.length(); i++) {
					if (hasFullSize(url.substring(i, i + 1)))
						encodeStr += URLEncoder.encode(url.substring(i, i + 1), "utf-8");
					else
						encodeStr += url.substring(i, i + 1);
				}
			} catch (Exception e) {
			}
		}
		return encodeStr;
	}
	// ַתutf8룬֤ļ
	public static String toUtf8String(String s) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c >= 0 && c <= 255) {
				sb.append(c);
			} else {
				byte[] b;
				try {
					b = Character.toString(c).getBytes(StandardCharsets.UTF_8);
				} catch (Exception ex) {
					b = new byte[0];
				}
				for (int j = 0; j < b.length; j++) {
					int k = b[j];
					if (k < 0)
						k += 256;
					sb.append("%" + Integer.toHexString(k).toUpperCase());
				}
			}
		}
		return sb.toString();
	}
	
	public static boolean checkEmpty(Object pObj) {
		if (pObj == null)
			return true;
		if (pObj.equals(""))
			return true;
		if (pObj instanceof String) {
            return ((String) pObj).length() == 0;
		} else if (pObj instanceof Collection) {
            return ((Collection) pObj).size() == 0;
		} else if (pObj instanceof Map) {
            return ((Map) pObj).size() == 0;
		}
		return false;
	}
	
	/**
	 * ж϶ǷEmpty(nullԪΪ0)<br>
	 * ʵڶ¶ж:String Collection Map
	 * @param pObj 
	 * @return boolean صĲֵ
	 */
	public static boolean isEmpty(Object pObj) {
		if (pObj == null)
			return true;
		if (pObj == "")
			return true;
		if (pObj instanceof String) {
            return ((String) pObj).length() == 0;
		} else if (pObj instanceof Collection) {
            return ((Collection) pObj).size() == 0;
		} else if (pObj instanceof Map) {
            return ((Map) pObj).size() == 0;
		}
		return false;
	}
	/**
     * ʽжַǷ,""Ϊ
     * @param str
     * @return
     */
    public static boolean isNumeric(String str){
    	if(StringUtils.isEmpty(str)){
    		return false;
    	}
	    Pattern pattern = Pattern.compile("[0-9]*");
	    Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
    /**
     * ַתΪ
     * @param str
     * @return
     */
    public static Integer str2Numeric(String str){
    	if(StringUtils.isEmpty(str)||"null".equals(str)){
    		return 0;
    	}
    	if(str.lastIndexOf(".")!=-1){
    		str = str.substring(0, str.lastIndexOf("."));
    	}
    	Pattern pattern = Pattern.compile("[0-9]*");
    	Matcher isNum = pattern.matcher(str);
    	if( !isNum.matches() ){
    		return 0;
    	}
    	return Integer.valueOf(str);
    }
    public static Double str2Double(String str){
    	if(StringUtils.isEmpty(str)||"null".equals(str)){
    		return 0.0;
    	}
    	Pattern pattern = Pattern.compile("[0-9]*.*");
    	Matcher isNum = pattern.matcher(str);
    	if( !isNum.matches() ){
    		return 0.0;
    	}
    	return Double.valueOf(str);
    }
    /**
     * ַת
     */
    public static String transEmpty(String str){
		if("null".equals(str)|| StringUtils.isEmpty(str)){
			return "";
		}
		return str;
	}


}
