package cn.base.util;

import common.Logger;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class HttpUtil {
    public static Logger log = Logger.getLogger(HttpUtil.class);

    /**
     * ָURLGET
     *
     * @param url   URL
     * @param param Ӧ name1=value1&name2=value2 ʽ
     * @return URL ԶԴӦ
     */
    public static String sendGet(String url, String param) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = null;
        try {
            /*֤֤ҪConnectionǰӴд*/
            trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            String urlNameString = url + param;
            log.info("urlNameString"+urlNameString);
            URL realUrl = new URL(urlNameString);
            // 򿪺URL֮
            HttpsURLConnection  connection =(HttpsURLConnection ) realUrl.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("GET");
            // ͨõ
//            connection.setRequestProperty("accept", "*/*");
//            connection.setRequestProperty("connection", "Keep-Alive");
//            connection.setRequestProperty("user-agent",
//                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
//            connection.setRequestProperty("Content-type", "application/json");
            connection.setInstanceFollowRedirects(false);
            // ʵʵ
            connection.connect();
            // ȡӦͷֶ
//            Map<String, List<String>> map = connection.getHeaderFields();
////             еӦͷֶ
//            for (String key : map.keySet()) {
//                System.out.println(key + "--->" + map.get(key));
//            }

            //  BufferedReaderȡURLӦ
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream(), StandardCharsets.UTF_8));
            String line;
            while ((line = in.readLine()) != null) {
                log.info("line"+line);
                System.out.println(line);
                buffer.append(line);
            }
        } catch (Exception e) {
            System.out.println("GET쳣" + e);
            e.printStackTrace();
        }
        // ʹfinallyر
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return buffer.toString();
    }
    static HostnameVerifier hv = new HostnameVerifier() {
        public boolean verify(String urlHostName, SSLSession session) {
            System.out.println("Warning: URL Host: " + urlHostName + " vs. "
                    + session.getPeerHost());
            return true;
        }
    };
    private static void trustAllHttpsCertificates() throws Exception {
        javax.net.ssl.TrustManager[] trustAllCerts = new javax.net.ssl.TrustManager[1];
        javax.net.ssl.TrustManager tm = new miTM();
        trustAllCerts[0] = tm;
        javax.net.ssl.SSLContext sc = javax.net.ssl.SSLContext
                .getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        javax.net.ssl.HttpsURLConnection.setDefaultSSLSocketFactory(sc
                .getSocketFactory());
    }

    static class miTM implements javax.net.ssl.TrustManager,
            javax.net.ssl.X509TrustManager {
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(
                java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(
                java.security.cert.X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(
                java.security.cert.X509Certificate[] certs, String authType)
                throws java.security.cert.CertificateException {
            return;
        }

        public void checkClientTrusted(
                java.security.cert.X509Certificate[] certs, String authType)
                throws java.security.cert.CertificateException {
            return;
        }
    }
    public static  String doget(String  urlStr) {
        BufferedReader in=null;
        InputStream inputStream=null;
        HttpURLConnection httpconn = null;
        HttpsURLConnection connection = null;
        try {
            log.info(urlStr);
            URL url = new URL(urlStr);
            trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            log.info("trustAllHttpsCertificates");
            connection = (HttpsURLConnection) url.openConnection();
            if (url.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                httpconn = connection;
            }
            else {    //жhttpshttp
                httpconn = (HttpURLConnection) url.openConnection();
            }
                log.info("GET");
            httpconn.setRequestMethod("GET");
            httpconn.setReadTimeout(50000);
            if (httpconn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                log.info("HTTP_OK");
                inputStream=httpconn.getInputStream();
                in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                String line = null;
                StringBuffer stringBuffer = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    stringBuffer.append(line);
                    log.info(line);
                }

                in.close();
                inputStream.close();
                httpconn.disconnect();
                connection.disconnect();
                return stringBuffer.toString();
            } else {
                httpconn.disconnect();
                connection.disconnect();
            }
    }catch (Exception e) {
        System.out.println("GET쳣" + e);
        e.printStackTrace();
    }
    // ʹfinallyر
        finally {
        try {
            if (in != null) {
                in.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            httpconn.disconnect();
            connection.disconnect();
        } catch (Exception e2) {
            e2.printStackTrace();
        }
    }
        return null;
    }

    public static String getEncoding(String str) {
        String[] encode = new String[]{
                "UTF-8",
                "ISO-8859-1",
                "GB2312",
                "GBK",
                "GB18030",
                "Big5",
                "Unicode",
                "ASCII"
        };
        for (int i = 0; i < encode.length; i++){
            try {
                if (str.equals(new String(str.getBytes(encode[i]), encode[i]))) {
                    return encode[i];
                }
            } catch (Exception ex) {
            }
        }
        return "";
    }
}