package cn.base.util;

import java.sql.SQLException;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.bsystem.ptuserrole.model.PtyhBean;
 
public class CommUtils { 
	private static final Log iLog = LogFactory.getLog(CommUtils.class.getName());

	/**
	 * ȡͻIP
	 * 
	 * @param request
	 * @return
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	

	public static boolean haveMoreMemory() {
		Random random = new Random();
		Runtime runtime = Runtime.getRuntime();
		long maxM = runtime.maxMemory() / 1024 / 1024;
		long freeM = runtime.freeMemory() / 1024 / 1024;
		long totalM = runtime.totalMemory() / 1024 / 1024;
		if (random.nextInt(1000) == 50) {
			iLog.error("ϵͳڴ:" + maxM + "MB ǰԴ:" + totalM + "MB ǰԴ" + freeM + "MB");
		}
		if (maxM > (totalM + 50) || freeM > 50) {
			return true;
		} else {
			iLog.error("ϵͳڴ:" + maxM + "MB ǰԴ:" + totalM + "MB ǰԴ" + freeM + "MB");
			return false;
		}
	}
	
	public static long ipToLong(String strIP) {
		try {
			long[] ip = new long[4];
			int position1 = strIP.indexOf(".");
			int position2 = strIP.indexOf(".", position1 + 1);
			int position3 = strIP.indexOf(".", position2 + 1);
			ip[0] = Long.parseLong(strIP.substring(0, position1));
			ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
			ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
			ip[3] = Long.parseLong(strIP.substring(position3 + 1));
			return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
		} catch (Exception ex) {
			iLog.error("ipַΧʽ" + strIP, ex);
			return 0;
		}
	}
	public static boolean isEmpty(Object pObj) {
		if (pObj == null)
			return true;
		if (pObj.equals(""))
			return true;
		if (pObj instanceof String) {
			return ((String) pObj).length() == 0;
		} else if (pObj instanceof Collection) {
			return ((Collection) pObj).size() == 0;
		} else if (pObj instanceof Map) {
			return ((Map) pObj).size() == 0;
		}
		return false;
	}

	//ݿͻIPõͼƬʾIP,domainΪnull""
		public static String getPhotoRsIp(String clientIp,String domain) {
 			String ipUrl = null;
//			List<Node> list = XmlUtils.getInstance().getPhotoRs();
//			for (Node node : list) {
//				String ipSeg = node.getName();
//				String domainId = node.getDomain();
//				if(domain==null || domain.equals("") || domainId==null || domainId.equals("") || domainId.indexOf(domain)!=-1) {
//					boolean isValid = IpUtils.isValidSegIp(clientIp, ipSeg);
//					if (isValid == true) {
//						ipUrl = node.getValue();
//						break;
//					}
//				}
//			}
//			if(ipUrl==null){
//				for (Node node : list) {
//					String ipSeg = node.getName();
//					String domainId = node.getDomain();
//					if(domainId==null || domainId.equals("") || domainId.equals("*")) {
//						ipUrl = node.getValue();
//						break;
//					}
//				}
//			}
//			//iLog.info("ͼƬʾIP:"+ipUrl);
 			return ipUrl;
//		
	}
		
		/**
		 * createaccount createtime modifyaccount modifytime
		 * b = true ޸
		 * b = false  
		 * @param m
		 * 
		 * <isNotNull prepend=',' property='cjry'>cjry</isNotNull>
			<isNotNull prepend=',' property='cjrq'>cjrq</isNotNull>
		<isNotNull prepend=',' property='xgry'>xgry</isNotNull>
		<isNotNull prepend=',' property='xgrq'>xgrq</isNotNull>
		 * 
		 * 
		 */
		public static void addParams(Map m, boolean b) {
			PtyhBean py=((PtyhBean)Struts2Utils.getSession() .getAttribute("userInfo"));
			if(null!=py) {
				String username =py.getYhzh();
				if (b) { //modify
					m.put("xgry", username);
					m.put("xgrq", DateUtil.currentDateTime());
					m.put("modifyaccount", username);
					m.put("modifytime", DateUtil.currentDateTime());
				} else {//create
					m.put("xgry", username);
					m.put("xgrq", DateUtil.currentDateTime());
					m.put("cjry", username);
					m.put("cjrq", DateUtil.currentDateTime());
					m.put("modifyaccount", username);
					m.put("modifytime", DateUtil.currentDateTime());
				}
			}
			
		}
		public static void addYhParams(Map m, boolean b) {
			PtyhBean py=((PtyhBean)Struts2Utils.getSession() .getAttribute("userInfo"));
			if(null!=py) {
				String username = py.getYhzh();
				if (b) { //modify
					m.put("xgry", username);
					m.put("xgrq", DateUtil.currentDateTime());
					m.put("modifyaccount", username);
					m.put("modifytime", DateUtil.currentDateTime());
				} else {//create
					m.put("xgry", username);
					m.put("xgrq", DateUtil.currentDateTime());
					m.put("modifyaccount", username);
					m.put("modifytime", DateUtil.currentDateTime());
				}
			}
		}
		

		/**
		 * ޸ʱ֤Ƿ޸
		 * @param m
		 * @throws SQLException
		 */
		public static void validateUpdateParams(Map m) throws SQLException {
			validateDeleteParams(m);
		}
		
		/**
		 * ɾʱ֤Ƿ
		 * @param m
		 * @throws SQLException
		 */
		public static void validateDeleteParams(Map m) throws SQLException {
			if(m==null || m.size() == 0) {
				throw new SQLException("ɾޣ");
			}
		}
		/**
		 * mapĳvalueʹMD5ת
		 * @param m
		 * @throws SQLException
		 */
		public static void MD5MapValueByKey(Map m,String key) throws SQLException {
			if(m==null || m.size() == 0) {
				throw new SQLException("ɾޣ");
			}
			if(m.containsKey(key)){
				m.put(key ,MD5Util.md5(m.get(key).toString()));
			}
		}
}
