package cn.base.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.base.util.RHUtil;

/**
 * Json??br>
 * @author redhigh
 * @since 2013-12-04
 */
public class JsonHelper {
	private static final Log log = LogFactory.getLog(JsonHelper.class);
	/**
	 * ʱʽJavaϵлΪJsonϸʽ
	 * @param pObject Java
	 * @return
	 */
	public static final String encodeObject2Json(Object pObject) {
		String jsonString = "[]";
		if (RHUtil.isEmpty(pObject)) {
			// log.warn("JavaΪ,ܽлΪJsonϸʽ.??");
		} else {
			if (pObject instanceof ArrayList) {
				JSONArray jsonArray = JSONArray.fromObject(pObject);
				jsonString = jsonArray.toString();
			} else {
				JSONObject jsonObject = JSONObject.fromObject(pObject);
				jsonString = jsonObject.toString();
			}
		}
		if (log.isInfoEnabled()) {
			log.info("лJSON:\n" + jsonString);
		}
		return jsonString;
	}
	/**
	 * ʱʽJavaϵлΪJsonϸʽ<br>
	 * Json-Libڴʱʽ????ʵJsonValueProcessorӿ,????ṩһصķԺ??br>
	 * ʱʽJava??
	 * @param pObject Java
	 * @return
	 */
	public static final String encodeObject2Json(Object pObject, String pFormatString) {
		String jsonString = "[]";
		if (RHUtil.isEmpty(pObject)) {
			// log.warn("JavaΪ,ܽлΪJsonϸʽ.??");
		} else {
			JsonConfig cfg = new JsonConfig();
			cfg.registerJsonValueProcessor(java.sql.Timestamp.class, new JsonValueProcessorImpl(pFormatString));
			cfg.registerJsonValueProcessor(java.util.Date.class, new JsonValueProcessorImpl(pFormatString));
			cfg.registerJsonValueProcessor(java.sql.Date.class, new JsonValueProcessorImpl(pFormatString));
			if (pObject instanceof ArrayList) {
				JSONArray jsonArray = JSONArray.fromObject(pObject, cfg);
				jsonString = jsonArray.toString();
			} else {
				JSONObject jsonObject = JSONObject.fromObject(pObject, cfg);
				jsonString = jsonObject.toString();
			}
		}
		if (log.isInfoEnabled()) {
			log.info("лJSON:\n" + jsonString);
		}
		return jsonString;
	}
	/**
	 * ҳϢѹJSONַ??
	 * @param JSONַ??
	 * @param totalCount
	 * @return غϲַ??
	 */
	public static String encodeJson2PageJson(String jsonString, Integer totalCount) {
		jsonString = "{TOTALCOUNT:" + totalCount + ", ROOT:" + jsonString + "}";
		if (log.isInfoEnabled()) {
			log.info("ϲJSON:\n" + jsonString);
		}
		return jsonString;
	}
	/**
	 * ֱӽListתΪҳ????ҪJsonϸʽ
	 * @param list ????List
	 * @param totalCount ¼
	 * @param pDataFormat ʱڸʽ??nullListʱ??
	 */
	public static final String encodeList2PageJson(List list, Integer totalCount, String dataFormat) {
		String subJsonString = "";
		if (RHUtil.isEmpty(dataFormat)) {
			subJsonString = encodeObject2Json(list);
		} else {
			subJsonString = encodeObject2Json(list, dataFormat);
		}
		String jsonString = "{TOTALCOUNT:" + totalCount + ", ROOT:" + subJsonString + "}";
		return jsonString;
	}
	/**
	 * ϵлΪ????Jsonʽ
	 * @param pObject ϵлĶ??
	 * @param pFormatString ʱʽ??ΪnullΪûʱֶ
	 * @return
	 */
	public static String encodeDto2FormLoadJson(Map pDto, String pFormatString) {
		String jsonString = "";
		String sunJsonString = "";
		if (RHUtil.isEmpty(pFormatString)) {
			sunJsonString = encodeObject2Json(pDto);
		} else {
			sunJsonString = encodeObject2Json(pDto, pFormatString);
		}
		jsonString = "{success:"
				+ (RHUtil.isEmpty(pDto.get("success")) ? "true" : pDto.get("success")) + ",data:"
				+ sunJsonString + "}";
		if (log.isInfoEnabled()) {
			log.info("лJSON:\n" + jsonString);
		}
		return jsonString;
	}
	/**
	 * ??sonΪDTOJava
	 * @param jsonString ????Json
	 * @return dto
	 */
	public static Map parseSingleJson2Map(String jsonString) {
		Map dto = new HashMap();
		if (RHUtil.isEmpty(jsonString)) {
			return dto;
		}
		JSONObject jb = JSONObject.fromObject(jsonString);
		dto = (HashMap) JSONObject.toBean(jb, HashMap.class);
		return dto;
	}
	/**
	 * JsonϸʽתΪList
	 * @param jsonString
	 *            Json,ʽԼ<br>
	 *            {"1"\"{"name":".??,"age":"27"},
	 *            "2":{"name":"??,"age":"72"}}
	 * @return List
	 */
	public static List parseJson2List(String jsonString) {
		List list = new ArrayList();
		JSONObject jbJsonObject = JSONObject.fromObject(jsonString);
		Iterator iterator = jbJsonObject.keySet().iterator();
		while (iterator.hasNext()) {
			Map dto = parseSingleJson2Map(jbJsonObject.getString(iterator.next().toString()));
			list.add(dto);
		}
		return list;
	}
	public static void main(String[] args) {
		String jsonStr = "{\"1\":{\"name\":\".jia\",\"age\":\"27\"}, \"2\":{\"name\":\"FAN\",\"age\":\"72\"}}";
		List list = parseJson2List(jsonStr);
		for (int i=0;i<list.size();i++) {
			Map map = (Map) list.get(i);
			System.out.println(map.get("name"));
			System.out.println(list.get(i));
		}
	}
	
}
