package cn.base.conf;

public class Db extends NodeHome {
	private String userName;
	private String password;
	private String url;
	private String dbName;
	private String driverClassName;
	private int initialSize;
	private int minIdle;
	private int maxIdle;
	private int maxActive;
	private int maxWait;
	private boolean removeAbandoned;
	private int removeAbandonedTimeout;
	private boolean logAbandoned;

	public void fillField() {
		for (int i = 0; i < this.getList().size(); i++) {
			String name = this.getList().get(i).getName();
			String value = this.getList().get(i).getValue();
			if (name.equalsIgnoreCase("userName") == true)
				this.userName = value;
			if (name.equalsIgnoreCase("password") == true)
				this.password = value;
			if (name.equalsIgnoreCase("url") == true)
				this.url = value;
			if (name.equalsIgnoreCase("dbName") == true)
				this.dbName = value;
			if (name.equalsIgnoreCase("driverClassName") == true)
				this.driverClassName = value;

			if (name.equalsIgnoreCase("initialSize") == true)
				this.initialSize = Integer.parseInt(value);
			if (name.equalsIgnoreCase("minIdle") == true)
				this.minIdle = Integer.parseInt(value);
			if (name.equalsIgnoreCase("maxIdle") == true)
				this.maxIdle = Integer.parseInt(value);
			if (name.equalsIgnoreCase("maxActive") == true)
				this.maxActive = Integer.parseInt(value);
			if (name.equalsIgnoreCase("maxWait") == true)
				this.maxWait = Integer.parseInt(value);
            this.removeAbandoned = name.equalsIgnoreCase("removeAbandoned") == true;
			if (name.equalsIgnoreCase("removeAbandonedTimeout") == true)
				this.removeAbandonedTimeout = Integer.parseInt(value);
            this.logAbandoned = name.equalsIgnoreCase("logAbandoned") == true;
		}
	}

	public String getDbName() {
		return dbName;
	}

	public void setDbName(String dbName) {
		this.dbName = dbName;
	}

	public String getUserName() {
		return userName;
	}

	public String getPassword() {
		return password;
	}

	public String getUrl() {
		return url;
	}

	public String getDriverClassName() {
		if (driverClassName == null)
			this.fillField();
		return driverClassName;
	}

	public void setDriverClassName(String driverClassName) {
		this.driverClassName = driverClassName;
	}

	public int getInitialSize() {
		return initialSize;
	}

	public void setInitialSize(int initialSize) {
		this.initialSize = initialSize;
	}

	public int getMinIdle() {
		return minIdle;
	}

	public void setMinIdle(int minIdle) {
		this.minIdle = minIdle;
	}

	public int getMaxIdle() {
		return maxIdle;
	}

	public void setMaxIdle(int maxIdle) {
		this.maxIdle = maxIdle;
	}

	public int getMaxActive() {
		return maxActive;
	}

	public void setMaxActive(int maxActive) {
		this.maxActive = maxActive;
	}

	public int getMaxWait() {
		return maxWait;
	}

	public void setMaxWait(int maxWait) {
		this.maxWait = maxWait;
	}

	public boolean getRemoveAbandoned() {
		return removeAbandoned;
	}

	public void setRemoveAbandoned(boolean removeAbandoned) {
		this.removeAbandoned = removeAbandoned;
	}

	public int getRemoveAbandonedTimeout() {
		return removeAbandonedTimeout;
	}

	public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
		this.removeAbandonedTimeout = removeAbandonedTimeout;
	}

	public boolean getLogAbandoned() {
		return logAbandoned;
	}

	public void setLogAbandoned(boolean logAbandoned) {
		this.logAbandoned = logAbandoned;
	}

}
