/**
 * 
 */
package cn.amq.basis;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.jms.Connection;
import javax.jms.DeliveryMode;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.Topic;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

import com.jtiny.msgthread.JtinyMsgThread;
import com.jtiny.utility.JtinyEvent;
import com.jtiny.utility.Utils;

/**
 * amqҪ
 * @author ThinkPad
 *
 */
public class AmqPublishBasisJob extends JtinyMsgThread{
	 static Logger logger = Logger.getLogger(AmqPublishBasisJob.class);
	 private final List<String> subjectList=new LinkedList<String>();
	 private final Map<String,MessageProducer> messageProducerMap=new HashMap<String,MessageProducer>();
	 private String amqServerUrl=null;
	 
	 private ActiveMQConnectionFactory factory=null;
	 private Connection connection;
	 private Session session;
	 
	 public AmqPublishBasisJob(String amqServerUrl){
		 this.amqServerUrl=amqServerUrl;
	 }

	 private MessageProducer getProducerBySubject(String topicName){
		 MessageProducer ret=messageProducerMap.get(topicName);
		 if(ret!=null)return ret;
		 try {
			 Topic topic=session.createTopic(topicName);
			 ret = session.createProducer(topic);
			 ret.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
			 messageProducerMap.put(topicName, ret);
			 subjectList.add(topicName);
			 logger.info("getProducerBySubject: create new subject! topic="+topicName);
		 } catch (Exception e) {
				logger.error(Utils.getStackTraceAsString(e));
				return null;
		 }
		 return ret;
	 }
	 public boolean isConnected(){
         return factory != null;
	 }
	 public void init(){
		 try {
			 if(factory!=null)return;
			 factory = new ActiveMQConnectionFactory(amqServerUrl);
			 connection = factory.createConnection();
			 session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			 for(int i=0;i<subjectList.size();i++){
				Topic topic=session.createTopic(subjectList.get(i));
				 MessageProducer ret= session.createProducer(topic);
				 ret.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
				 messageProducerMap.put(subjectList.get(i),ret);
			 }
			 connection.start();
		 } catch (Exception e) {
				logger.error(Utils.getStackTraceAsString(e));
			}
	 }
	public  void handleEvent(JtinyEvent tinyEvent)
	{
		switch(tinyEvent.getMsgId())
		{
			case AmqConst.AMQ_SETUP_INIT_EVENT:{
				logger.debug("Receive mesage.type =AMQ_INIT_MSG!");
				JtinyEvent msgEnityTimer=new JtinyEvent(AmqConst.AMQ_SETUP_INIT_EVENT,0,0,null,null,null);
				this.registerTimer(msgEnityTimer, 1000*20*10);
				this.init();
				break;
			}
			case AmqConst.AMQ_PUBLISH_EVENT:{
				String asXml=null;
				try {
					MessageProducer producer=this.getProducerBySubject(tinyEvent.getSfParam());
					AmqBasisEvent amqBasisMsg=(AmqBasisEvent) tinyEvent.getObj();
					amqBasisMsg.writeObjToXml();
					asXml=amqBasisMsg.getOutDocument().asXML();
//					logger.debug("***********************publish event Message:/r/n"+asXml);
//					logger.info("***********************publish event Message:/r/n"+asXml);
//					System.out.println("***********************publish event Message:/r/n"+asXml);
					if(this.isConnected()==false){
						logger.error("Can't connected Amq. So the publish message is discard. the Msessage is \r\n"+asXml);
						break;
					}
					StreamMessage message=session.createStreamMessage();
					message.writeBytes(asXml.getBytes());
					producer.send(message);
				} catch (Exception e) {
					factory=null;
					logger.error(Utils.getStackTraceAsString(e)+" \r\nDiscard Message is :\r\n"+asXml);
				}      
				break;
			}
			default:
				logger.warn("Task Received Unknow Message!");
				break;
		}
	}
}
