var windowId,proName = window.location.pathname.split("/")[1],sysUrl = "http://"+window.location.host+"/"+proName,toEdit;
var records = [];
$(function(){
	initGrid();
	initCountTime();
	initXzNameTree();
	$("#datetimeStart").datetimebox("setValue",$.getTodayStart(0,"00:00:00"));
	$("#datetimeEnd").datetimebox("setValue",$.getTodayEnd("23:59:59"));
});
var toolbar = [
               	      {
          		        text:'ͳб',
          		        iconCls:'icon-search',
          		        handler:function(){
          		        	showList();
          		        }
          	      },
          	      {
          	    	  text:"ͳͼ",
          	    	  iconCls:"icon-search",
          	    	  handler:function(){
          	    		  showGraph();
          	    	  }
          	      },
          		  {
          				text:"",
          				iconCls:"icon-search",
          				handler:function(){
          					doExport();
          				}
          			},
          		  {
          				text:"㹫ʽ",
          				iconCls:"icon-search",
          				handler:function(){
          					showCompute();
          				}
          			}
          	];
//б
function initGrid(){	
	showList();
}

//ͳʱ

function initCountTime(){
		var flag=false;
		var date=new Date();
		var year=date.getFullYear();
		var month=date.getMonth()+1;
		var str=year+""+month+"";
		var result=[12,11,10,9,8,7,6,5,4,3,2,1];
		result=result.filter(function(value){
			if(month==value){
				flag=true;
			}
			if(flag){
				if(value<10){
					return "0"+value;
				}else{
					return ""+value;
				}
			}
		});
		$.each(result,function(i,v){
			result[i]=year+""+result[i]+"";
		});
		result.unshift("Զʱ");
		$('#countTime').combobox({  
			data : $.obj2ary(result),  
			textField:1,  
			valueField:0,
			panelWidth:148,
			value:str,
			onSelect:function(record){
				var value=record[1].trim();
				if(value=='Զʱ'){
					$("#controlDate").show();
				}else{
					$("#controlDate").hide();
				}
			}
		});
}



//ѯ
function getQueryParams(){
	var sParam = {};
	
	sParam.page = 1;
	sParam.rows = 1000;
	sParam.areanum = $('#xzmc').val();
	sParam.order = "order by areanum desc ";
	var month = $("#countTime").combobox("getText");
	if("Զʱ"==month){
		sParam.countMonth = ""//" and countMonth>='" +$("#datetimeStart").datetimebox("getValue").substing(0,10)+"' and countMonth<='"+$("#datetimeEnd").datetimebox("getValue").substing(0,10)+"' ";	
//		sParam.tableparam = " and countMonth>='" +$("#datetimeStart").datetimebox("getValue").substing(0,10)+"' and countMonth<='"+$("#datetimeEnd").datetimebox("getValue").substing(0,10)+"' ";	
	}else{
		sParam.countMonth = month.replace("","-").replace("","");
	}
	return sParam;
}
//бչʾ
function showList(){
	$("#searchGridListDiv").show();
	$("#searchGridPicDiv").hide();
	displayType = "list";
//	$('#searchGridList').datagrid({ toolbar : toolbar})
	$.ajax({
		type : 'post',
		dateType : 'json',
		url : 'ywcountlalcollectAction!listYwcountlalcollectByPage.do',
		data : getQueryParams(),
		success : function(res){
			renderTable(res);
		}
	});
}


function showGraph(){
	$("#searchGridPicDiv").show();
	$("#searchGridListDiv").hide();
	$.ajax({
		type : 'post',
		dateType : 'json',
		url : 'ywcountlalcollectAction!listYwcountlalcollectByPage.do',
		data : getQueryParams(),
		success : function(res){
			if(res && res.total>0){
				var x = [];
				var noJWnum = [];
				var invalidJWnum = [];
				var defectJWnum = [];
				var completeJWnum = [];
				var rows = res.rows;
				for(var i in rows){
					x.push(rows[i].areaname);
					noJWnum.push(transStr2Int(rows[i].nolalcount));
					invalidJWnum.push(transStr2Int(rows[i].invalidlalcount));
					defectJWnum.push(transStr2Int(rows[i].laldefectcount));
					completeJWnum.push(transStr2Int(rows[i].lalcompletecount));
				}
				var data={
						"title":"γȲɼͳ",
						xAxis: x,//["","NVR","","Ӧϵͳ"],
						"legend":[
						          {"name":"޾γ", "data":noJWnum,"color":"yellow"},
						          {"name":"Чγ","data":invalidJWnum,"color":"blue"},
						          {"name":"γȱʧ","data":defectJWnum,"color":"gray"},
						          {"name":"γ","data":completeJWnum,"color":"green"},
						          ]};
//				$('#searchGridStatics').datagrid({ toolbar : toolbar});
				EchartsBase.barChart({
					id:"searchGridGraph",
					data:data
				});
			}
		}
	});
	
}


function showJw(id){
	var url = top.sysUrl+"/yw/countalarm/jw/showJw.jsp";
	windowid = top.$.createWin({
		 title	: 	'޾γȼصб',
		 width  :  '720',
		 height :  '400',
		 data:id,
		 url	:  url
	 });
}

function showCompute(id){
	var url = top.sysUrl+"/yw/countalarm/jw/showCompute.jsp";
	windowid = top.$.createWin({
		title	: 	'㹫ʽ',
		width  :  '400',
		height :  '200',
		data:id,
		url	:  url
	});
}

function initXzNameTree(){
	$.ajax({
		 type:'post',
		 async:false,
		 dataType : 'json',
		 url:'menuConfigAction!query_Ptxzs.do'
	 }).done(function(data){
		if(data!=null && data.length>0) {
			$.each(data, function (i, o) {
				o.state = 'closed';
				o.treeId = o.xzbh;
				o.name = o.xzmc;
				o.treeType = "xz";
				o.id = o.xzbh;
				o.pid = o.sjxzbh;
				o.start = 0; //iconCls
			})
		}
			var xzfz = {};
	 		xzfz.treeType 	= "xz";
			xzfz.id		= "-1";
			xzfz.pid		= "-1";
			xzfz.start 	= 0; //iconCls
		 	xzfz.xzbh = "-1";
		 	xzfz.xzmc = "ȫ";
		 	xzfz.state = "open";
		 	xzfz.treeId = "-1";
		 	xzfz.sjxzbh = "-1";
		 	xzfz.name = "ȫ";
			data.push(xzfz);
				 $('#xzmc').combotree({
				        checkbox:false,
				    	border:false,
				    	parentField:"pid",  
				    	textFiled:"name",  
				    	idFiled:"id",
				    	panelWidth:148,
				    	data:data,
						onLoadSuccess:function(node,data){
						},
						onClick: function(node){
						}
				});
	 });
}
function renderTable(res){
	var table = '';
	if(res && res.total>0){
		var rows = res.rows;
		$("#timeTJ").text(rows[0].updateTime);
		var monitorSum = 0,invalidlalSum = 0,laldefectSum = 0,lalcompleteSum=0,nolalSum=0;
		for (var i=0 ; i<rows.length; i++) {
			monitorSum += parseInt(rows[i].monitortotal);
			nolalSum += parseInt(rows[i].nolalcount);
			invalidlalSum += parseInt(rows[i].invalidlalcount);
			laldefectSum += parseInt(rows[i].laldefectcount);
			lalcompleteSum += parseInt(rows[i].lalcompletecount);
			table += '<tr>\
				<td>'+(i+1)+'</td>\
				<td>'+rows[i].areaname+'</td>\
				<td>'+rows[i].monitortotal+'</td>\
				<td>'+rows[i].nolalcount+'</td>\
				<td>'+rows[i].laldefectcount+'</td>\
				<td>'+rows[i].invalidlalcount+'</td>\
				<td>'+rows[i].lalcompletecount+'</td>\
				<td>'+rows[i].lalcollectionrate+'</td>\
			<tr>'
		}
		table += '<tr>\
		<td colspan="2">ܼ</td>\
		<td>'+monitorSum+'</td>\
		<td>'+nolalSum+'</td>\
		<td>'+laldefectSum+'</td>\
		<td>'+invalidlalSum+'</td>\
		<td>'+lalcompleteSum+'</td>\
		<td>'+(lalcompleteSum*100.0/monitorSum).toFixed(2)+'%</td>\
		<tr>'
	}else{
		table += '<tr> <td colspan="7">δѯ</td> <tr>';
	}
	 

	$("#searchGridList").html(table);
}
function transStr2Int(str){
	if(str){
		return parseInt(str);
	}else{
		return 0;
	}
}
//
function doExport(){
	var model = getQueryParams();
	$.ajax({
		type : 'post',
		dateType : 'json',
		url : 'ywcountlalcollectAction!count_Ywcountlalcollect.do',
		data : getQueryParams(),
		success : function(res){
			if(res){
				countExport(res);
			}else{
				$.showMsg("ûв鵽ļ¼");
			}
		}
	});
}
// 
function countExport(totalSize) {
	var limit = 5000;
	if (totalSize > 5000) {
		top.$.dlg.confirm('¼֧ǰ5000,ȷҪ¼ExcelΪ?',function(){ 
			execExport();
		});		
	} else {
		top.$.dlg.confirm('ȷϵ?',function(){ 
			execExport();
		})
	}
}
// ų́
function execExport() {
	var model = JSON.stringify(getQueryParams());
    document.excelForm.action = 'ywcountlalcollectAction!exp_Ywcountlalcollect.do?downParam=' + encodeURIComponent(model);
    document.excelForm.submit();
}