package cn.yw.alarm.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.yw.detector.service.DetectorService;
import cn.yw.nhyw.nhywjtledydpgl.service.NhywjtledydpglService;
import cn.yw.nhyw.nhywjtxhdgl.service.NhywjtxhdglService;
import cn.yw.zxld.service.ZxldService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.conf.ModuleConfFactory;
import cn.base.excel.ExportExcel;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarm.service.YwalarmeventinfoService;
import cn.yw.machinemanage.service.YwmachinecurrentstateService;
import cn.yw.video.videostate.service.YwvideocurrentstateService;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywalarmeventinfoAction")
public class YwalarmeventinfoAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(YwalarmeventinfoAction.class);

    @Autowired
    private YwalarmeventinfoService service;
    @Autowired
    private YwvideocurrentstateService ywvideocurrentstateService;
    @Autowired
    private YwmachinecurrentstateService ywmachinecurrentstateService;

    @Autowired
    private NhywjtledydpglService nhywjtledydpglService;

    @Autowired
    private NhywjtxhdglService nhywjtxhdglService;

    @Autowired
    private DetectorService detectorService;

    @Autowired
    private ZxldService zxldService;

    /**
     * ѯҳδĸ澯Ϣ
     * ֤ûȨޣȨΪƽ̨Աûӵв鿴澯Ȩʾ¸澯ϢбʾȨ޷Χڵĸ澯Ϣб
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listYwalarmeventinfoByPage")
    public void listYwalarmeventinfoByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //֤ûȨ
            map.put("yhbh", ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhbh());
            Map m = this.service.checkQx(map);
            String sfgly = m.get("sfgly") + ""; //ǷԱ
            String seealarmauthory = m.get("seealarmauthory") + "";    //鿴澯Ȩ
            //жǷԱǷ鿴澯ȨޣȨֱӷ
            if ("1".equals(sfgly)) {  //ûΪԱbmbhֵֶѯи澯

            } else if ("1".equals(seealarmauthory)) { //ΪԱв鿴澯Ȩޣȡûڲű
                String bmbh = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getBmbh();
                map.put("bmbh", bmbh);
                map.put("departid", 1);
            } else {  //ûȨֱӷ
                Struts2Utils.renderJson(null);
                return;
            }
            // ǰ˲ѯ
            String deviceChoose = String.valueOf(map.get("deviceChoose"));
            if (!("null".equals(deviceChoose) || StringUtils.isEmpty(deviceChoose))) {
                String[] devices = deviceChoose.split(",");
                List videoDevices = new ArrayList();
                List ortherDevices = new ArrayList();
                for (int i = 0; i < devices.length; i++) {
                    if (devices[i].indexOf("-") == -1) {
                        ortherDevices.add(devices[i]);
                    } else {
                        videoDevices.add(devices[i]);
                    }
                }
                map.put("videoDevices", videoDevices);
                map.put("ortherDevices", ortherDevices);
            }

            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            Struts2Utils.renderJson(this.service.listYwalarmeventinfoByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-listYwalarmeventinfoByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "count_Ywalarmeventinfo")
    public void count_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.count_Ywalarmeventinfo(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-count_Ywalarmeventinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ͼͳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "statisticPieChart")
    public void statisticPieChart() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.statisticPieChart(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-statisticPieChart-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ͳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "alarmStatisticsLine")
    public void alarmStatisticsLine() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            String deviceChoose = String.valueOf(map.get("deviceChoose"));
            if ("null".equals(deviceChoose) || StringUtils.isNotEmpty(deviceChoose)) {
                String[] devices = map.get("deviceChoose").toString().split(",");
                List videoDevices = new ArrayList();
                List ortherDevices = new ArrayList();
                for (int i = 0; i < devices.length; i++) {
                    if (devices[i].indexOf("-") == -1) {
                        ortherDevices.add(devices[i]);
                    } else {
                        videoDevices.add(devices[i]);
                    }
                }
                map.put("videoDevices", videoDevices);
                map.put("ortherDevices", ortherDevices);
            }
            Struts2Utils.renderJson(this.service.alarmStatisticsLine(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-statisticPieChart-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ Ywalarmeventinfo
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_Ywalarmeventinfo")
    public void query_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.query_Ywalarmeventinfo(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-query_Ywalarmeventinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯYwalarmeventinfo
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_YwalarmeventinfoDetail")
    public void query_YwalarmeventinfoDetail() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            Integer sfgly = ptyh.getSfgly();
            if (sfgly != 1) {
                map.put("bmbh", ptyh.getBmbh()); // ȡű
            }
            map.put("start", 0);
            map.put("limit", 10);
            Struts2Utils.renderJson(this.service.query_YwalarmeventinfoDetail(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-query_YwalarmeventinfoDetail-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ һYwalarmeventinfo
     */
    @OperateType(value = LogConstants.LOG_GET, info = "get_Ywalarmeventinfo")
    public void get_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(this.service.get_Ywalarmeventinfo(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoActionquery_Ywalarmeventinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯϢб
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_Ywalarmlist")
    public void query_Ywalarmlist() {
        Map map = Struts2Utils.getRequestParameterMap();
        System.out.println("map" + map);
        try {
            Struts2Utils.renderJson(this.service.query_Ywalarmlist(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoActionquery_Ywalarmlist-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "deleteYwalarmeventinfo")
    public void delete_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Ywalarmeventinfo(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-delete_Ywalarmeventinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Ywalarmeventinfo")
    public void insert_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("alarmeventid"))) {
                map.put("alarmeventid", StringUtil.getUUID());
                String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
                map.put("createaccount", username);
                map.put("createtime", DateUtil.currentDateTime());
            }
            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Ywalarmeventinfo(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    service.insert_Ywalarmeventinfo(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                service.insert_Ywalarmeventinfo(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-insert_Ywalarmeventinfo()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Ywalarmeventinfo")
    public void update_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Ywalarmeventinfo(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    int result = service.update_Ywalarmeventinfo(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                int result = service.update_Ywalarmeventinfo(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-update_Ywalarmeventinfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_delete_Ywalarmeventinfo")
    public void batch_delete_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Map m = new HashMap();
            m.put("keyword", map.get("keyword").toString());
            int result = service.batch_delete_Ywalarmeventinfo(m);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-batch_delete_Ywalarmeventinfo-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * excel
     */
    @OperateType(value = LogConstants.LOG_EXPORT, info = "exp_Ywalarmeventinfo")
    public void exp_Ywalarmeventinfo() {
        try {
            Map map = Struts2Utils.getRequestParameterMap();
            Map queryMap = JSONObject.fromObject(map.get("downParam"));
            queryMap.put("start", 0);
            queryMap.put("limit", 5000);
            List<Map> sList = service.query_Ywalarmeventinfo(queryMap);
            List<Map> expList = new ArrayList<Map>();
            String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
            List<String> headerList = new ArrayList<String>();
            headerList.add("澯id");
            headerList.add("澯");
            headerList.add("澯豸");
            headerList.add("澯豸");
            headerList.add("澯豸");
            headerList.add("ͨ");
            headerList.add("澯");
            headerList.add("澯ؼ");
            headerList.add("澯ԭ");
            headerList.add("澯ʱ");
            headerList.add("");
            headerList.add("״̬");
            headerList.add("ʱ");
            for (Map m : sList) {
                Map exportMap = new HashMap();
                exportMap.put("澯id", m.get("alarmruleid"));
                exportMap.put("澯", m.get("alarmrulename"));
                exportMap.put("澯豸", m.get("alarmdevicetypename"));
                exportMap.put("澯豸", m.get("alarmdevicename"));
                exportMap.put("澯豸", m.get("alarmdeviceid"));
                exportMap.put("ͨ", m.get("channelnum"));
                exportMap.put("澯", m.get("alarmtypename"));
                exportMap.put("澯ؼ", m.get("alarmgradename"));
                exportMap.put("澯ԭ", m.get("alarmreason"));
                exportMap.put("澯ʱ", m.get("alarmtime"));
                exportMap.put("", m.get("falutdescription"));
                // ״̬ת
                String processstatus = m.get("processstatus").toString();
                String processstatusStr = "";
                if (processstatus == "900") {
                    processstatusStr = "";
                } else if (processstatus == "901") {
                    processstatusStr = "ϱ-";
                } else if (processstatus == "902") {
                    processstatusStr = "ά--";
                } else if (processstatus == "904") {
                    processstatusStr = "";
                } else if (processstatus == "905") {
                    processstatusStr = "ȡ";
                } else if (processstatus == "906") {
                    processstatusStr = "ѷȷ";
                } else if (processstatus == "907") {
                    processstatusStr = "ѷ˲ͨ";
                } else if (processstatus == "908") {
                    processstatusStr = "";
                } else if (processstatus == "909") {
                    processstatusStr = "ͨ";
                } else if (processstatus == "910") {
                    processstatusStr = "˲ͨ";
                } else if (processstatus == "913") {
                    processstatusStr = "άȷϲͨ";
                } else if (processstatus == "903") {
                    processstatusStr = "";
                } else if (processstatus == "912") {
                    processstatusStr = "Ѻ";
                } else if (processstatus == "911") {
                    processstatusStr = "ѷȷϴ";
                } else if (processstatus == "914") {
                    processstatusStr = "澯";
                } else if (processstatus == "915") {
                    processstatusStr = "";
                } else if (processstatus == "915") {
                    processstatusStr = "ȷ";
                } else if (processstatus == "916") {
                    processstatusStr = "ȷϲͨ";
                }
                exportMap.put("״̬", processstatusStr);
                exportMap.put("ʱ", m.get("processtime"));
//				exportMap.put("yhzh", m.get("yhzh"));
//				exportMap.put("yhzh", username);
                expList.add(exportMap);
            }
            SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
            String dateTime = formart.format(new Date());
            Map params = new HashMap();
            params.put("fileName", "ά澯Ϣ-" + dateTime);
            params.put("sheetName", "ά澯Ϣ");
            params.put("header", "ά澯Ϣ");
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
            new ExportExcel().exportCommExcel(params, headerList, new ArrayList(), expList, Struts2Utils.getResponse());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-exp_Ywalarmeventinfo-error:" + e);

        }
    }

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywalarmeventinfo")
	public void exp_Ywalarmeventinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywalarmeventinfo(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά澯Ϣ-"+dateTime);
			params.put("sheetName", "ά澯Ϣ");
			params.put("header", "ά澯Ϣ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmeventinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/

    /**
     * Excel
     */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywalarmeventinfo")
	public String imp_Ywalarmeventinfo(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwalarmeventinfoAction-imp_Ywalarmeventinfo-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/

    // Ը澯

    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "ignore_Ywalarmeventinfo")
    public void ignore_Ywalarmeventinfo() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            PtyhBean ptyh = (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
            String username = ptyh.getYhzh();
            int hldm = 912;

            String alarmeventid = (String) map.get("alarmeventid");
            String alarmdevicetype = (String) map.get("alarmdevicetype");
            String alarmdeviceid = (String) map.get("alarmdeviceid");
            String channelnum = (String) map.get("channelnum");

            map.put("XGTJalarmeventid", alarmeventid);
            map.put("processstatus", hldm);                // Ѻ
            map.put("processtime", DateUtil.currentDateTime());
            map.put("processaccount", username);
            map.put("unalarmtime", DateUtil.currentDateTime());
            map.put("completetime", DateUtil.currentDateTime());
            map.put("completeaccount", username);
            map.put("modifyaccount", username);
            map.put("modifytime", DateUtil.currentDateTime());
            //  ywalarmeventinfo 
            int result = service.update_Ywalarmeventinfo(map);

            //  ywvideocurrentstate      ywmachinecurrentstate
            if ("1".equals(alarmdevicetype)) {                // 豸
                Map videoMap = new HashMap();
                videoMap.put("XGTJvideonum", alarmdeviceid);
                videoMap.put("XGTJchannelnum", channelnum);
                videoMap.put("repairstate", hldm);
                ywvideocurrentstateService.update_Ywvideocurrentstate(videoMap);
            } else if ("2".equals(alarmdevicetype)) {            // 豸
                Map machineMap = new HashMap();
                machineMap.put("XGTJmachineid", alarmdeviceid);
                machineMap.put("repairstate", hldm);
                ywmachinecurrentstateService.update_Ywmachinecurrentstate(machineMap);
            } else if ("3".equals(alarmdevicetype)) {            // źŵ
                Map machineMap = new HashMap();
                machineMap.put("XGTJxh", alarmdeviceid);
                machineMap.put("repairstate", hldm);
                nhywjtxhdglService.update_NhyxhdCurrentState(machineMap);
            } else if ("4".equals(alarmdevicetype)) {            // յ
                Map machineMap = new HashMap();
                machineMap.put("XGTJxh", alarmdeviceid);
                machineMap.put("repairstate", hldm);
                nhywjtledydpglService.update_NhywledydpCurrentState(machineMap);
            } else if ("10".equals(alarmdevicetype) || "11".equals(alarmdevicetype)) {            // "10"://ش,"11"://΢
                Map machineMap = new HashMap();
                if ("10".equals(alarmdevicetype)) {
                    machineMap.put("detectortype", "GVD");
                } else if ("11".equals(alarmdevicetype)) {
                    machineMap.put("detectortype", "SMARTSENSOR");
                }
                machineMap.put("XGTJid", alarmdeviceid);
                machineMap.put("repairstate", hldm);
                detectorService.update_DetectorCurrentState(machineMap);
            } else if ("12".equals(alarmdevicetype)) {            // ״
                Map machineMap = new HashMap();
                machineMap.put("XGTJxh", alarmdeviceid);
                machineMap.put("repairstate", hldm);
                zxldService.update_ZxldCurrentState(machineMap);
            }
            Struts2Utils.renderJson(Constants.SUCCESS);

        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-update_Ywalarmeventinfo-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    // ҳعϴͳ
    @OperateType(value = LogConstants.LOG_DELETE, info = "count_HomepageFaultCount")
    public void count_HomepageFaultCount() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Struts2Utils.renderJson(service.count_HomepageFaultCount(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-count_HomepageFaultCount-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ȡѲǷ񵯴Ƿ澯Ϣ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "getVideoTaskAlarmConfig")
    public void getVideoTaskAlarmConfig() {
        try {
            Struts2Utils.renderJson(ModuleConfFactory.getInstance().getVideoTaskAlarm());
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-getVideoTaskAlarmConfig-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ֶһ澯Ϣ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "insertVideoTaskAlarmConfig")
    public void insertVideoTaskAlarmConfig() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            map.put("yhbh", ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhbh());
            Map m = this.service.checkQx(map);
            String sfgly = m.get("sfgly") + ""; //ǷԱ
            String seealarmauthory = m.get("seealarmauthory") + "";    //鿴澯Ȩ
            //жǷԱǷ鿴澯ȨޣȨֱӷ
            if ("1".equals(sfgly)) {  //ûΪԱbmbhֵֶѯи澯

            } else if ("1".equals(seealarmauthory)) { //ΪԱв鿴澯Ȩޣȡûڲű
                String bmbh = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getBmbh();
                map.put("bmbh", bmbh);
            } else {  //ûȨֱӷ
                Struts2Utils.renderJson(null);
                return;
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("YwalarmeventinfoAction-count_HomepageFaultCount-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }
}
