package cn.im.xtyh.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.im.xtyh.dao.XtpzyhDao;

@Service("xtpzyhService")
public class XtpzyhService extends BaseService {
	
	private static final Log log = LogFactory.getLog(XtpzyhService.class);
	
	@Autowired
	private XtpzyhDao xtpzyhDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Xtpzyh(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		xtpzyhDao.insert_Xtpzyh(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Xtpzyh(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return xtpzyhDao.update_Xtpzyh(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Xtpzyh(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return xtpzyhDao.delete_Xtpzyh(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Xtpzyh(Map map) throws SQLException{
		return xtpzyhDao.batch_delete_Xtpzyh(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Xtpzyh(Map map) throws SQLException{
		return xtpzyhDao.count_Xtpzyh(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Xtpzyh(Map map) throws SQLException{
		return xtpzyhDao.query_Xtpzyh(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Xtpzyh(Map map) throws SQLException{
		return xtpzyhDao.get_Xtpzyh(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportXtpzyh(Map map) throws SQLException{
		return this.listXtpzyhByPage(map);
	}
	
	/**
	 * Xtpzyh ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listXtpzyhByPage(Map map) throws SQLException {
		List<Map> list = xtpzyhDao.query_Xtpzyh(map);
		Integer totalCount = xtpzyhDao.count_Xtpzyh(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
