package cn.im.trafficplan.service;

 import cn.im.trafficplan.dao.TrafficplanalarmdeviceDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("trafficplanalarmdeviceService")
public class TrafficplanalarmdeviceService extends BaseService {
	
	private static final Log log = LogFactory.getLog(TrafficplanalarmdeviceService.class);
	
	@Autowired
	private TrafficplanalarmdeviceDao trafficplanalarmdeviceDao;
	
	/**
	 * ¼
	 */
	public void insert_Trafficplanalarmdevice(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		trafficplanalarmdeviceDao.insert_Trafficplanalarmdevice(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Trafficplanalarmdevice(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return trafficplanalarmdeviceDao.update_Trafficplanalarmdevice(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Trafficplanalarmdevice(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return trafficplanalarmdeviceDao.delete_Trafficplanalarmdevice(map);
	}
	
	/**
	 * planIDɾ¼
	 */
	public Integer delete_TrafficplanalarmdeviceByPlanID(String str) throws SQLException{
		if(str==null || str ==""){
			throw new SQLException("ɾޣ");
		}
		return trafficplanalarmdeviceDao.delete_TrafficplanalarmdeviceByPlanID(str);
	}

	/**
	 * Trafficplanalarmdevice ҳ
	 */
	public Map listTrafficplanalarmdeviceByPage(Map map) throws SQLException {
		List<Map> list = trafficplanalarmdeviceDao.query_Trafficplanalarmdevice(map);
		Integer totalCount = trafficplanalarmdeviceDao.count_Trafficplanalarmdevice(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
