package cn.im.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;
import com.ibatis.sqlmap.client.SqlMapClient;

@Repository("operationDao")
public class OperationDao extends SqlMapClientDaoSupport{
	
	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public void initSqlMapClient(){  
    	super.setSqlMapClient(sqlMapClient);      
    }
	
	
	// ѯ쳣ķ
	public List<Map> getAbnormalServers(Map obj) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getAbnormalServers", obj);
	}
	
	// ѯ쳣
	public Integer getAbnormalCameraCount(Map obj) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("getAbnormalCameraCount", obj);
	}
	
	// ѯķ
	public List<Map> getNormalServers(Map obj) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getNormalServers", obj);
	}
	
	// ѯ
	public Integer getNormalCameraCount(Map obj) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("getNormalCameraCount", obj);
	}
	
	// ѯ쳣Ϣ
	public List<Map> getAbnormalCamera(Map obj) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getAbnormalCamera", obj);
	}
	
	// ѯϢ
	public List<Map> getNormalCamera(Map obj) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getNormalCamera", obj);
	}

	//  id ѯĳһϸϢ
	public Map getServerInfoById(Map obj) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("getServerInfoById", obj);
	}
	
	//  id ѯһ¼
	public Map getCaVideoSourceById(Map obj) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("getCaVideoSourceById", obj);
	}

	// ѯƵ 
	public List<Map> query_CaVideoSource(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_CaVideoSource", map);
	}
	// ѯƵ 
	public Integer query_CaVideoSourceCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("query_CaVideoSourceCount", map);
	}
	
	// ѯ ڵ·״̬
	public List<Map> getNodeServerStatus(Map obj) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getNodeServerStatus", obj);
	}
	
	// ѯ ڵ·״̬ 
	public Integer getNodeServerStatusCount(Map obj) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("getNodeServerStatusCount", obj);
	}
	
}
