package cn.base.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.base.bean.BeanHelper;

@SuppressWarnings("serial")
public class ShowImagesServlet extends HttpServlet {
	public void doGet(HttpServletRequest request, HttpServletResponse response) {
		doPost(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response) {
		String fullPath;
		String localPath = request.getParameter("imagePath");
		String basePath = BeanHelper.getModuleConfFactory().getScatter().getBasePath(); //private.xmlжȡļ·
		fullPath = basePath + localPath; //ͼƬȫ·
		
		FileInputStream fis = null;
		OutputStream toClient = null;
		
		try {
			fis = new FileInputStream(fullPath);
			int i = fis.available(); // õļС
			byte[] data = new byte[i];
			fis.read(data); // 
			fis.close();
			response.setContentType("image/*"); // ÷صļ
			toClient = response.getOutputStream(); // õͻݵĶ
			toClient.write(data); // 
			toClient.close();
		}catch(Exception e) {
			e.printStackTrace();
		}finally {
			//try;쳣رIO
			closeAllIO(toClient, fis);
		}
	}
	
	//رIO
	private void closeAllIO(OutputStream toClient,FileInputStream fis) {
		try {
			if(toClient != null)
				toClient.close();
			if(fis != null) 
				fis.close();
		}catch(IOException e) {
			//iLog.error("IOرʧܣ"+e);
		}
	}
}

