package cn.amq.traffic;

import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.TrafficEventLinkageActionHolder;
import cn.base.bean.BeanHelper;
import cn.base.util.DateUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.im.trafficalarm.model.TrafficdevicemessagelogBean;
import cn.im.trafficlinkage.model.TrafficdevicecurrstateBean;
import cn.im.trafficlinkage.model.TrafficdevicehisstateBean;

/**
 * 豸AMQservice
 * ڷ豸AMQ
 * */
public class AmqTrafficEventLinkageActionService {

	static Logger logger = Logger.getLogger(AmqTrafficEventLinkageActionService.class);
	
	/**
	 *    豸  Ϣ AMQ
	 * @param eventId  ¹
	 * @param alarmCode ¹ͱ룬1ͨ¹ʣ6ͨӵ£30(Ƿ)31˴(/ǻ)32Ƿͣ(쳣ͣʻ)5·(·쳣)33쳣ʻ34ᴩ·棻35ʻ·棻36ڻ֣37ܼȹͣ38˺ᴩ·( /ǻᴩ·)39·ϰ99¼
	 * @param deviceType 豸ֶͣΣ1鱨壻2ͨյ
	 * @param deviceId 豸ID豸id÷ֺŸ;Led鱨壺TrafficLedDevice;ͨյƣTrafficLightDevice
	 * @param deviceInstruction 豸ָLed鱨ָ鱨ʾ֡ͨյָ1ɫ0ơ
	 * */
	public void publishTrafficEventLinkageAction(String eventId,String alarmCode,String deviceType,String deviceId,String deviceInstruction) {
		TrafficEventLinkageActionHolder action = new TrafficEventLinkageActionHolder();
		//TrafficEventLinkageAction action = new TrafficEventLinkageAction();
		action.setEventId(eventId);   //¹
		action.setAlarmCode(alarmCode);  //¹ͱ룬1ͨ¹ʣ2Ȼֺ34ΥΪ5·٣6ͨӵ£7ɢ䣻20¼99¼10ָ
		action.setDeviceType(deviceType); //豸ֶͣΣ1鱨壻2ͨյơ
		action.setDeviceId(deviceId);  //豸ID豸id÷ֺŸ;Led鱨壺TrafficLedDevice;ͨյƣTrafficLightDevice
		action.setDeviceInstruction(deviceInstruction); //豸ָLed鱨ָ鱨ʾ֡ͨյָ1ɫ0ơ
		action.setCreateAppName("trafficLinkage");   //
		action.setCreateTime(DateUtil.getDateTimeStr(new java.util.Date()));  //ʱ
		//holder.getList().add(action);
		//System.out.println("豸amq==¼id="+eventId+"¹="+deviceType+"豸="+deviceType+"豸id="+deviceId+"ָ="+deviceInstruction);
		BeanHelper.getCacheExecStateDataService().setCacheExecStateDataMap(deviceId+"-"+deviceType, deviceInstruction);
		AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventLinkageAction);
	}
	
	/**
	 *    豸  Ϣ AMQͬʱ豸ǰ״̬ͨ豸ʷ״̬ͨ豸־
	 * @param eventId  ¹
	 * @param alarmCode ¹ͱ룬1ͨ¹ʣ2Ȼֺ34ΥΪ5·٣6ͨӵ£7ɢ䣻20¼99¼10ָ
	 * @param deviceType 豸ֶͣΣ1-鱨壻2-ͨźŵƣ3-ǽ 4-ƽ̨ͨţ5-6-ⱨ7-֪ͨ8-ͨ9ƣ11-ָʾ99-Ԥ
	 * @param deviceId 豸ID豸id÷ֺŸ;Led鱨壺TrafficLedDevice;ͨյƣTrafficLightDevice
	 * @param deviceInstruction 豸ָLed鱨ָ鱨ʾ֡ͨյָ1ɫ0ơ
	 * @param operationType ͣ룬1-ԤִУ2-˹༭3-˹4-ʼԤ
	 * @param operationId Դ
	 * @param operationId CreateAccount ˣΪģʽֱΪ˳ִлִ
	 * return msg 0豸AMQʧܣ1:豸AMQͳɹͨ豸ǰ״̬־ʧܣ2:豸AMQͳɹͨ豸ǰ״̬³ɹ־дʧܣ3AMQͳɹ־дɹ
	 * */
	public String publishTrafficEventLinkageAction(String eventId,String alarmCode,String deviceType,String deviceId,String deviceInstruction,String operationType,String operationId,String CreateAccount)  {
		String msg = "3";
		String errorMsg = "";
		//step1豸AMQ
		try{
			TrafficEventLinkageActionHolder action = new TrafficEventLinkageActionHolder();
			//TrafficEventLinkageAction action = new TrafficEventLinkageAction();
			action.setEventId(eventId);   //¹
			action.setAlarmCode(alarmCode);  //¹ͱ룬1ͨ¹ʣ2Ȼֺ34ΥΪ5·٣6ͨӵ£7ɢ䣻20¼99¼100˹ҳ༭10ָ
			action.setDeviceType(deviceType); //豸ֶͣΣ1鱨壻2ͨյơ
			action.setDeviceId(deviceId);  //豸ID豸id÷ֺŸ;Led鱨壺TrafficLedDevice;ͨյƣTrafficLightDevice
			action.setDeviceInstruction(deviceInstruction); //豸ָLed鱨ָ鱨ʾ֡ͨյָ1ɫ0ơ
			action.setCreateAppName(CreateAccount);   //
			action.setCreateTime(DateUtil.getDateTimeStr(new java.util.Date()));  //ʱ
			//holder.getList().add(action);
			logger.debug("******AMQϢ******豸AMQΪ¼ţ"+eventId+"豸Ϊ" + deviceType + "豸ţ"+deviceId+"ִΪ"+deviceInstruction);
			BeanHelper.getCacheExecStateDataService().setCacheExecStateDataMap(deviceId+"-"+deviceType, deviceInstruction);
			AmqMainPoint.publishJob.publishGeneralEvent(action, AmqConst.AMQ_SUBJECT_trafficEventLinkageAction);//豸AMQϢ
		}catch(Exception e){
			errorMsg = "͡豸AMQ쳣豸δɹ";
			msg = "0";  //0豸AMQʧ
			logger.error("AmqTrafficEventLinkageActionService-publishTrafficEventLinkageAction error:" + msg);
			logger.debug("******AMQϢerror******豸AMQΪ¼ţ"+eventId+"豸Ϊ" + deviceType + "豸ţ"+deviceId+"ִΪ"+deviceInstruction);
			e.printStackTrace();
			//return msg;
		}
		//step2AMQͳɹڲͨ豸ǰ״̬ʷ״̬
		msg = this.operateTrafficCurrState(msg,deviceId,deviceInstruction,deviceType,operationType,operationId,alarmCode);
		
		//step3Ӳͨ豸Ϣ־
		try{
			TrafficdevicemessagelogBean logbean  = new TrafficdevicemessagelogBean();	
			logbean.setLogId(StringUtil.getUUID());
			logbean.setMessageType("4");   //Ϣͣ룬1-WSգ2-WSͣ3-AMQգ4-AMQ
			logbean.setDeviceType(deviceType);
			logbean.setDeviceId(deviceId);
			logbean.setMessageSubject("subject.trafficEventLinkageAction");
			logbean.setMessageContent(deviceInstruction);
			logbean.setSendTime(DateUtil.getDateTimeStr(new java.util.Date()));
			logbean.setSendState(msg);//Ϣָ״̬룻0豸AMQʧܣ1:豸AMQͳɹͨ豸ǰ״̬־ʧܣ2:豸AMQͳɹͨ豸ǰ״̬³ɹ־дʧܣ3AMQͳɹ־дɹ
			logbean.setOperationType(operationType);
			logbean.setOperationId(operationId);
			logbean.setCreateAccount("AMQ");
			logbean.setCreateTime(DateUtil.getDateTimeStr(new java.util.Date()));
			logbean.setModifyAccount("AMQ");
			logbean.setModifyTime(DateUtil.getDateTimeStr(new java.util.Date()));
			BeanHelper.getTrafficDeviceMessageLogDao().insert_TrafficDeviceMessageLog(logbean);
		}catch(Exception e){
			errorMsg = "͡豸AMQ쳣豸ͳɹ־дʧܣ";
			if("3".equals(msg) || "1".equals(msg)){
				msg = "2";  //0豸AMQʧܣ1:豸AMQͳɹͨ豸ǰ״̬־ʧܣ2:豸AMQͳɹͨ豸ǰ״̬³ɹ־дʧܣ3AMQͳɹ־дɹ
			}
			logger.error("AmqTrafficEventLinkageActionService-publishTrafficEventLinkageAction error:" + msg);
			e.printStackTrace();
		}
		return msg;
	}
	
	/*
	 * AMQͳɹڲͨ豸ǰ״̬ʷ״̬
	 * 1ȸ豸idж豸Ƿ豸ǰ״̬Уڸ¼¼
	 * 2ڣ¼һ¼豸ǰ״̬
	 * */
	public synchronized String operateTrafficCurrState(String msg,String deviceId,String deviceInstruction,String deviceType,String operationType,String operationId,String alarmCode) {
		//½ͨ豸ǰ״̬
		try{
			//step2AMQͳɹڲͨ豸ǰ״̬ʷ״̬
			if("3".equals(msg)){
				String[] device_str = deviceId.split(";"); //豸ID÷ֺŸ
				String[] deviceInstructions = deviceInstruction.split("#");
				for(int i=0;i<device_str.length;i++){  //ÿ豸ŵΪһ¼
					Map map_curr = new HashMap();
					map_curr.put("deviceId", device_str[i]);
					map_curr.put("deviceType", deviceType);
					//step1豸ź豸Ͳѯǰ豸ڱǷ
					TrafficdevicecurrstateBean bean_curr = BeanHelper.getTrafficdevicecurrstateDao().get_Trafficdevicecurrstate(map_curr);
					if(bean_curr==null){ 
						//step3豸״̬вڼ¼һ¼
						TrafficdevicecurrstateBean trafficCurrBean = new TrafficdevicecurrstateBean();
						trafficCurrBean.setID(StringUtil.getUUID());
						trafficCurrBean.setOperationType(operationType); //ͣ룬1-ԤִУ2-˹༭3-˹
						trafficCurrBean.setOperationId(operationId); //
						trafficCurrBean.setDeviceType(deviceType); //豸ͣ룬 1-Ϣ2-յ 3-ǽ 4-ƽ̨ͨţ 5-ѣ6-ⱨ7-֪ͨ99-Ԥ
						trafficCurrBean.setDeviceId(device_str[i]); //豸ID 
						trafficCurrBean.setDeviceState("1");  //豸״̬룬0-ߣ1-ߣ2-쳣
						trafficCurrBean.setAlarmCode(alarmCode);
						trafficCurrBean.setMessageSubject("subject.trafficEventLinkageAction");   //Ϣָ
						trafficCurrBean.setMessageContent(deviceInstructions[i]);//Ϣָ
						trafficCurrBean.setMessageSendTime(DateUtil.getDateTimeStr(new java.util.Date()));  //Ϣָʱ
						trafficCurrBean.setMessageSendState("2");   //Ϣָ״̬룻1-δִУ2-ִУ3-ִгɹ4-ִʧܡ
						trafficCurrBean.setSynchronize("1");  //Ƿͬ0-δͬ1-ͬ
						trafficCurrBean.setSynchronizeTime(DateUtil.getDateTimeStr(new java.util.Date()));  //ͬʱ
						trafficCurrBean.setCreateAccount("AMQ");  //
						trafficCurrBean.setCreateTime(DateUtil.getDateTimeStr(new java.util.Date()));
						trafficCurrBean.setModifyAccount("AMQ"); //޸
						trafficCurrBean.setModifyTime(DateUtil.getDateTimeStr(new java.util.Date()));
						BeanHelper.getTrafficdevicecurrstateDao().insert_Trafficdevicecurrstate(trafficCurrBean);
					}else{ 
						//step3ͨ豸״̬Ѵڼ¼µǰ״̬
						Map updateMap = new HashMap();  //XGTJoperationId
						updateMap.put("operationType", operationType); //ͣ룬1-ԤִУ2-˹༭3-˹
						updateMap.put("operationId", operationId); //
						updateMap.put("alarmCode", alarmCode);
						updateMap.put("messageContent", deviceInstructions[i]); //Ϣָ
						updateMap.put("messageSendTime", DateUtil.getDateTimeStr(new java.util.Date())); //Ϣָʱ
						updateMap.put("messageSendState", "2"); //Ϣָ״̬룻1-δִУ2-ִУ3-ִгɹ4-ִʧܡ
						updateMap.put("modifyAccount", "AMQ"); 
						updateMap.put("modifyTime", DateUtil.getDateTimeStr(new java.util.Date())); 
						//޸
						updateMap.put("XGTJdeviceType", deviceType); //豸ͣ룬 1-Ϣ2-յ 3-ǽ 4-ƽ̨ͨţ 5-ѣ6-ⱨ7-֪ͨ99-Ԥ
						updateMap.put("XGTJdeviceId", device_str[i]); //豸ID 
						BeanHelper.getTrafficdevicecurrstateDao().update_Trafficdevicecurrstate(updateMap);
						//step3ʷ״̬вϴ״̬¼
						TrafficdevicehisstateBean trafficHistoryBean = new TrafficdevicehisstateBean();
						trafficHistoryBean.setID(StringUtil.getUUID());
						trafficHistoryBean.setCurrentID(bean_curr.getID());
						trafficHistoryBean.setOperationType(bean_curr.getOperationType());
						trafficHistoryBean.setOperationId(bean_curr.getOperationId());
						trafficHistoryBean.setDeviceType(bean_curr.getDeviceType());
						trafficHistoryBean.setDeviceId(device_str[i]);
						trafficHistoryBean.setDeviceState(bean_curr.getDeviceState());
						trafficHistoryBean.setAlarmCode(bean_curr.getAlarmCode());
						trafficHistoryBean.setMessageSendState(bean_curr.getMessageSendState());
						trafficHistoryBean.setMessageSubject(bean_curr.getMessageSubject());
						trafficHistoryBean.setMessageContent(bean_curr.getMessageContent());
						trafficHistoryBean.setMessageSendTime(bean_curr.getMessageSendTime());
						trafficHistoryBean.setSynchronize(bean_curr.getSynchronize());
						trafficHistoryBean.setSynchronizeTime(bean_curr.getSynchronizeTime());
						trafficHistoryBean.setCreateAccount(bean_curr.getCreateAccount());
						trafficHistoryBean.setCreateTime(bean_curr.getCreateTime());
						trafficHistoryBean.setModifyAccount(bean_curr.getModifyAccount());
						trafficHistoryBean.setModifyTime(bean_curr.getModifyTime());
						BeanHelper.getTrafficdevicehisstateDao().insert_Trafficdevicehisstate(trafficHistoryBean);
					}
				}
			}
		}catch(Exception ex){
			//errorMsg = "͡豸AMQ쳣豸δɹ";
			if("3".equals(msg)){
				msg = "1";  //0豸AMQʧܣ1:豸AMQͳɹͨ豸ǰ״̬־ʧܣ2:豸AMQͳɹͨ豸ǰ״̬³ɹ־дʧܣ3AMQͳɹ־дɹ
			}
			logger.error("豸AMQϢͳɹ豸ǰ״̬쳣");
			logger.error("AmqTrafficEventLinkageActionService-publishTrafficEventLinkageActionoperateTrafficCurrState error:" + msg);
			ex.printStackTrace();
			//return msg;
		}
		return msg;
	}
	
	/**
	 * ȡ豸AMQϢ
	 * */
	public void doTrafficEventLinkageAction(AmqBasisEvent amqBasisMsg) {
		TrafficEventLinkageActionHolder linkalarm = (TrafficEventLinkageActionHolder)amqBasisMsg;
		System.out.println("-------****************----豸AMQȡϢ--------****************----------------");
		//List<TrafficEventLinkageAction> list = entity.getList();
		//for (TrafficEventLinkageAction linkalarm : list) {
			System.out.println("EventId = " + linkalarm.getEventId());
			System.out.println("DeviceType = " + linkalarm.getDeviceType());
			System.out.println("DeviceId = " + linkalarm.getDeviceId());
			System.out.println("DeviceInstruction = " + linkalarm.getDeviceInstruction());
		//}
		System.out.println("-------****************----豸AMQȡϢ--------****************----------------");
		
		//ݿʾ
		//List<TrafficEventLinkageAction> ls = entity.getList();
		//BeanHelper.getAmqPoliceCaseAlarmData().setPoliceCaseAlarmListAdd(ls);
	}
	
	public void handleClose(SocketChannel channel) {
		
	}

}
