package cn.yw.zxld.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.zxld.dao.ZxldDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zxldService")
public class ZxldService extends BaseService {

	private static final Log log = LogFactory.getLog(ZxldService.class);

	@Autowired
	private ZxldDao zxldDao;

	/**
	 * ¼
	 */
	public void insert_Zxld(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		zxldDao.insert_Zxld(map);
	}


	/**
	 * ޸ļ¼
	 */
	public Integer update_Zxld(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return zxldDao.update_Zxld(map);
	}
	public Integer delete_channelset_Zxld(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		return zxldDao.delete_channelset_Zxld(map);
	}

	/**
	 * ޸ļ¼
	 */
	public Integer update_ZxldRemarks(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return zxldDao.update_ZxldRemarks(map);
	}

	/**
	 * ɾ¼
	 */
	public Integer delete_Zxld(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return zxldDao.delete_Zxld(map);
	}

	/**
	 * ɾ¼
	 */
	public Integer batch_delete_Zxld(Map m) throws SQLException{
		return zxldDao.batch_delete_Zxld(m);
	}
	public Integer batch_update_Zxld(Map m) throws SQLException{
		return zxldDao.batch_update_Zxld(m);
	}

	/**
	 * ѯ
	 */
	public Integer count_Zxld(Map map) throws SQLException{
		return zxldDao.count_Zxld(map);
	}

	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Zxld(Map map) throws SQLException{
		return zxldDao.query_Zxld(map);
	}
	public List<Map> query_Zxld_children(Map map) throws SQLException{
		return zxldDao.query_Zxld_children(map);
	}

	/**
	 * ѯһ
	 */

	public Map get_Zxld(Map map) throws SQLException{
		return zxldDao.get_Zxld(map);
	}

	/**
	 * EXCEL
	 */

	/*
	public Map exportZxld(Map map) throws SQLException{
		return this.listZxldByPage(map);
	}
	*/

	public List<Map> getApproveUser(Map map) throws SQLException{
		return zxldDao.getApproveUser(map);
	}

	/**
	 * Zxld ҳ
	 */
	public Map listZxldByPage(Map map) throws SQLException {
		List<Map> list = zxldDao.query_Zxld(map);
		Integer totalCount = zxldDao.count_Zxld(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public Map listZxldNotaskByPage(Map map) throws SQLException {
		List<Map> list = zxldDao.query_ZxldNotaskByPage(map);
		Integer totalCount = zxldDao.count_ZxldNotask(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public Map listZxldtaskByPage(Map map) throws SQLException {
		List<Map> list = zxldDao.query_ZxldtaskByPage(map);
		Integer totalCount = zxldDao.count_Zxldtask(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	public Integer batchdelete_Zxld(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return zxldDao.batchdelete_Zxld(map);
	}
	public void batchinsert_Zxld(List map) throws SQLException{
		zxldDao.batchinsert_Zxld(map);
	}


	// 
	public Integer edit_Zxld(Map map) throws SQLException{
		return zxldDao.edit_Zxld(map);
	}


	/**
	 * ҳյͳ
	 * @return
	 * @throws SQLException
	 */
	public Map statisticsZxldRate() throws SQLException{
		return zxldDao.statisticsZxldRate();
	}

	/**
	 * ǰ״̬ѯ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listZxldcurrentstateByPage(Map map) throws SQLException {
		List<Map> list = zxldDao.query_ZxldcurrentstateByPage(map);
		Integer totalCount = zxldDao.count_currentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	/**
	 * 豸ǰ״̬ѯ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listZxldcurrentstate(Map map) throws SQLException {
		List<Map> list = zxldDao.query_Zxldcurrentstate(map);
		Integer totalCount = zxldDao.count_currentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}



	/****
	 * ʷ״̬ѯ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listZxldHistoryStateByPage(Map map) throws SQLException {
		List<Map> list = zxldDao.listZxldHistoryStateByPage(map);
		Integer totalCount = zxldDao.count_ZxldHistoryState(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}


	/**
	 * ¾γȼ¼
	 */
	public Integer updateZxldByXh(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return zxldDao.updateZxldByXh(map);
	}
	/**
	 * µǰά״̬
	 */
	public Integer update_ZxldCurrentState(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return zxldDao.update_ZxldCurrentState(map);
	}


}
