package cn.yw.sign.action;


import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.*;
import cn.yw.sign.service.SignService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

//import cn.base.excel.ExcelReader;

@SuppressWarnings({"all"})
@Component("signAction")
public class SignAction extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger iLog = Logger.getLogger(SignAction.class);

    @Autowired
    private SignService service;
   

    /**
     * ҳ
     */
    @OperateType(value = LogConstants.LOG_QUERY, info = "listSignByPage")
    public void listSignByPage() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            int page = Integer.parseInt(Struts2Utils.getParameter("page"));
            int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
            int start = ((page == 0 ? 1 : page) - 1) * rows;
            map.put("start", start);
            map.put("limit", rows);
            //жǷǹԱ
            if(null!=map.get("sfgly")&& "1".equals(map.get("sfgly")))//Ա
            {
                if(null!=map.get("user_id")) {//ȥuserid  ѯ
                    map.remove("user_id");
                }
            }
            Struts2Utils.renderJson(this.service.listSignByPage(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-listSignByPage-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ Sign
     */
    @OperateType(value = LogConstants.LOG_GET, info = "query_Sign")
    public void query_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            //жǷǹԱ
            if(null!=map.get("sfgly")&& "1".equals(map.get("sfgly")))//Ա
            {
                if(null!=map.get("user_id")) {//ȥuserid  ѯ
                    map.remove("user_id");
                }
            }
            Struts2Utils.renderJson(this.service.query_Sign(map));
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-query_Sign-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ѯ һSign
     */
    @OperateType(value = LogConstants.LOG_GET, info = "get_Sign")
    public void get_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            // ȡû
            Map SignMap = this.service.get_Sign(map);
            Struts2Utils.renderJson(SignMap);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignActionquery_Sign-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "deleteSign")
    public void delete_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!CommUtils.isEmpty(map)) {
                int result = service.delete_Sign(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            } else {
                throw new Exception("ȷѡɾ¼!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-delete_Sign-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * 
     */
    @OperateType(value = LogConstants.LOG_ADD, info = "insert_Sign")
    public void insert_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (StringUtil.checkEmpty(map.get("id"))) {
                map.put("id", StringUtil.getUUID());
            }
            service.insert_Sign(map);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-insert_Sign()-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }


    /**
     * ޸
     */
    @OperateType(value = LogConstants.LOG_UPDATE, info = "update_Sign")
    public void update_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            if (!StringUtil.checkEmpty(map.get("checkparam"))) {
                Map sMap = new HashMap();
                sMap.put("tableparam", map.get("checkparam"));
                List ls = service.query_Sign(sMap);
                if (!StringUtil.checkEmpty(ls) || ls.size() > 0) {
                    Struts2Utils.renderJson(Constants.SAME);
                } else {
                    int result = service.update_Sign(map);
                    Struts2Utils.renderJson(Constants.SUCCESS);
                }
            } else {
                int result = service.update_Sign(map);
                Struts2Utils.renderJson(Constants.SUCCESS);
            }
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-update_Sign-error: " + e);
            Struts2Utils.renderJson(null);
        }
    }

    /**
     * ɾ
     */
    @OperateType(value = LogConstants.LOG_DELETE, info = "batch_delete_Sign")
    public void batch_delete_Sign() {
        Map map = Struts2Utils.getRequestParameterMap();
        try {
            Map m = new HashMap();
            m.put("keyword", map.get("keyword").toString());
            int result = service.batch_delete_Sign(m);
            Struts2Utils.renderJson(Constants.SUCCESS);
        } catch (Exception e) {
            e.printStackTrace();
            iLog.error("SignAction-batch_delete_Sign-error:" + e);
            Struts2Utils.renderJson(null);
        }
    }

}
