package cn.yw.operationcount.latandloncount.action;


import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.excel.ExportExcel;
import cn.base.pdf.ExportPDF;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.operationcount.latandloncount.service.YwcountlalcollectService;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywcountlalcollectAction")
public class YwcountlalcollectAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwcountlalcollectAction.class);
	
	@Autowired
	private YwcountlalcollectService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwcountlalcollectByPage")
	public void listYwcountlalcollectByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			map.put("bmbh", bmbh);
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwcountlalcollectByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-listYwcountlalcollectByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywcountlalcollect")
	public void count_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywcountlalcollect(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-count_Ywcountlalcollect-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywcountlalcollect
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywcountlalcollect")
	public void query_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywcountlalcollect(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-query_Ywcountlalcollect-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwcountlalcollect
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywcountlalcollect")
	public void get_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywcountlalcollect(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectActionquery_Ywcountlalcollect-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwcountlalcollect")
	public void delete_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywcountlalcollect(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-delete_Ywcountlalcollect-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywcountlalcollect")
	public void insert_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("countId"))){
				map.put("countId",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountlalcollect(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywcountlalcollect(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywcountlalcollect(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-insert_Ywcountlalcollect()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywcountlalcollect")
	public void update_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountlalcollect(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywcountlalcollect(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywcountlalcollect(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-update_Ywcountlalcollect-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywcountlalcollect")
	public void batch_delete_Ywcountlalcollect(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywcountlalcollect(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-batch_delete_Ywcountlalcollect-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountlalcollect")
	public void exp_Ywcountlalcollect(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			List<Map> sList = service.query_Ywcountlalcollect(queryMap);		
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			
			headerList.add("");
			headerList.add("");
			headerList.add("ص");
			headerList.add("޾γ");
			headerList.add("γȱʧ");
			headerList.add("γЧ");
			headerList.add("γ");
			headerList.add("γȲɼ");
			int monitorSum = 0;
			int nolalSum = 0;
			int invalidlalSum = 0;
			int laldefectSum = 0;
			int lalcompleteSum = 0;
			for(int i  =0;i<sList.size();i++ ){
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", sList.get(i).get("areaname"));
				
				monitorSum += StringUtil.str2Numeric(sList.get(i).get("monitortotal")+"");
				exportMap.put("ص", sList.get(i).get("monitortotal"));
				
				nolalSum += StringUtil.str2Numeric(sList.get(i).get("nolalcount")+"");
				exportMap.put("޾γ", sList.get(i).get("nolalcount"));
				
				invalidlalSum += StringUtil.str2Numeric(sList.get(i).get("laldefectcount")+"");
				exportMap.put("γȱʧ", sList.get(i).get("laldefectcount"));
				
				laldefectSum += StringUtil.str2Numeric(sList.get(i).get("invalidlalcount")+"");
				exportMap.put("γЧ", sList.get(i).get("invalidlalcount"));
				
				lalcompleteSum += StringUtil.str2Numeric(sList.get(i).get("lalcompletecount")+"");
				exportMap.put("γ", sList.get(i).get("lalcompletecount"));
				exportMap.put("γȲɼ", sList.get(i).get("lalcollectionrate"));
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			footerList.add( "ܼ");
			footerList.add("ܼ");
			footerList.add( monitorSum);
			footerList.add( nolalSum);
			footerList.add(invalidlalSum);
			footerList.add( laldefectSum);
			footerList.add( lalcompleteSum);
			footerList.add( new DecimalFormat(".00").format(lalcompleteSum*100.0/monitorSum)+"%");
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ͳƾγȲɼ-"+dateTime);
			params.put("sheetName", "ͳƾγȲɼ");
			params.put("header", "ͳƾγȲɼ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
			new ExportExcel().exportCommExcel(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-exoprtPDF-error:" +e);
			
		}
	}
	
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Ywcountlalcollect")
	public void expPDF_Ywcountlalcollect(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			List<Map> sList = service.query_Ywcountlalcollect(queryMap);		
			List<Map> expList = new ArrayList<Map>();
			
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			
			headerList.add("");
			headerList.add("");
			headerList.add("ص");
			headerList.add("޾γ");
			headerList.add("γȱʧ");
			headerList.add("γЧ");
			headerList.add("γ");
			headerList.add("γȲɼ");
			int monitorSum = 0;
			int nolalSum = 0;
			int invalidlalSum = 0;
			int laldefectSum = 0;
			int lalcompleteSum = 0;
			for(int i  =0;i<sList.size();i++ ){
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", sList.get(i).get("areaname"));
				
				monitorSum += StringUtil.str2Numeric(sList.get(i).get("monitortotal")+"");
				exportMap.put("ص", sList.get(i).get("monitortotal"));
				
				nolalSum += StringUtil.str2Numeric(sList.get(i).get("nolalcount")+"");
				exportMap.put("޾γ", sList.get(i).get("nolalcount"));
				
				invalidlalSum += StringUtil.str2Numeric(sList.get(i).get("laldefectcount")+"");
				exportMap.put("γȱʧ", sList.get(i).get("laldefectcount"));
				
				laldefectSum += StringUtil.str2Numeric(sList.get(i).get("invalidlalcount")+"");
				exportMap.put("γЧ", sList.get(i).get("invalidlalcount"));
				
				lalcompleteSum += StringUtil.str2Numeric(sList.get(i).get("lalcompletecount")+"");
				exportMap.put("γ", sList.get(i).get("lalcompletecount"));
				exportMap.put("γȲɼ", sList.get(i).get("lalcollectionrate"));
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			footerList.add( "ܼ");
			footerList.add("ܼ");
			footerList.add( monitorSum);
			footerList.add( nolalSum);
			footerList.add(invalidlalSum);
			footerList.add( laldefectSum);
			footerList.add( lalcompleteSum);
			footerList.add( new DecimalFormat(".00").format(lalcompleteSum*100.0/monitorSum)+"%");
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ͳƾγȲɼ-"+dateTime);
			params.put("sheetName", "ͳƾγȲɼ");
			params.put("header", "ͳƾγȲɼ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
			new ExportPDF().exportCommPDF(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountlalcollectAction-exoprtExcel-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywcountlalcollect")
	public String imp_Ywcountlalcollect(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwcountlalcollectAction-imp_Ywcountlalcollect-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
