package cn.yw.nhyw.nhywjtjxgl.service;

import cn.yw.nhyw.nhywjtjxgl.dao.NhywjtjxglDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("nhywjtjxglService")
public class NhywjtjxglService extends BaseService {

	private static Log log = LogFactory.getLog(NhywjtjxglService.class);

	@Autowired
	private NhywjtjxglDao nhywjtjxglDao;

	/**
	 * �����¼
	 */
	public void insert_Nhywjtjxgl(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		nhywjtjxglDao.insert_Nhywjtjxgl(map);
	}


	/**
	 * �޸ļ�¼
	 */
	public Integer update_Nhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.update_Nhywjtjxgl(map);
	}

	/**
	 * 首页诱导屏统计
	 * @return
	 * @throws SQLException
	 */
	public Map statisticsJXRate() throws SQLException{
		return nhywjtjxglDao.statisticsJXRate();
	}




	/**
	 * 当前状态查询
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listJXcurrentstateByPage(Map map) throws SQLException {
		List<Map> list = nhywjtjxglDao.query_JXcurrentstateByPage(map);
		Integer totalCount = nhywjtjxglDao.count_currentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	/**
	 * 所有设备当前状态查询
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listJXcurrentstate(Map map) throws SQLException {
		List<Map> list = nhywjtjxglDao.query_JXcurrentstate(map);
		Integer totalCount = nhywjtjxglDao.count_currentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}

	/**
	 * �޸ľ�γ��
	 */
	public Integer updateJtjxJdWdByXh(Map map) throws SQLException{
		CommUtils.addParams(map, true);
		return nhywjtjxglDao.updateJtjxJdWdByXh(map);
	}

	/**
	 * ɾ����¼
	 */
	public Integer delete_Nhywjtjxgl(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return nhywjtjxglDao.delete_Nhywjtjxgl(map);
	}

	/**
	 * ������ɾ����¼
	 */
	/*
	public Integer batch_delete_Nhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.batch_delete_Nhywjtjxgl(map);
	}
	*/

	/**
	 * ��ѯ����
	 */
	/*
	public Integer count_Nhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.count_Nhywjtjxgl(map);
	}
	*/

	/**
	 * ��ѯ�б��¼SELECT
	 */
	public List<Map> query_Nhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.query_Nhywjtjxgl(map);
	}

	/**
	 * ��ѯȫ����¼
	 */
	public List<Map> query_AllNhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.query_AllNhywjtjxgl(map);
	}

	/**
	 * ��ѯһ��
	 */
	public Map get_Nhywjtjxgl(Map map) throws SQLException{
		return nhywjtjxglDao.get_Nhywjtjxgl(map);
	}

	/**
	 * ����EXCEL
	 */

	/*
	public Map exportNhywjtjxgl(Map map) throws SQLException{
		return this.listNhywjtjxglByPage(map);
	}
	*/

	/**
	 * Nhywjtjxgl ��ҳ
	 */
	public Map listNhywjtjxglByPage(Map map) throws SQLException {
		List<Map> list = nhywjtjxglDao.query_Nhywjtjxgl(map);
		Integer totalCount = nhywjtjxglDao.count_Nhywjtjxgl(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}



	public Map  listNhywjtjxglHistoryStateByPage(Map  map) 	throws SQLException {
		List<Map> list = nhywjtjxglDao.query_NhywjtjxglHistoryStateByPage(map);
		Integer totalCount = nhywjtjxglDao.count_NhywjtjxglHistoryState(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
