package cn.yw.nhyw.nhywjtjxgl.action;

import cn.yw.nhyw.nhywjtjxgl.service.NhywjtjxglService;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.FTPUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("nhywjtjxglAction")
public class NhywjtjxglAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywjtjxglAction.class);

	@Autowired
	private NhywjtjxglService service;

	/**
	 * ��ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywjtjxglByPage")
	public void listNhywjtjxglByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywjtjxglByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-listNhywjtjxglByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ��ѯ����
	 */
	/*
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywjtjxgl")
	public void count_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywjtjxgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-count_Nhywjtjxgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * ��ѯ Nhywjtjxgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywjtjxgl")
	public void query_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_AllNhywjtjxgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-query_Nhywjtjxgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ��ѯ һ��Nhywjtjxgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywjtjxgl")
	public void get_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywjtjxgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglActionquery_Nhywjtjxgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ɾ��
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Nhywjtjxgl")
	public void delete_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				String zpUrl = (String) map.get("sjzp");
				if(RHUtil.isNotEmpty(zpUrl) && !"null".equals(zpUrl)) {
					FTPUtil.deleteFileFromFtpUrl(zpUrl);
				}
				int result = service.delete_Nhywjtjxgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				throw new Exception("����ȷ��ѡ��ɾ����¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-delete_Nhywjtjxgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ����
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywjtjxgl")
	public void insert_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjtjxgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywjtjxgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywjtjxgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-insert_Nhywjtjxgl()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 在线率统计
	 */
	@OperateType(value = LogConstants.LOG_GET, info = "statisticsJXRate")
	public void statisticsJXRate() {
		try {
			Struts2Utils.renderJson(this.service.statisticsJXRate());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * �޸�
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywjtjxgl")
	public void update_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjtjxgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywjtjxgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywjtjxgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-update_Nhywjtjxgl-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * �޸ľ�γ��
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateJtjxJdWdByXh")
	public void updateJtjxJdWdByXh() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjtjxgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.updateJtjxJdWdByXh(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.updateJtjxJdWdByXh(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-updateJtjxJdWdByXh-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 *
	 * 实时状态查询
	 */
	@OperateType(value = LogConstants.LOG_GET, info = "listJXcurrentstateByPage")
	public void listJXcurrentstateByPage() {
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			if(null!=Struts2Utils.getParameter("page")) {
				int page = Integer.parseInt(Struts2Utils.getParameter("page"));
				int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
				int start = ((page == 0 ? 1 : page) - 1) * rows;
				map.put("start", start);
				map.put("limit", rows);
				Struts2Utils.renderJson(this.service.listJXcurrentstateByPage(map));
			}else{

				Struts2Utils.renderJson(this.service.listJXcurrentstate(map));
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ZxldAction-statisticsZxldRate-error:" + e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ����ɾ��
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywjtjxgl")
	public void batch_delete_Nhywjtjxgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywjtjxgl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-batch_delete_Nhywjtjxgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * ����Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywjtjxgl")
	public void exp_Nhywjtjxgl(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywjtjxgl(map);
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"�û��˺�", "�û�����"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        	String dateTime=formart.format(new Date());
			Map params = new HashMap();
			params.put("fileName", "��ͨ��������-"+dateTime);
			params.put("sheetName", "��ͨ��������");
			params.put("header", "��ͨ��������");
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtjxglAction-exoprtExcel-error:" +e);

		}
	}
	*/

	/**
	 * ����Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywjtjxgl")
	public String imp_Nhywjtjxgl(String excelFile,Object user) {
		String rs = "�����ʽ����!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {

			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("������count--->" + count);
			rs = " �������ݳɹ����ܹ�"+ dataCount +"������,�ظ�"+repeatNum+"�����ݣ�ʧ��"+failNum+"������!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "��Դ���ֵ���(����)ʧ�ܣ�Excel��" + rowNum + "����δ����(����)�ɹ���";
			} else {
				rs = "��Դ����(����)ʧ�ܣ�";
			}
			iLog.error("NhywjtjxglAction-imp_Nhywjtjxgl-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/



	//查询信号灯历史状态,关联运维表 获得区域名称，路口名称，路灯名称
	@OperateType(value = LogConstants.LOG_QUERY, info = "listNhywjtjxglHistoryStateByPage")
	public void listNhywjtjxglHistoryStateByPage() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			//信号灯的历史异常信息
			Map xhdhistory = this.service.listNhywjtjxglHistoryStateByPage(map);
			Struts2Utils.renderJson(xhdhistory);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("nhywjtxhdglAction-listNhywjtxhdglHistoryStateByPage-error:" + e);
			Struts2Utils.renderJson(null);
		}
	}
}
