package cn.yw.alarmtaskmanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarmtaskmanage.service.YwalarmrulefordeviceService;

@SuppressWarnings({"all"})
@Component("ywalarmrulefordeviceAction")
public class YwalarmrulefordeviceAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwalarmrulefordeviceAction.class);
	
	@Autowired
	private YwalarmrulefordeviceService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwalarmrulefordeviceByPage")
	public void listYwalarmrulefordeviceByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwalarmrulefordeviceByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-listYwalarmrulefordeviceByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywalarmrulefordevice")
	public void count_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywalarmrulefordevice(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-count_Ywalarmrulefordevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywalarmrulefordevice
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywalarmrulefordevice")
	public void query_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywalarmrulefordevice(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-query_Ywalarmrulefordevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwalarmrulefordevice
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywalarmrulefordevice")
	public void get_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywalarmrulefordevice(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceActionquery_Ywalarmrulefordevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwalarmrulefordevice")
	public void delete_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywalarmrulefordevice(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-delete_Ywalarmrulefordevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywalarmrulefordevice")
	public void insert_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(StringUtil.checkEmpty(map.get("relateid"))){
				map.put("relateid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmrulefordevice(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywalarmrulefordevice(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywalarmrulefordevice(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-insert_Ywalarmrulefordevice()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywalarmrulefordevice")
	public void update_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmrulefordevice(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywalarmrulefordevice(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywalarmrulefordevice(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-update_Ywalarmrulefordevice-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywalarmrulefordevice")
	public void batch_delete_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keywords = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keywords)) {
				String[] ids = keywords.split(",");
				map.clear();
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywalarmrulefordevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-batch_delete_Ywalarmrulefordevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_Ywalarmrulefordevice")
	public void edit_Ywalarmrulefordevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			String ids = (String) map.get("ids");
			if(RHUtil.isNotEmpty(ids)) {
				String[] keys = ids.split(",");
				map.put("keys", keys);
			}				
			int result = service.edit_Ywalarmrulefordevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-edit_Ywalarmrulefordevice-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ѯ δ豸             澯Ҳ豸Ϣ 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="get_leftDevice")
	public void get_leftDevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			String alarmsource = (String) map.get("alarmsource");
			String alarmtype = (String) map.get("alarmtype");
			if(RHUtil.isNotEmpty(alarmsource)) {
				if("1".equals(alarmsource)) {				//ظ澯
					Struts2Utils.renderJson(this.service.get_leftVideoDevice(map));	
				}else if("2".equals(alarmsource)) {			//澯	
					if("4".equals(alarmtype)) {				// 1-쳣      2-CPU澯      3-ڴ澯      4-Ӳ̸澯
						Struts2Utils.renderJson(this.service.get_leftDiskDevice(map));
					}else if("2".equals(alarmtype)){
						Struts2Utils.renderJson(this.service.get_leftCPUdevice(map));
					}else if("3".equals(alarmtype)) {
						Struts2Utils.renderJson(this.service.get_leftMemorydevice(map));
					}else if("1".equals(alarmtype)) {						
						Struts2Utils.renderJson(this.service.get_leftServerDevice(map));
					}
				}else if("3".equals(alarmsource)) {			//Ӧϵͳ澯
					Struts2Utils.renderJson(this.service.get_leftSoftDevice(map));
				}else if("4".equals(alarmsource)) {			//洢澯
					
				}
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-get_leftDevice-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	
	
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywalarmrulefordevice")
	public void exp_Ywalarmrulefordevice(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywalarmrulefordevice(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά澯豸-"+dateTime);
			params.put("sheetName", "ά澯豸");
			params.put("header", "ά澯豸");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefordeviceAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywalarmrulefordevice")
	public String imp_Ywalarmrulefordevice(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwalarmrulefordeviceAction-imp_Ywalarmrulefordevice-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
