package cn.yw.alarmcode.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.alarmcode.dao.GjbhxxDao;

@Service("gjbhxxService")
public class GjbhxxService extends BaseService {
	
	private static final Log log = LogFactory.getLog(GjbhxxService.class);
	
	@Autowired
	private GjbhxxDao gjbhxxDao;
	
	/**
	 * ¼
	 */
	public void insert_Gjbhxx(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		gjbhxxDao.insert_Gjbhxx(map);
	}

	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Gjbhxx(Map map) throws SQLException{
		return gjbhxxDao.query_Gjbhxx(map);
	}
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Gjbhxx(Map map) throws SQLException{
		return gjbhxxDao.get_Gjbhxx(map);
	}
	/**
	 * ޸ļ¼
	 */
	public Integer update_Gjbhxx(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return gjbhxxDao.update_Gjbhxx(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Gjbhxx(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return gjbhxxDao.delete_Gjbhxx(map);
	}

	/**
	 * Gjbhxx ҳ
	 */
	public Map listGjbhxxByPage(Map map) throws SQLException {
		List<Map> list = gjbhxxDao.query_Gjbhxx(map);
		Integer totalCount = gjbhxxDao.count_Gjbhxx(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
